/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.cometd.annotation.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AnnotationProcessor {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    AnnotationProcessor() {
    }

    protected boolean processPostConstruct(Object bean) {
        if (bean == null) {
            return false;
        }
        ArrayList<Method> postConstructs = new ArrayList<Method>();
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Method[] methods;
            boolean foundInClass = false;
            for (Method method : methods = c.getDeclaredMethods()) {
                PostConstruct postConstruct = method.getAnnotation(PostConstruct.class);
                if (postConstruct == null) continue;
                if (foundInClass) {
                    throw new RuntimeException("Invalid @PostConstruct method " + method + ": another method with the same annotation exists");
                }
                foundInClass = true;
                if (method.getReturnType() != Void.TYPE) {
                    throw new RuntimeException("Invalid @PostConstruct method " + method + ": it must have void return type");
                }
                if (method.getParameterTypes().length > 0) {
                    throw new RuntimeException("Invalid @PostConstruct method " + method + ": it must have no parameters");
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException("Invalid @PostConstruct method " + method + ": it must not be static");
                }
                postConstructs.add(method);
            }
        }
        Collections.reverse(postConstructs);
        boolean result = false;
        for (Method method : postConstructs) {
            this.invokePrivate(bean, method, new Object[0]);
            result = true;
        }
        return result;
    }

    protected boolean processPreDestroy(Object bean) {
        if (bean == null) {
            return false;
        }
        ArrayList<Method> preDestroys = new ArrayList<Method>();
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Method[] methods;
            boolean foundInClass = false;
            for (Method method : methods = c.getDeclaredMethods()) {
                PreDestroy preDestroy = method.getAnnotation(PreDestroy.class);
                if (preDestroy == null) continue;
                if (foundInClass) {
                    throw new RuntimeException("Invalid @PreDestroy method " + method + ": another method with the same annotation exists");
                }
                foundInClass = true;
                if (method.getReturnType() != Void.TYPE) {
                    throw new RuntimeException("Invalid @PreDestroy method " + method + ": it must have void return type");
                }
                if (method.getParameterTypes().length > 0) {
                    throw new RuntimeException("Invalid @PreDestroy method " + method + ": it must have no parameters");
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new RuntimeException("Invalid @PreDestroy method " + method + ": it must not be static");
                }
                preDestroys.add(method);
            }
        }
        boolean result = false;
        for (Method method : preDestroys) {
            try {
                this.invokePrivate(bean, method, new Object[0]);
                result = true;
            }
            catch (RuntimeException x) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Exception while invoking @PreDestroy method " + method + ", ignoring", (Throwable)x);
            }
        }
        return result;
    }

    protected List<String> processParameters(Method method) {
        Annotation[][] parametersAnnotations;
        ArrayList<String> result = new ArrayList<String>();
        Annotation[][] annotationArray = parametersAnnotations = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation parameterAnnotation : parameterAnnotations = annotationArray[i]) {
                if (!(parameterAnnotation instanceof Param)) continue;
                result.add(((Param)parameterAnnotation).value());
            }
        }
        return result;
    }

    protected Object invokePrivate(Object bean, Method method, Object ... args) {
        boolean accessible = method.isAccessible();
        try {
            method.setAccessible(true);
            Object object = method.invoke(bean, args);
            return object;
        }
        catch (InvocationTargetException x) {
            throw new RuntimeException(x.getCause());
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    protected static Object invokePublic(Object target, Method method, Object ... arguments) {
        try {
            return method.invoke(target, arguments);
        }
        catch (InvocationTargetException x) {
            Throwable cause = x.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
    }

    protected Method findGetterMethod(Class<?> klass, Method setter) {
        try {
            String getterName;
            Method getter;
            String setterPrefix = "set";
            String setterName = setter.getName();
            if (setterName.startsWith(setterPrefix) && (setterName.length() == setterPrefix.length() || Character.isUpperCase(setterName.charAt(setterPrefix.length()))) && (getter = klass.getDeclaredMethod(getterName = "get" + setterName.substring(setterPrefix.length()), new Class[0])).getReturnType() == setter.getParameterTypes()[0]) {
                return getter;
            }
            return null;
        }
        catch (NoSuchMethodException x) {
            return null;
        }
    }

    protected Object getField(Object bean, Field field) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(bean);
            return object;
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected void setField(Object bean, Field field, Object value) {
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(bean, value);
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected static void checkSignaturesMatch(Method method, Class<?>[] expectedTypes, List<String> paramNames) {
        int i;
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != expectedTypes.length + paramNames.size()) {
            throw new IllegalArgumentException("Wrong number of parameters in service method: " + method.getName() + "(...)." + (paramTypes.length > 2 ? " Template parameters not annotated with @" + Param.class.getSimpleName() + " ?" : ""));
        }
        for (i = 0; i < expectedTypes.length; ++i) {
            Class<?> parameter;
            Class<?> expected = expectedTypes[i];
            if (expected == null || (parameter = paramTypes[i]).isAssignableFrom(expected)) continue;
            throw new IllegalArgumentException("Parameter type " + parameter.getName() + " must be instead " + expected.getName() + " in service method: " + method.getName() + "(...).");
        }
        for (i = 0; i < paramNames.size(); ++i) {
            Class<String> parameter = paramTypes[expectedTypes.length + i];
            if (parameter.isAssignableFrom(String.class)) continue;
            throw new IllegalArgumentException("Template parameter '" + paramNames.get(i) + "' must be of type " + String.class.getName() + " in service method: " + method.getName() + "(...).");
        }
    }

    protected boolean processInjectables(Object bean, List<Object> injectables) {
        boolean result = false;
        for (Object injectable : injectables) {
            result |= this.processInjectable(bean, injectable);
        }
        return result;
    }

    protected boolean processInjectable(Object bean, Object injectable) {
        boolean result = false;
        for (Class<?> c = bean.getClass(); c != Object.class; c = c.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                if (field.getAnnotation(Inject.class) == null || !field.getType().isAssignableFrom(injectable.getClass())) continue;
                Object value = this.getField(bean, field);
                if (value != null) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Avoid injection of field {} on bean {}, it's already injected with {}", new Object[]{field, bean, value});
                    continue;
                }
                this.setField(bean, field, injectable);
                result = true;
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Injected {} to field {} on bean {}", new Object[]{injectable, field, bean});
            }
            for (Method method : methods = c.getDeclaredMethods()) {
                Object value;
                Class<?>[] parameterTypes;
                if (method.getAnnotation(Inject.class) == null || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].isAssignableFrom(injectable.getClass())) continue;
                Method getter = this.findGetterMethod(c, method);
                if (getter != null && (value = this.invokePrivate(bean, getter, new Object[0])) != null) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Avoid injection of method {} on bean {}, it's already injected with {}", new Object[]{method, bean, value});
                    continue;
                }
                this.invokePrivate(bean, method, injectable);
                result = true;
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Injected {} to method {} on bean {}", new Object[]{injectable, method, bean});
            }
        }
        return result;
    }
}

