/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;

class MinimizeExitPoints
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    AbstractCompiler compiler;

    MinimizeExitPoints(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 126: {
                this.tryMinimizeExits(n.getLastChild(), 116, n.getFirstChild().getString());
                break;
            }
            case 113: 
            case 115: {
                this.tryMinimizeExits(NodeUtil.getLoopCodeBlock(n), 117, null);
                break;
            }
            case 114: {
                this.tryMinimizeExits(NodeUtil.getLoopCodeBlock(n), 117, null);
                Node cond = NodeUtil.getConditionExpression(n);
                if (NodeUtil.getImpureBooleanValue(cond) != TernaryValue.FALSE) break;
                this.tryMinimizeExits(n.getFirstChild(), 116, null);
                break;
            }
            case 105: {
                this.tryMinimizeExits(n.getLastChild(), 4, null);
            }
        }
    }

    void tryMinimizeExits(Node n, int exitType, String labelName) {
        if (MinimizeExitPoints.matchingExitNode(n, exitType, labelName)) {
            NodeUtil.removeChild(n.getParent(), n);
            this.compiler.reportCodeChange();
            return;
        }
        if (n.isIf()) {
            Node ifBlock = n.getFirstChild().getNext();
            this.tryMinimizeExits(ifBlock, exitType, labelName);
            Node elseBlock = ifBlock.getNext();
            if (elseBlock != null) {
                this.tryMinimizeExits(elseBlock, exitType, labelName);
            }
            return;
        }
        if (n.isTry()) {
            Node tryBlock = n.getFirstChild();
            this.tryMinimizeExits(tryBlock, exitType, labelName);
            Node allCatchNodes = NodeUtil.getCatchBlock(n);
            if (NodeUtil.hasCatchHandler(allCatchNodes)) {
                Preconditions.checkState((boolean)allCatchNodes.hasOneChild());
                Node catchNode = allCatchNodes.getFirstChild();
                Node catchCodeBlock = catchNode.getLastChild();
                this.tryMinimizeExits(catchCodeBlock, exitType, labelName);
            }
            if (NodeUtil.hasFinally(n)) {
                Node finallyBlock = n.getLastChild();
                this.tryMinimizeExits(finallyBlock, exitType, labelName);
            }
        }
        if (n.isLabel()) {
            Node labelBlock = n.getLastChild();
            this.tryMinimizeExits(labelBlock, exitType, labelName);
        }
        if (n.getType() != 125 || n.getLastChild() == null) {
            return;
        }
        for (Node c : n.children()) {
            if (c.isIf()) {
                Node ifTree = c;
                Node trueBlock = ifTree.getFirstChild().getNext();
                Node falseBlock = trueBlock.getNext();
                this.tryMinimizeIfBlockExits(trueBlock, falseBlock, ifTree, exitType, labelName);
                trueBlock = ifTree.getFirstChild().getNext();
                falseBlock = trueBlock.getNext();
                if (falseBlock != null) {
                    this.tryMinimizeIfBlockExits(falseBlock, trueBlock, ifTree, exitType, labelName);
                }
            }
            if (c != n.getLastChild()) continue;
            break;
        }
        Node c = n.getLastChild();
        while (c != null) {
            this.tryMinimizeExits(c, exitType, labelName);
            if (c == n.getLastChild()) break;
            c = n.getLastChild();
        }
    }

    private void tryMinimizeIfBlockExits(Node srcBlock, Node destBlock, Node ifNode, int exitType, String labelName) {
        Node exitNodeParent = null;
        Node exitNode = null;
        if (srcBlock.isBlock()) {
            if (!srcBlock.hasChildren()) {
                return;
            }
            exitNodeParent = srcBlock;
            exitNode = exitNodeParent.getLastChild();
        } else {
            exitNodeParent = ifNode;
            exitNode = srcBlock;
        }
        if (!MinimizeExitPoints.matchingExitNode(exitNode, exitType, labelName)) {
            return;
        }
        if (ifNode.getNext() != null) {
            Node newDestBlock = new Node(125).copyInformationFrom(ifNode);
            if (destBlock == null) {
                ifNode.addChildToBack(newDestBlock);
            } else if (destBlock.isEmpty()) {
                ifNode.replaceChild(destBlock, newDestBlock);
            } else if (destBlock.isBlock()) {
                newDestBlock = destBlock;
            } else {
                ifNode.replaceChild(destBlock, newDestBlock);
                newDestBlock.addChildToBack(destBlock);
            }
            MinimizeExitPoints.moveAllFollowing(ifNode, ifNode.getParent(), newDestBlock);
        }
        NodeUtil.removeChild(exitNodeParent, exitNode);
        this.compiler.reportCodeChange();
    }

    private static boolean matchingExitNode(Node n, int type, String labelName) {
        if (n.getType() == type) {
            if (type == 4) {
                return !n.hasChildren();
            }
            if (labelName == null) {
                return !n.hasChildren();
            }
            return n.hasChildren() && labelName.equals(n.getFirstChild().getString());
        }
        return false;
    }

    private static void moveAllFollowing(Node start, Node srcParent, Node destParent) {
        Node n = start.getNext();
        while (n != null) {
            boolean isFunctionDeclaration = NodeUtil.isFunctionDeclaration(n);
            srcParent.removeChild(n);
            if (isFunctionDeclaration) {
                destParent.addChildToFront(n);
            } else {
                destParent.addChildToBack(n);
            }
            n = start.getNext();
        }
    }
}

