/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views.impl;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.cms.views.impl.ManageViewPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.picocontainer.Startable;

public class ManageViewServiceImpl
implements ManageViewService,
Startable {
    private static final Log LOG = ExoLogger.getLogger((String)ManageViewServiceImpl.class.getName());
    protected static final String EXO_TEMPLATE = "exo:template";
    protected static final String ADMIN_VIEW = "admin";
    protected static final String DEFAULT_VIEW = "default";
    protected static final String EXO_PERMISSIONS = "exo:accessPermissions";
    protected static final String EXO_HIDE_EXPLORER_PANEL = "exo:hideExplorerPanel";
    protected static final String BUTTON_PROP = "exo:buttons";
    private final List<ManageViewPlugin> plugins_ = new ArrayList<ManageViewPlugin>();
    private List<?> buttons_;
    private final RepositoryService repositoryService_;
    private String baseViewPath_;
    private final NodeHierarchyCreator nodeHierarchyCreator_;
    private final DMSConfiguration dmsConfiguration_;
    private final UIExtensionManager extensionManager_;
    private TemplateService templateService;
    private Set<String> configuredTemplates_;
    private Set<String> configuredViews_;

    public ManageViewServiceImpl(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration, UIExtensionManager extensionManager) throws Exception {
        this.repositoryService_ = jcrService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.baseViewPath_ = this.nodeHierarchyCreator_.getJcrPath("userViewsPath");
        this.dmsConfiguration_ = dmsConfiguration;
        this.extensionManager_ = extensionManager;
        this.templateService = WCMCoreUtils.getService(TemplateService.class);
    }

    private void initButtons() {
        List extensions = this.extensionManager_.getUIExtensions("org.exoplatform.ecm.dms.UIActionBar");
        ArrayList<String> actions = new ArrayList<String>();
        if (extensions != null) {
            for (UIExtension extension : extensions) {
                actions.add(extension.getName());
            }
        }
        this.buttons_ = Collections.unmodifiableList(actions);
    }

    public void start() {
        block3: {
            this.configuredTemplates_ = new HashSet<String>();
            this.configuredViews_ = new HashSet<String>();
            try {
                this.initButtons();
                for (ManageViewPlugin plugin : this.plugins_) {
                    plugin.init();
                    this.configuredTemplates_.addAll(plugin.getConfiguredTemplates());
                    this.configuredViews_.addAll(plugin.getConfiguredViews());
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"an error occured while starting the component", (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    @Override
    public void init() throws Exception {
        this.configuredTemplates_ = new HashSet<String>();
        this.configuredViews_ = new HashSet<String>();
        for (ManageViewPlugin plugin : this.plugins_) {
            plugin.init();
            this.configuredTemplates_.addAll(plugin.getConfiguredTemplates());
            this.configuredViews_.addAll(plugin.getConfiguredViews());
        }
    }

    public void setManageViewPlugin(ManageViewPlugin viewPlugin) {
        this.plugins_.add(viewPlugin);
    }

    @Override
    public List<?> getButtons() {
        return this.buttons_;
    }

    public Node getViewHome() throws Exception {
        String viewsPath = this.nodeHierarchyCreator_.getJcrPath("userViewsPath");
        return (Node)this.getSession().getItem(viewsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ViewConfig> getAllViews() throws Exception {
        ArrayList<ViewConfig> viewList = new ArrayList<ViewConfig>();
        ViewConfig view = null;
        Node viewNode = null;
        String viewsPath = this.nodeHierarchyCreator_.getJcrPath("userViewsPath");
        Session session = this.getSession();
        try {
            Node viewHome = (Node)session.getItem(viewsPath);
            NodeIterator iter = viewHome.getNodes();
            while (iter.hasNext()) {
                view = new ViewConfig();
                viewNode = iter.nextNode();
                view.setName(viewNode.getName());
                view.setPermissions(viewNode.getProperty(EXO_PERMISSIONS).getString());
                view.setTemplate(viewNode.getProperty(EXO_TEMPLATE).getString());
                ArrayList<ViewConfig.Tab> tabList = new ArrayList<ViewConfig.Tab>();
                NodeIterator tabsIterator = viewNode.getNodes();
                while (tabsIterator.hasNext()) {
                    ViewConfig.Tab tab = new ViewConfig.Tab();
                    tab.setTabName(tabsIterator.nextNode().getName());
                    tabList.add(tab);
                }
                view.setTabList(tabList);
                viewList.add(view);
            }
        }
        catch (AccessDeniedException ace) {
            ArrayList<ViewConfig> arrayList = new ArrayList<ViewConfig>();
            return arrayList;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return viewList;
    }

    @Override
    public boolean hasView(String name) throws Exception {
        Session session = this.getSession();
        Node viewHome = (Node)session.getItem(this.baseViewPath_);
        boolean b = viewHome.hasNode(name);
        session.logout();
        return b;
    }

    @Override
    public Node getViewByName(String name, SessionProvider provider) throws Exception {
        Session session = this.getSession(provider);
        try {
            return (Node)session.getItem(this.baseViewPath_ + "/" + name);
        }
        catch (AccessDeniedException ace) {
            return null;
        }
    }

    @Override
    public void addView(String name, String permissions, String template, List<?> tabs) throws Exception {
        this.addView(name, permissions, false, template, tabs);
    }

    @Override
    public void addView(String name, String permissions, boolean hideExplorerPanel, String template, List<?> tabs) throws Exception {
        Node view;
        Session session = this.getSession();
        Node viewHome = (Node)session.getItem(this.baseViewPath_);
        if (viewHome.hasNode(name)) {
            view = viewHome.getNode(name);
            if (!view.isCheckedOut()) {
                view.checkout();
            }
            view.setProperty(EXO_PERMISSIONS, permissions);
            view.setProperty(EXO_TEMPLATE, template);
            view.setProperty(EXO_HIDE_EXPLORER_PANEL, hideExplorerPanel);
        } else {
            view = this.addView(viewHome, name, hideExplorerPanel, permissions, template);
        }
        for (int i = 0; i < tabs.size(); ++i) {
            String buttons;
            String tabName;
            try {
                Node tab = (Node)tabs.get(i);
                tabName = tab.getName();
                buttons = tab.getProperty(BUTTON_PROP).getString();
            }
            catch (Exception e) {
                ViewConfig.Tab tab = (ViewConfig.Tab)tabs.get(i);
                tabName = tab.getTabName();
                buttons = tab.getButtons();
            }
            this.addTab(view, tabName, buttons);
        }
        viewHome.save();
        session.save();
        session.logout();
    }

    @Override
    public void removeView(String viewName) throws Exception {
        Session session = this.getSession();
        Node viewHome = (Node)session.getItem(this.baseViewPath_);
        if (viewHome.hasNode(viewName)) {
            Node view = viewHome.getNode(viewName);
            view.remove();
            viewHome.save();
            session.save();
        }
        session.logout();
    }

    @Override
    public void addTab(Node view, String name, String buttons) throws Exception {
        Node tab = view.hasNode(name) ? view.getNode(name) : view.addNode(name, "exo:tab");
        tab.setProperty(BUTTON_PROP, buttons);
        view.save();
    }

    @Override
    public Node getTemplateHome(String homeAlias, SessionProvider provider) throws Exception {
        String homePath = this.getJCRPath(homeAlias);
        Session session = this.getSession(provider);
        try {
            return (Node)session.getItem(homePath);
        }
        catch (AccessDeniedException ace) {
            return null;
        }
    }

    private String getJCRPath(String jcrAlias) throws Exception {
        return this.nodeHierarchyCreator_.getJcrPath(jcrAlias);
    }

    private Session getSession() throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        return manageableRepository.getSystemSession(dmsRepoConfig.getSystemWorkspace());
    }

    private Session getSession(SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig();
        return sessionProvider.getSession(dmsRepoConfig.getSystemWorkspace(), manageableRepository);
    }

    @Override
    public List<Node> getAllTemplates(String homeAlias, SessionProvider provider) throws Exception {
        Node templateHomNode = this.getTemplateHome(homeAlias, provider);
        ArrayList<Node> list = new ArrayList<Node>();
        if (templateHomNode == null) {
            return list;
        }
        NodeIterator iter = templateHomNode.getNodes();
        while (iter.hasNext()) {
            list.add(iter.nextNode());
        }
        return list;
    }

    @Override
    public Node getTemplate(String path, SessionProvider provider) throws Exception {
        return (Node)this.getSession(provider).getItem(path);
    }

    @Override
    public String addTemplate(String name, String content, String homeTemplate) throws Exception {
        Session session = this.getSession();
        Node templateHome = (Node)session.getItem(homeTemplate);
        String templatePath = this.templateService.createTemplate(templateHome, name, name, new ByteArrayInputStream(content.getBytes()), new String[]{"*"});
        session.save();
        return templatePath;
    }

    @Override
    public String addTemplate(String name, String content, String homeTemplate, SessionProvider provider) throws Exception {
        Session session = this.getSession(provider);
        Node templateHome = (Node)session.getItem(homeTemplate);
        String templatePath = this.templateService.createTemplate(templateHome, name, name, new ByteArrayInputStream(content.getBytes()), new String[]{"*"});
        session.save();
        return templatePath;
    }

    @Override
    public String updateTemplate(String name, String content, String homeTemplate) throws Exception {
        Session session = this.getSession();
        Node templateHome = (Node)session.getItem(homeTemplate);
        String templatePath = this.templateService.updateTemplate(templateHome.getNode(name), new ByteArrayInputStream(content.getBytes()), new String[]{"*"});
        session.save();
        return templatePath;
    }

    @Override
    public String updateTemplate(String name, String content, String homeTemplate, SessionProvider provider) throws Exception {
        Session session = this.getSession(provider);
        Node templateHome = (Node)session.getItem(homeTemplate);
        String templatePath = this.templateService.updateTemplate(templateHome.getNode(name), new ByteArrayInputStream(content.getBytes()), new String[]{"*"});
        session.save();
        return templatePath;
    }

    @Override
    public void removeTemplate(String templatePath) throws Exception {
        Node selectedTemplate = (Node)this.getSession().getItem(templatePath);
        Node parent = selectedTemplate.getParent();
        selectedTemplate.remove();
        parent.save();
        parent.getSession().save();
    }

    @Override
    public void removeTemplate(String templatePath, SessionProvider provider) throws Exception {
        Node selectedTemplate = (Node)this.getSession(provider).getItem(templatePath);
        Node parent = selectedTemplate.getParent();
        selectedTemplate.remove();
        parent.save();
        parent.getSession().save();
    }

    private Node addView(Node viewManager, String name, boolean hideExplorerPanel, String permissions, String template) throws Exception {
        Node contentNode = viewManager.addNode(name, "exo:view");
        contentNode.setProperty(EXO_PERMISSIONS, permissions);
        contentNode.setProperty(EXO_TEMPLATE, template);
        contentNode.setProperty(EXO_HIDE_EXPLORER_PANEL, hideExplorerPanel);
        viewManager.save();
        return contentNode;
    }

    @Override
    public Set<String> getConfiguredTemplates() {
        return this.configuredTemplates_;
    }

    @Override
    public Set<String> getConfiguredViews() {
        return this.configuredViews_;
    }
}

