/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.webdav;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import javax.jcr.Item;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ext.webdav.method.ACL;
import org.exoplatform.services.rest.ext.webdav.method.CHECKIN;
import org.exoplatform.services.rest.ext.webdav.method.CHECKOUT;
import org.exoplatform.services.rest.ext.webdav.method.COPY;
import org.exoplatform.services.rest.ext.webdav.method.LOCK;
import org.exoplatform.services.rest.ext.webdav.method.MKCOL;
import org.exoplatform.services.rest.ext.webdav.method.MOVE;
import org.exoplatform.services.rest.ext.webdav.method.OPTIONS;
import org.exoplatform.services.rest.ext.webdav.method.ORDERPATCH;
import org.exoplatform.services.rest.ext.webdav.method.PROPFIND;
import org.exoplatform.services.rest.ext.webdav.method.PROPPATCH;
import org.exoplatform.services.rest.ext.webdav.method.REPORT;
import org.exoplatform.services.rest.ext.webdav.method.SEARCH;
import org.exoplatform.services.rest.ext.webdav.method.UNCHECKOUT;
import org.exoplatform.services.rest.ext.webdav.method.UNLOCK;
import org.exoplatform.services.rest.ext.webdav.method.VERSIONCONTROL;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

@Path(value="/jcr/")
public class WebDavServiceImpl
extends org.exoplatform.services.jcr.webdav.WebDavServiceImpl {
    private static final Log LOG = ExoLogger.getLogger((String)WebDavServiceImpl.class.getName());
    private final String POST_UPLOAD_CONTENT_EVENT = "WebDavService.event.postUpload";
    private final NodeFinder nodeFinder;
    private final RepositoryService repositoryService;
    private ListenerService listenerService;
    private final MimeTypeResolver mimeTypeResolver;

    public WebDavServiceImpl(InitParams params, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, NodeFinder nodeFinder) throws Exception {
        super(params, repositoryService, sessionProviderService);
        this.repositoryService = repositoryService;
        this.nodeFinder = nodeFinder;
        this.listenerService = WCMCoreUtils.getService(ListenerService.class);
        this.mimeTypeResolver = new MimeTypeResolver();
        this.mimeTypeResolver.setDefaultMimeType("application/octet-stream");
    }

    private String getRealDestinationHeader(String baseURI, String repoName, String destinationHeader) {
        String serverURI = baseURI + "/jcr/" + repoName;
        if (!(destinationHeader = TextUtil.unescape((String)destinationHeader, (char)'%')).startsWith(serverURI)) {
            return null;
        }
        String destPath = destinationHeader.substring(serverURI.length() + 1);
        try {
            Item item = this.nodeFinder.getItem(this.workspaceName(destPath), LinkUtils.getParentPath(this.path(destPath)), true);
            return item.getSession().getWorkspace().getName() + LinkUtils.createPath(item.getPath(), LinkUtils.getItemName(this.path(destPath)));
        }
        catch (RepositoryException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + destPath), (Throwable)e);
            }
            return null;
        }
    }

    @CHECKIN
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response checkin(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.checkin(repoName, repoPath, lockTokenHeader, ifHeader);
    }

    @CHECKOUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response checkout(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.checkout(repoName, repoPath, lockTokenHeader, ifHeader);
    }

    @COPY
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response copy(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Destination") String destinationHeader, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, @HeaderParam(value="Overwrite") String overwriteHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            repoPath = this.convertRepoPath(repoPath, false);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        String realDestinationHeader = this.getRealDestinationHeader(uriInfo.getPath(), repoName, destinationHeader);
        if (realDestinationHeader != null) {
            destinationHeader = realDestinationHeader;
        }
        return super.copy(repoName, repoPath, destinationHeader, lockTokenHeader, ifHeader, depthHeader, overwriteHeader, uriInfo, body);
    }

    @GET
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response get(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Range") String rangeHeader, @HeaderParam(value="If-Modified-Since") String ifModifiedSince, @HeaderParam(value="If-None-Match") String ifNoneMatch, @QueryParam(value="version") String version, @Context UriInfo uriInfo) {
        try {
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        Response response = super.get(repoName, repoPath, rangeHeader, ifModifiedSince, ifNoneMatch, version, uriInfo);
        if (200 == response.getStatus()) {
            return Response.fromResponse((Response)response).header("Access-Control-Allow-Origin", (Object)uriInfo.getRequestUri().getHost()).header("Access-Control-Allow-Credentials", (Object)true).header("Access-Control-Allow-Methods", (Object)"ACL, CANCELUPLOAD, CHECKIN, CHECKOUT, COPY, DELETE, GET, HEAD, LOCK, MKCALENDAR, MKCOL, MOVE, OPTIONS, POST, PROPFIND, PROPPATCH, PUT, REPORT, SEARCH, UNCHECKOUT, UNLOCK, UPDATE, VERSION-CONTROL").header("Access-Control-Allow-Headers", (Object)"Overwrite, Destination, Content-Type, Depth, User-Agent, Translate, Range, Content-Range, Timeout, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control, Location, Lock-Token, If").header("Access-Control-Expose-Header", (Object)"DAV, content-length, Allow").header("Access-Control-Max-Age", (Object)3600).build();
        }
        return response;
    }

    @HEAD
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response head(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @Context UriInfo uriInfo) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.head(repoName, repoPath, uriInfo);
    }

    @LOCK
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response lock(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, HierarchicalProperty body) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.lock(repoName, repoPath, lockTokenHeader, ifHeader, depthHeader, body);
    }

    @UNLOCK
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response unlock(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.unlock(repoName, repoPath, lockTokenHeader, ifHeader);
    }

    @OPTIONS
    @Path(value="/{repoName}/{path:.*}/")
    public Response options(@PathParam(value="path") String path) {
        return super.options(path);
    }

    @ORDERPATCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response order(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.order(repoName, repoPath, lockTokenHeader, ifHeader, uriInfo, body);
    }

    @PROPFIND
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response propfind(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="depth") String depthHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.propfind(repoName, repoPath, depthHeader, uriInfo, body);
    }

    @PROPPATCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response proppatch(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.proppatch(repoName, repoPath, lockTokenHeader, ifHeader, uriInfo, body);
    }

    @PUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response put(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="File-NodeType") String fileNodeTypeHeader, @HeaderParam(value="Content-NodeType") String nodeTypeHeader, @HeaderParam(value="Content-MixinTypes") String mixinTypes, @HeaderParam(value="Content-type") MediaType mediaType, @HeaderParam(value="User-Agent") String userAgent, InputStream inputStream, @Context UriInfo uriInfo) {
        Session session = null;
        Item item = null;
        boolean isCreating = false;
        ActivityCommonService activityService = null;
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            try {
                item = this.nodeFinder.getItem(this.workspaceName(repoPath), LinkUtils.getParentPath(this.path(this.normalizePath(repoPath))), true);
                repoPath = item.getSession().getWorkspace().getName() + LinkUtils.createPath(item.getPath(), Text.escapeIllegalJcrChars(LinkUtils.getItemName(this.path(repoPath))));
                session = item.getSession();
            }
            catch (PathNotFoundException e) {
                item = this.nodeFinder.getItem(this.workspaceName(repoPath), LinkUtils.getParentPath(this.path(Text.escapeIllegalJcrChars(repoPath))), true);
                repoPath = item.getSession().getWorkspace().getName() + LinkUtils.createPath(item.getPath(), Text.escapeIllegalJcrChars(LinkUtils.getItemName(this.path(repoPath))));
                session = item.getSession();
            }
            activityService = WCMCoreUtils.getService(ActivityCommonService.class);
            if (!session.itemExists(this.path(repoPath))) {
                isCreating = true;
            }
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        Response res = super.put(repoName, repoPath, lockTokenHeader, ifHeader, null, nodeTypeHeader, mixinTypes, mediaType, userAgent, inputStream, uriInfo);
        try {
            boolean pushAs = this.markTempFilesToHidden(repoPath);
            Node currentNode = (Node)session.getItem(this.path(repoPath));
            if (isCreating) {
                if (userAgent.contains("Microsoft")) {
                    activityService.setCreating(currentNode, true);
                }
            } else {
                activityService.setCreating(currentNode, false);
            }
            try {
                if (isCreating && pushAs) {
                    this.listenerService.broadcast(ActivityCommonService.FILE_CREATED_ACTIVITY, null, (Object)currentNode);
                }
                if (currentNode.isCheckedOut() && !activityService.isCreating(currentNode) && pushAs) {
                    this.listenerService.broadcast(this.POST_UPLOAD_CONTENT_EVENT, (Object)this, (Object)currentNode);
                }
            }
            catch (Exception e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Cannot broadcast file create activity for the item at " + currentNode.getPath()), (Throwable)e);
                }
            }
        }
        catch (PathNotFoundException npfe) {
            return Response.status((int)404).entity((Object)npfe.getMessage()).build();
        }
        catch (RepositoryException re) {
            return Response.status((int)404).entity((Object)re.getMessage()).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
        return res;
    }

    @REPORT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response report(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="depth") String depthHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.report(repoName, repoPath, depthHeader, uriInfo, body);
    }

    @SEARCH
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response search(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.search(repoName, repoPath, uriInfo, body);
    }

    @UNCHECKOUT
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response uncheckout(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.uncheckout(repoName, repoPath, lockTokenHeader, ifHeader);
    }

    @VERSIONCONTROL
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response versionControl(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.versionControl(repoName, repoPath, lockTokenHeader, ifHeader);
    }

    @ACL
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response acl(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, HierarchicalProperty body) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.acl(repoName, repoPath, lockTokenHeader, ifHeader, body);
    }

    @MOVE
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response move(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="Destination") String destinationHeader, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, @HeaderParam(value="Overwrite") String overwriteHeader, @Context UriInfo uriInfo, HierarchicalProperty body) {
        try {
            repoPath = this.convertRepoPath(repoPath, true);
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        Response response = super.move(repoName, repoPath, destinationHeader, lockTokenHeader, ifHeader, depthHeader, overwriteHeader, uriInfo, body);
        if (response.getStatus() == 201) {
            this.updateProperties(destinationHeader, repoName);
        }
        this.markTempFilesToHidden(repoPath);
        return response;
    }

    private void updateProperties(String destinationHeader, String repoName) {
        block4: {
            try {
                URI dest = this.buildURI(destinationHeader);
                String destPath = dest.getPath();
                int repoIndex = destPath.indexOf(repoName);
                destPath = this.normalizePath(repoIndex == -1 ? destPath : destPath.substring(repoIndex + repoName.length() + 1));
                String destNodePath = this.path(destPath);
                Node destNode = (Node)this.nodeFinder.getItem(this.workspaceName(destPath), this.path(this.normalizePath(destNodePath)), true);
                String nodeName = Text.escapeIllegalJcrChars(destNode.getName());
                destNode.setProperty("exo:name", nodeName);
                destNode.setProperty("exo:title", nodeName);
                if (!Utils.isFolder(destNode)) {
                    Node content = destNode.getNode("jcr:content");
                    String mimeType = this.mimeTypeResolver.getMimeType(nodeName);
                    content.setProperty("jcr:mimeType", mimeType);
                    ListenerService listenerService = WCMCoreUtils.getService(ListenerService.class);
                    if (destNode.isNodeType("exo:datetime")) {
                        destNode.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
                    }
                    listenerService.broadcast("CmsService.event.postEdit", (Object)destNode.getParent(), (Object)destNode);
                }
                destNode.save();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)("Cannot change property of destNode" + destinationHeader), (Throwable)e);
            }
        }
    }

    private URI buildURI(String path) throws URISyntaxException {
        try {
            return new URI(path);
        }
        catch (URISyntaxException e) {
            return new URI(TextUtil.escape((String)path, (char)'%', (boolean)true));
        }
    }

    @MKCOL
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response mkcol(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="Content-NodeType") String nodeTypeHeader, @HeaderParam(value="Content-MixinTypes") String mixinTypesHeader, @Context UriInfo uriInfo) {
        try {
            repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            Item item = this.nodeFinder.getItem(this.workspaceName(repoPath), LinkUtils.getParentPath(this.path(this.normalizePath(repoPath))), true);
            repoPath = item.getSession().getWorkspace().getName() + LinkUtils.createPath(item.getPath(), LinkUtils.getItemName(this.path(repoPath)));
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
            }
            return Response.serverError().build();
        }
        return super.mkcol(repoName, repoPath, lockTokenHeader, ifHeader, nodeTypeHeader, mixinTypesHeader, uriInfo);
    }

    @DELETE
    @Path(value="/{repoName}/{repoPath:.*}/")
    public Response delete(@PathParam(value="repoName") String repoName, @PathParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        block19: {
            Item item = null;
            try {
                repoName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
                repoPath = this.convertRepoPath(repoPath, false);
                try {
                    item = this.nodeFinder.getItem(this.workspaceName(repoPath), this.path(this.normalizePath(repoPath)), true);
                }
                catch (PathNotFoundException e) {
                    item = this.nodeFinder.getItem(this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), true);
                }
            }
            catch (PathNotFoundException exc) {
                return Response.status((int)404).entity((Object)exc.getMessage()).build();
            }
            catch (NoSuchWorkspaceException exc) {
                return Response.status((int)404).entity((Object)exc.getMessage()).build();
            }
            catch (Exception e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Cannot find the item at " + repoName + "/" + repoPath), (Throwable)e);
                }
                return Response.serverError().build();
            }
            try {
                Node node;
                block18: {
                    node = (Node)item;
                    ListenerService listenerService = WCMCoreUtils.getService(ListenerService.class);
                    ActivityCommonService activityService = WCMCoreUtils.getService(ActivityCommonService.class);
                    Node parent = node.getParent();
                    if (node.getPrimaryNodeType().getName().equals("nt:file")) {
                        if (activityService.isBroadcastNTFileEvents(node)) {
                            listenerService.broadcast(ActivityCommonService.FILE_REMOVE_ACTIVITY, (Object)parent, (Object)node);
                        }
                    } else if (!WCMCoreUtils.isDocumentNodeType(node)) {
                        LinkedList<Node> queue = new LinkedList<Node>();
                        queue.add(node);
                        Node tempNode = null;
                        try {
                            while (!queue.isEmpty()) {
                                tempNode = (Node)queue.poll();
                                if (WCMCoreUtils.isDocumentNodeType(tempNode) || tempNode.getPrimaryNodeType().getName().equals("nt:file")) {
                                    listenerService.broadcast(ActivityCommonService.FILE_REMOVE_ACTIVITY, (Object)tempNode.getParent(), (Object)tempNode);
                                    continue;
                                }
                                NodeIterator iter = tempNode.getNodes();
                                while (iter.hasNext()) {
                                    Node childNode = iter.nextNode();
                                    if (!WCMCoreUtils.isDocumentNodeType(childNode) && !childNode.isNodeType("nt:unstructured") && !childNode.isNodeType("nt:folder")) continue;
                                    queue.add(childNode);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!LOG.isWarnEnabled()) break block18;
                            LOG.warn((Object)e.getMessage());
                        }
                    }
                }
                Utils.removeSymlinks(node);
            }
            catch (Exception ex) {
                if (!LOG.isWarnEnabled()) break block19;
                LOG.warn((Object)ex.getMessage());
            }
        }
        return super.delete(repoName, repoPath, lockTokenHeader, ifHeader);
    }

    private String convertRepoPath(String repoPath, boolean giveTarget) throws Exception {
        try {
            Item item = this.nodeFinder.getItem(this.workspaceName(repoPath), this.path(this.normalizePath(repoPath)), giveTarget);
            return item.getSession().getWorkspace().getName() + item.getPath();
        }
        catch (PathNotFoundException e) {
            Item item = this.nodeFinder.getItem(this.workspaceName(repoPath), this.path(Text.escapeIllegalJcrChars(repoPath)), giveTarget);
            return item.getSession().getWorkspace().getName() + item.getPath();
        }
    }

    private boolean markTempFilesToHidden(String repoPath) {
        block8: {
            if (StringUtils.isBlank((String)repoPath)) {
                return false;
            }
            String tempNodeFolder = ".TemporaryItems";
            String tempNodeFileChild = "._folders.501";
            String tempNodeFile = "._.TemporaryItems";
            String txtTempRegex = "/._";
            try {
                boolean isTxtTemp;
                String txtTemp = repoPath.substring(repoPath.lastIndexOf("/"), repoPath.length());
                boolean bl = isTxtTemp = txtTemp.startsWith(txtTempRegex);
                if (repoPath.contains(tempNodeFile) || isTxtTemp) {
                    Node _tempNodeFile = (Node)this.nodeFinder.getItem(this.workspaceName(repoPath), this.path(repoPath), true);
                    _tempNodeFile.remove();
                    _tempNodeFile.getSession().save();
                    return false;
                }
                if (repoPath.contains(tempNodeFolder)) {
                    String currentNodePath = repoPath.substring(0, repoPath.indexOf(tempNodeFolder));
                    Node currentNode = (Node)this.nodeFinder.getItem(this.workspaceName(repoPath), this.path(currentNodePath), true);
                    if (currentNode.hasNode(tempNodeFolder)) {
                        Node _tmpFolderNode = currentNode.getNode(tempNodeFolder);
                        if (_tmpFolderNode.canAddMixin("exo:hiddenable")) {
                            _tmpFolderNode.addMixin("exo:hiddenable");
                        }
                        if (_tmpFolderNode.hasNode(tempNodeFileChild)) {
                            Node _tempNodeFileChild = _tmpFolderNode.getNode(tempNodeFileChild);
                            _tempNodeFileChild.remove();
                        }
                        _tmpFolderNode.save();
                    }
                    return false;
                }
            }
            catch (RepositoryException ex) {
                if (!LOG.isWarnEnabled()) break block8;
                LOG.warn((Object)("The hidden temp files has been ignored " + ex.getMessage()));
            }
        }
        return true;
    }
}

