/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import org.exoplatform.commons.utils.PrivilegedSystemHelper;

public class ExceptionUtil {
    private static String LINE_SEPARATOR = PrivilegedSystemHelper.getProperty("line.separator");

    public static String getExoStackTrace(Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        StringBuffer b = new StringBuffer();
        b.append(t.getMessage()).append(LINE_SEPARATOR);
        boolean appendDot = true;
        for (int i = 0; i < elements.length; ++i) {
            if (i < 10) {
                b.append(" at ").append(elements[i].toString()).append(LINE_SEPARATOR);
                continue;
            }
            if (elements[i].getClassName().startsWith("exo.")) {
                b.append(" at ").append(elements[i].toString()).append(LINE_SEPARATOR);
                appendDot = true;
                continue;
            }
            if (!appendDot) continue;
            b.append("  [...................................]").append(LINE_SEPARATOR);
            appendDot = false;
        }
        return b.toString();
    }

    public static String getStackTrace(Throwable t, int numberOfLine) {
        StackTraceElement[] elements = t.getStackTrace();
        if (numberOfLine > elements.length) {
            numberOfLine = elements.length;
        }
        StringBuffer b = new StringBuffer();
        b.append(t.getMessage()).append(LINE_SEPARATOR);
        for (int i = 0; i < numberOfLine; ++i) {
            b.append(elements[i].toString()).append(LINE_SEPARATOR);
        }
        return b.toString();
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }
}

