/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataManagerImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolatileNodeTypeDataManager
extends NodeTypeDataManagerImpl {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.VolatileNodeTypeDataManager");

    public VolatileNodeTypeDataManager(NodeTypeDataManagerImpl nodeTypeDataManagerImpl) throws RepositoryException {
        super(nodeTypeDataManagerImpl.accessControlPolicy, nodeTypeDataManagerImpl.locationFactory, nodeTypeDataManagerImpl.namespaceRegistry, null, nodeTypeDataManagerImpl.dataManager, nodeTypeDataManagerImpl.indexSearcherHolder, nodeTypeDataManagerImpl.nodeTypeRepository.createCopy(), nodeTypeDataManagerImpl.cleanerHolder);
    }

    public void registerVolatileNodeTypes(Collection<NodeTypeData> volatileNodeTypes) throws RepositoryException {
        HashMap<InternalQName, NodeTypeData> map = new HashMap<InternalQName, NodeTypeData>();
        for (NodeTypeData nodeTypeData : volatileNodeTypes) {
            map.put(nodeTypeData.getName(), nodeTypeData);
        }
        this.registerVolatileNodeTypes(map);
    }

    public void registerVolatileNodeTypes(Map<InternalQName, NodeTypeData> volatileNodeTypes) throws RepositoryException {
        for (Map.Entry<InternalQName, NodeTypeData> entry : volatileNodeTypes.entrySet()) {
            if (this.getNodeType(entry.getKey()) != null) {
                this.nodeTypeRepository.removeNodeType(entry.getValue());
            }
            this.nodeTypeRepository.addNodeType(entry.getValue(), volatileNodeTypes);
        }
    }
}

