/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinKey;
import org.exoplatform.portal.resource.SkinVisitor;
import org.exoplatform.services.wcm.skin.XSkinService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WCMSkinVisitor
implements SkinVisitor {
    private List<SkinConfig> wcmSiteSkins = new ArrayList<SkinConfig>();
    private List<SkinConfig> wcmSharedSkins = new ArrayList<SkinConfig>();
    private String skinName;
    private String moduleName;

    public WCMSkinVisitor(String siteName, String skinName) {
        this.skinName = skinName;
        this.moduleName = XSkinService.createModuleName(siteName);
    }

    public void visitPortalSkin(Map.Entry<SkinKey, SkinConfig> entry) {
        String name = entry.getKey().getName();
        if (name.equals(this.skinName)) {
            this.visit(this.wcmSharedSkins, entry);
        }
    }

    public void visitSkin(Map.Entry<SkinKey, SkinConfig> entry) {
        String module = entry.getKey().getModule();
        String name = entry.getKey().getName();
        if (name.equals(this.skinName) && module.equals(this.moduleName)) {
            this.visit(this.wcmSiteSkins, entry);
        }
    }

    public Collection<SkinConfig> getSkins() {
        LinkedList<SkinConfig> skins = new LinkedList<SkinConfig>();
        Comparator<SkinConfig> skinComparator = new Comparator<SkinConfig>(){

            @Override
            public int compare(SkinConfig o1, SkinConfig o2) {
                return o1.getCSSPriority() - o2.getCSSPriority();
            }
        };
        Collections.sort(this.wcmSharedSkins, skinComparator);
        skins.addAll(this.wcmSharedSkins);
        Collections.sort(this.wcmSiteSkins, skinComparator);
        skins.addAll(this.wcmSiteSkins);
        return skins;
    }

    private void visit(Collection<SkinConfig> skins, Map.Entry<SkinKey, SkinConfig> entry) {
        String currentContext = WCMCoreUtils.getRepository().getConfiguration().getName();
        String cssPath = entry.getValue().getCSSPath();
        Map<String, String> params = XSkinService.getSkinParams(cssPath);
        if (cssPath.matches("/(.*)/css/jcr/(.*)/(.*)/(.*)/(.*).css") && !params.get("context").equals(currentContext)) {
            return;
        }
        skins.add(entry.getValue());
    }
}

