/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.data;

import java.util.Collections;
import java.util.Map;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.storage.cache.model.data.CacheData;

public class ProfileData
implements CacheData<Profile> {
    private final String profileId;
    private final String identityId;
    private final String providerId;
    private final String remoteId;
    private final boolean hasChanged;
    private final Map<String, Object> data;
    private final String url;
    private final String avatarUrl;
    private final Long createdTime;

    public ProfileData(Profile profile) {
        this.profileId = profile.getId();
        this.identityId = profile.getIdentity().getId();
        this.providerId = profile.getIdentity().getProviderId();
        this.remoteId = profile.getIdentity().getRemoteId();
        this.hasChanged = profile.hasChanged();
        this.data = Collections.unmodifiableMap(profile.getProperties());
        this.url = profile.getUrl();
        this.avatarUrl = profile.getAvatarUrl();
        this.createdTime = profile.getCreatedTime();
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getIdentityId() {
        return this.identityId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public Profile build() {
        Identity identity = new Identity(this.identityId);
        identity.setProviderId(this.providerId);
        identity.setRemoteId(this.remoteId);
        Profile profile = new Profile(identity);
        profile.setId(this.profileId);
        profile.setUrl(this.url);
        profile.setAvatarUrl(this.avatarUrl);
        profile.setCreatedTime(this.createdTime);
        for (String key : this.data.keySet()) {
            profile.setProperty(key, this.data.get(key));
        }
        identity.setProfile(profile);
        if (!this.hasChanged) {
            profile.clearHasChanged();
        }
        return profile;
    }
}

