/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.organization.integration;

import javax.jcr.Session;
import org.exoplatform.platform.organization.integration.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    private RepositoryService repositoryService;

    public NewUserListener(RepositoryService repositoryService) throws Exception {
        this.repositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(User user, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (!Util.hasUserFolder(session, user.getUserName())) {
                Util.createUserFolder(session, user.getUserName());
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(User user) throws Exception {
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (Util.hasUserFolder(session, user.getUserName())) {
                Util.deleteUserFolder(session, user.getUserName());
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

