/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ValueFileIOHelper {
    public static final int IOBUFFER_SIZE = 32768;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ValueFileIOHelper");

    protected void writeValue(File file, ValueData value) throws IOException {
        if (value.isByteArray()) {
            this.writeByteArrayValue(file, value);
        } else {
            this.writeStreamedValue(file, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeByteArrayValue(File file, ValueData value) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(value.getAsByteArray());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
    }

    protected void writeStreamedValue(File file, ValueData value) throws IOException {
        if (value instanceof StreamPersistedValueData) {
            StreamPersistedValueData streamed = (StreamPersistedValueData)value;
            if (streamed.isPersisted()) {
                this.copyClose(streamed.getAsStream(), new FileOutputStream(file));
            } else {
                SpoolFile tempFile = streamed.getTempFile();
                if (tempFile != null) {
                    if (!tempFile.renameTo(file)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Value spool file move (rename) to Values Storage is not succeeded. Trying bytes copy. Spool file: " + tempFile.getAbsolutePath() + ". Destination: " + file.getAbsolutePath()));
                        }
                        this.copyClose(new FileInputStream(tempFile), new FileOutputStream(file));
                    }
                } else {
                    this.copyClose(streamed.getStream(), new FileOutputStream(file));
                }
                streamed.setPersistedFile(file);
            }
        } else {
            this.copyClose(value.getAsStream(), new FileOutputStream(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutput(OutputStream out, ValueData value) throws IOException {
        if (value.isByteArray()) {
            byte[] buff = value.getAsByteArray();
            out.write(buff);
        } else {
            InputStream in;
            if (value instanceof StreamPersistedValueData) {
                StreamPersistedValueData streamed = (StreamPersistedValueData)value;
                if (streamed.isPersisted()) {
                    in = streamed.getAsStream();
                } else {
                    in = streamed.getStream();
                    if (in == null) {
                        in = new FileInputStream(streamed.getTempFile());
                    }
                }
            } else {
                in = value.getAsStream();
            }
            try {
                this.copy(in, out);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
    }

    protected long copy(InputStream in, OutputStream out) throws IOException {
        boolean outFile;
        boolean inFile = in instanceof FileInputStream && FileInputStream.class.equals(in.getClass());
        boolean bl = outFile = out instanceof FileOutputStream && FileOutputStream.class.equals(out.getClass());
        if (inFile && outFile) {
            FileChannel infch = ((FileInputStream)in).getChannel();
            FileChannel outfch = ((FileOutputStream)out).getChannel();
            long size = 0L;
            long r = 0L;
            do {
                r = outfch.transferFrom(infch, r, infch.size());
                size += r;
            } while (r < infch.size());
            return size;
        }
        ReadableByteChannel inch = inFile ? ((FileInputStream)in).getChannel() : Channels.newChannel(in);
        WritableByteChannel outch = outFile ? ((FileOutputStream)out).getChannel() : Channels.newChannel(out);
        long size = 0L;
        int r = 0;
        ByteBuffer buff = ByteBuffer.allocate(32768);
        buff.clear();
        while ((r = inch.read(buff)) >= 0) {
            buff.flip();
            do {
                outch.write(buff);
            } while (buff.hasRemaining());
            buff.clear();
            size += (long)r;
        }
        if (outFile) {
            ((FileChannel)outch).force(true);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long copyClose(InputStream in, OutputStream out) throws IOException {
        long l;
        try {
            try {
                l = this.copy(in, out);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            out.close();
            throw throwable;
        }
        out.close();
        return l;
    }
}

