/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.ws.bean;

import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.ws.common.Resource;

public class CalendarResource
extends Resource {
    private static final long serialVersionUID = -4500214043430048066L;
    private String name;
    private String description;
    private String type;
    private String timeZone;
    private String color;
    private String owner;
    private String viewPermission;
    private String editPermission;
    private String[] groups;
    private String publicURL;
    private String privateURL;
    private String icsURL;

    public CalendarResource() {
        super(null);
    }

    public CalendarResource(Calendar data, String basePath) {
        super(data.getId());
        StringBuilder calUri = new StringBuilder(basePath);
        calUri.append("/calendars/").append(this.getId());
        this.setHref(calUri.toString());
        this.icsURL = this.getHref() + "/ics";
        this.name = data.getName();
        this.description = data.getDescription();
        this.type = String.valueOf(data.getCalType());
        this.timeZone = data.getTimeZone();
        this.color = data.getCalendarColor();
        this.owner = data.getCalendarOwner();
        StringBuilder sb = new StringBuilder();
        if (data.getViewPermission() != null) {
            for (String s : data.getViewPermission()) {
                sb.append(s).append(";");
            }
        }
        this.viewPermission = sb.toString();
        sb = new StringBuilder();
        if (data.getEditPermission() != null) {
            for (String s : data.getEditPermission()) {
                sb.append(s).append(";");
            }
        }
        this.editPermission = sb.toString();
        this.groups = data.getGroups();
        this.publicURL = data.getPublicUrl();
        this.privateURL = data.getPrivateUrl();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getViewPermission() {
        return this.viewPermission;
    }

    public void setViewPermission(String viewPermission) {
        this.viewPermission = viewPermission;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public String getPublicURL() {
        return this.publicURL;
    }

    public void setPublicURL(String publicURL) {
        this.publicURL = publicURL;
    }

    public String getPrivateURL() {
        return this.privateURL;
    }

    public void setPrivateURL(String privateURL) {
        this.privateURL = privateURL;
    }

    public String getIcsURL() {
        return this.icsURL;
    }

    public void setIcsURL(String icsURL) {
        this.icsURL = icsURL;
    }
}

