/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.chromattic.ext.ntdef.NTFolder;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.application.gadget.EncodingDetector;
import org.exoplatform.application.gadget.GadgetImporter;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.gadget.impl.GadgetDefinition;
import org.exoplatform.application.gadget.impl.LocalGadgetData;
import org.gatein.common.io.IOTools;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ServletLocalImporter
extends GadgetImporter {
    private final Logger log = LoggerFactory.getLogger(ServletLocalImporter.class);
    private final ServletContext servletContext;
    private NTFolder folder;
    private GadgetRegistryService gadgetService;

    public ServletLocalImporter(String name, String gadgetPath, ServletContext servletContext, GadgetRegistryService gadgetRegistryService) {
        super(name, gadgetPath);
        this.servletContext = servletContext;
        this.gadgetService = gadgetRegistryService;
    }

    @Override
    protected byte[] getGadgetBytes(String gadgetURI) throws IOException {
        return this.getContent(gadgetURI);
    }

    @Override
    protected String getGadgetURL() {
        return this.gadgetService.getGadgetURL(this.getGadgetName());
    }

    @Override
    protected void processMetadata(ModulePrefs prefs, GadgetDefinition def) {
    }

    @Override
    protected void process(String gadgetPath, GadgetDefinition def) throws Exception {
        def.setLocal(true);
        LocalGadgetData data = (LocalGadgetData)def.getData();
        String fileName = this.getName(gadgetPath);
        data.setFileName(fileName);
        this.folder = data.getResources();
        String folderPath = this.getParent(gadgetPath);
        this.visitChildren(gadgetPath, folderPath);
        this.folder = null;
    }

    private void visit(String uri, String resourcePath) throws Exception {
        String name = this.getName(resourcePath);
        if (this.isFile(resourcePath)) {
            byte[] content = this.getContent(resourcePath);
            if (content != null) {
                String mimeType = this.getMimeType(name);
                if (mimeType == null) {
                    mimeType = "application/octet-stream";
                }
                String encoding = null;
                if ("application/xml".equals(mimeType)) {
                    encoding = EncodingDetector.detect(new ByteArrayInputStream(content));
                }
                if (resourcePath.equals(uri)) {
                    mimeType = "application/x-google-gadget";
                }
                this.folder.createFile(name, new Resource(mimeType, encoding, content));
            }
        } else {
            this.folder = this.folder.createFolder(name);
            this.visitChildren(uri, resourcePath);
            this.folder = this.folder.getParent();
        }
    }

    private void visitChildren(String gadgetURI, String folderPath) throws Exception {
        for (String childPath : this.getChildren(folderPath)) {
            this.visit(gadgetURI, childPath);
        }
    }

    private String getName(String resourcePath) {
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        int index = resourcePath.lastIndexOf(47);
        return resourcePath.substring(index + 1);
    }

    private String getParent(String resourcePath) {
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        int index = resourcePath.lastIndexOf(47);
        return resourcePath.substring(0, index + 1);
    }

    private byte[] getContent(String filePath) throws IOException {
        InputStream in = this.servletContext.getResourceAsStream(filePath);
        if (in == null) {
            this.log.error((Object)("Could not obtain input stream for file " + filePath));
            return null;
        }
        return IOTools.getBytes((InputStream)in);
    }

    private Iterable<String> getChildren(String folderPath) {
        Set resourcePaths = this.servletContext.getResourcePaths(folderPath);
        return resourcePaths;
    }

    private boolean isFile(String resourcePath) {
        return !resourcePath.endsWith("/");
    }

    private String getMimeType(String fileName) {
        return this.servletContext.getMimeType(fileName);
    }
}

