/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest;

import java.lang.reflect.Method;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/platform")
public class PlatformInformationRESTService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(PlatformInformationRESTService.class);
    public static final String COMMUNITY_EDITION = "community";
    public final String ANONYMOUS_USER = "__anonim";
    private ProductInformations platformInformations;
    private UserACL userACL;

    public PlatformInformationRESTService(ProductInformations productInformations, UserACL userACL) {
        this.platformInformations = productInformations;
        this.userACL = userACL;
    }

    @GET
    @Path(value="isusersessionalive")
    @Produces(value={"application/json"})
    public Response isUserSessionAlive() throws Exception {
        try {
            Boolean del = false;
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            if (userId != null && !userId.equals("__anonim")) {
                del = true;
            }
            return Response.ok((Object)del.toString()).build();
        }
        catch (Exception e) {
            return Response.status((int)500).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    public Response getPlatformInformation(@Context SecurityContext sc) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try (SessionProvider sessionProvider = null;){
            PortalContainer container = PortalContainer.getInstance();
            sessionProvider = SessionProvider.createSystemProvider();
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
            RepositoryService repoService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            String plfProfile = PortalContainer.getProfiles().toString().trim();
            String runningProfile = plfProfile.substring(1, plfProfile.length() - 1);
            ManageableRepository repo = repoService.getCurrentRepository();
            JsonPlatformInfo jsonPlatformInfo = new JsonPlatformInfo();
            jsonPlatformInfo.setPlatformVersion(this.platformInformations.getVersion());
            jsonPlatformInfo.setPlatformBuildNumber(this.platformInformations.getBuildNumber());
            jsonPlatformInfo.setPlatformRevision(this.platformInformations.getRevision());
            jsonPlatformInfo.setIsMobileCompliant(this.isMobileCompliant().toString());
            jsonPlatformInfo.setRunningProfile(runningProfile);
            jsonPlatformInfo.setCurrentRepoName(repo.getConfiguration().getName());
            jsonPlatformInfo.setPlatformEdition(this.getPlatformEdition());
            jsonPlatformInfo.setDefaultWorkSpaceName(repo.getConfiguration().getDefaultWorkspaceName());
            if (sc.getUserPrincipal() != null) {
                jsonPlatformInfo.setUserHomeNodePath(nodeHierarchyCreator.getUserNode(sessionProvider, sc.getUserPrincipal().getName()).getPath());
            } else {
                jsonPlatformInfo.setUserHomeNodePath("");
            }
            if (this.platformInformations.getEdition() != null && !this.platformInformations.getEdition().equals("")) {
                jsonPlatformInfo.setDuration(this.platformInformations.getDuration());
                jsonPlatformInfo.setDateOfKeyGeneration(this.platformInformations.getDateOfLicence());
                jsonPlatformInfo.setNbUsers(this.platformInformations.getNumberOfUsers());
                if (this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
                    jsonPlatformInfo.setProductCode(this.platformInformations.getProductCode());
                    jsonPlatformInfo.setUnlockKey(this.platformInformations.getProductKey());
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Getting Platform Informations: eXo Platform (v" + this.platformInformations.getVersion() + " - build " + this.platformInformations.getBuildNumber() + " - rev. " + this.platformInformations.getRevision()));
            }
            Response response = Response.ok((Object)jsonPlatformInfo, (String)"application/json").cacheControl(cacheControl).build();
            return response;
        }
    }

    private Boolean isMobileCompliant() {
        String platformEdition = this.getPlatformEdition();
        return platformEdition != null && (platformEdition.equals(COMMUNITY_EDITION) || platformEdition.equalsIgnoreCase("ENTERPRISE") || platformEdition.equals("EXPRESS"));
    }

    private String getPlatformEdition() {
        try {
            Class<?> c = Class.forName("org.exoplatform.platform.edition.PlatformEdition");
            Method getEditionMethod = c.getMethod("getEdition", new Class[0]);
            String platformEdition = (String)getEditionMethod.invoke(null, new Object[0]);
            if (platformEdition != null && platformEdition.equals("enterprise") && this.platformInformations.getEdition() != null && !this.platformInformations.getEdition().equals("")) {
                platformEdition = this.platformInformations.getEdition();
            }
            return platformEdition;
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while getting the platform edition information.", (Throwable)e);
            return null;
        }
    }

    public static class JsonPlatformInfo {
        private String platformVersion;
        private String platformBuildNumber;
        private String platformRevision;
        private String platformEdition;
        private String isMobileCompliant;
        private String runningProfile;
        private String nbUsers;
        private String duration;
        private String buildNumber;
        private String productCode;
        private String dateOfKeyGeneration;
        private String unlockKey;
        private String currentRepoName;
        private String defaultWorkSpaceName;
        private String userHomeNodePath;

        public void setNbUsers(String nbUsers) {
            this.nbUsers = nbUsers;
        }

        public void setDuration(String duration) {
            this.duration = duration;
        }

        public void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        public String getUnlockKey() {
            return this.unlockKey;
        }

        public void setUnlockKey(String unlockKey) {
            this.unlockKey = unlockKey;
        }

        public void setDateOfKeyGeneration(String dateOfKeyGeneration) {
            this.dateOfKeyGeneration = dateOfKeyGeneration;
        }

        public String getNbUsers() {
            return this.nbUsers;
        }

        public String getProductCode() {
            return this.productCode;
        }

        public String getDateOfKeyGeneration() {
            return this.dateOfKeyGeneration;
        }

        public String getDuration() {
            return this.duration;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String getPlatformVersion() {
            return this.platformVersion;
        }

        public void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public String getIsMobileCompliant() {
            return this.isMobileCompliant;
        }

        public void setIsMobileCompliant(String isMobileCompliant) {
            this.isMobileCompliant = isMobileCompliant;
        }

        public String getPlatformBuildNumber() {
            return this.platformBuildNumber;
        }

        public void setPlatformBuildNumber(String platformBuildNumber) {
            this.platformBuildNumber = platformBuildNumber;
        }

        public String getPlatformRevision() {
            return this.platformRevision;
        }

        public void setPlatformRevision(String platformRevision) {
            this.platformRevision = platformRevision;
        }

        public String getPlatformEdition() {
            return this.platformEdition;
        }

        public void setPlatformEdition(String platformEdition) {
            this.platformEdition = platformEdition;
        }

        public String getUserHomeNodePath() {
            return this.userHomeNodePath;
        }

        public void setUserHomeNodePath(String userHomeNodePath) {
            this.userHomeNodePath = userHomeNodePath;
        }

        public String getRunningProfile() {
            return this.runningProfile;
        }

        public void setRunningProfile(String runningProfile) {
            this.runningProfile = runningProfile;
        }

        public String getCurrentRepoName() {
            return this.currentRepoName;
        }

        public void setCurrentRepoName(String currentRepoName) {
            this.currentRepoName = currentRepoName;
        }

        public String getDefaultWorkSpaceName() {
            return this.defaultWorkSpaceName;
        }

        public void setDefaultWorkSpaceName(String defaultWorkSpaceName) {
            this.defaultWorkSpaceName = defaultWorkSpaceName;
        }
    }
}

