/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.service;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;

public class NotificationCompletionService {
    private final String THREAD_NUMBER_KEY = "thread-number";
    private final String ASYNC_EXECUTION_KEY = "async-execution";
    private final String KEEP_ALIVE_TIME = "keepAliveTime";
    private Executor executor;
    private ExecutorCompletionService<?> ecs;
    private BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    private final int DEFAULT_THREAD_NUMBER = 1;
    private final boolean DEFAULT_ASYNC_EXECUTION = true;
    private int configThreadNumber;
    private int keepAliveTime;
    private boolean configAsyncExecution;

    public NotificationCompletionService(InitParams params) {
        ValueParam threadNumberValue = params.getValueParam("thread-number");
        ValueParam asyncExecution = params.getValueParam("async-execution");
        ValueParam aliveTime = params.getValueParam("keepAliveTime");
        try {
            this.configThreadNumber = Integer.valueOf(threadNumberValue.getValue());
        }
        catch (Exception e) {
            this.configThreadNumber = 1;
        }
        try {
            this.keepAliveTime = Integer.valueOf(aliveTime.getValue());
        }
        catch (Exception e) {
            this.keepAliveTime = 10;
        }
        try {
            this.configAsyncExecution = Boolean.valueOf(asyncExecution.getValue());
        }
        catch (Exception e) {
            this.configAsyncExecution = true;
        }
        int threadNumber = this.configThreadNumber <= 0 ? this.configThreadNumber : Runtime.getRuntime().availableProcessors();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "Notification-Thread");
                t.setPriority(1);
                return t;
            }
        };
        if (this.configAsyncExecution) {
            this.executor = new ThreadPoolExecutor(threadNumber, threadNumber, (long)this.keepAliveTime, TimeUnit.SECONDS, this.workQueue, threadFactory);
            ((ThreadPoolExecutor)this.executor).allowCoreThreadTimeOut(true);
        } else {
            this.executor = new DirectExecutor();
        }
        this.ecs = new ExecutorCompletionService(this.executor);
    }

    public void addTask(Callable callable) {
        this.ecs.submit(callable);
    }

    public void waitCompletionFinished() {
        try {
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAsync() {
        return this.configAsyncExecution;
    }

    private class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            if (Thread.interrupted()) {
                throw new RuntimeException();
            }
            runnable.run();
        }
    }
}

