/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeUserNotificationSettingPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeUserNotificationSettingPlugin.class);
    private final String workspace;
    public static final String NAME_PATTERN = "exo:{CHANNELID}Channel";

    public UpgradeUserNotificationSettingPlugin(InitParams initParams) {
        super(initParams);
        NotificationConfiguration configuration = (NotificationConfiguration)CommonsUtils.getService(NotificationConfiguration.class);
        this.workspace = configuration != null ? configuration.getWorkspace() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.workspace == null) {
            return;
        }
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        try {
            Session session = AbstractService.getSession((SessionProvider)sProvider, (String)this.workspace);
            Node userNodes = session.getRootNode().getNode("settings").getNode("user");
            NodeIterator iterator = userNodes.getNodes();
            while (iterator.hasNext()) {
                Node userNode = iterator.nextNode();
                if (!userNode.hasNode("global")) continue;
                LOG.info((Object)("Updating notification setting of user : " + userNode.getName()));
                Node userSettingNode = userNode.getNode("global");
                this.updateProperty("exo:daily", "", userSettingNode);
                this.updateProperty("exo:weekly", "", userSettingNode);
                String s = userSettingNode.getProperty("exo:instantly").getString();
                userSettingNode.setProperty(NAME_PATTERN.replace("{CHANNELID}", "MAIL_CHANNEL"), NotificationUtils.listToString((List)NotificationUtils.stringToList((String)s), (String)"{VALUE}"));
                userSettingNode.setProperty("exo:instantly", (Value)null);
                PluginContainer container = (PluginContainer)CommonsUtils.getService(PluginContainer.class);
                ChannelManager channelManager = (ChannelManager)CommonsUtils.getService(ChannelManager.class);
                StringBuilder builder = new StringBuilder();
                boolean hasMore = false;
                for (AbstractChannel channel : channelManager.getChannels()) {
                    if ("MAIL_CHANNEL".equals(channel.getId())) continue;
                    userSettingNode.setProperty(NAME_PATTERN.replace("{CHANNELID}", channel.getId()), NotificationUtils.listToString((List)container.getDefaultActivePlugins(), (String)"{VALUE}"));
                    if (hasMore) {
                        builder.append(",");
                    }
                    builder.append(channel.getId());
                    hasMore = true;
                }
                this.updateProperty("exo:isActive", builder.toString(), userSettingNode);
                userSettingNode.getSession().save();
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to migrate user setting", (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider((boolean)created);
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    private void updateProperty(String property, String defaultValue, Node userSettingNode) throws Exception {
        Value value = userSettingNode.getProperty(property).getValue();
        if (value != null) {
            String strs = value.getString();
            if ("true".equals(strs)) {
                strs = "MAIL_CHANNEL," + defaultValue;
            }
            if ("false".equals(strs)) {
                strs = defaultValue;
            }
            defaultValue = NotificationUtils.listToString((List)NotificationUtils.stringToList((String)strs), (String)"{VALUE}");
        }
        userSettingNode.setProperty(property, defaultValue);
    }
}

