/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.component.explorer.UIDriveSelector;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditContainer;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectTypeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectDriveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectNodePathActionListener.class})})
public class UIJcrExplorerEditForm
extends UIForm
implements UISelectable {
    private boolean flagSelectRender = false;
    public static final String PARAM_PATH_ACTION = "SelectNodePath";
    public static final String PARAM_PATH_INPUT = "nodePath";
    private static final String POPUP_SELECT_PATH_INPUT = "PopupSelectPath";

    public UIJcrExplorerEditForm() throws Exception {
        ArrayList<SelectItemOption> listType = new ArrayList<SelectItemOption>();
        String usecase = this.getPreference().getValue("usecase", "");
        listType.add(new SelectItemOption("Selection", (Object)"selection"));
        listType.add(new SelectItemOption("Jailed", (Object)"jailed"));
        listType.add(new SelectItemOption("Personal", (Object)"personal"));
        listType.add(new SelectItemOption("Parameterize", (Object)"parameterize"));
        UIFormSelectBox typeSelectBox = new UIFormSelectBox("usecase", "usecase", listType);
        typeSelectBox.setValue(usecase);
        typeSelectBox.setOnChange("SelectType");
        this.addChild((UIComponent)typeSelectBox);
        UIFormInputSetWithAction driveNameInput = new UIFormInputSetWithAction("DriveNameInput");
        UIFormStringInput stringInputDrive = new UIFormStringInput("driveName", "driveName", null);
        stringInputDrive.setValue((Object)this.getPreference().getValue("driveName", ""));
        stringInputDrive.setDisabled(true);
        driveNameInput.addUIFormInput((UIFormInput)stringInputDrive);
        driveNameInput.setActionInfo("driveName", new String[]{"SelectDrive"});
        this.addUIComponentInput((UIComponent)driveNameInput);
        UIFormInputSetWithAction uiParamPathInput = new UIFormInputSetWithAction(PARAM_PATH_ACTION);
        UIFormStringInput pathInput = new UIFormStringInput(PARAM_PATH_INPUT, PARAM_PATH_INPUT, null);
        pathInput.setValue((Object)this.getPreference().getValue(PARAM_PATH_INPUT, ""));
        pathInput.setDisabled(true);
        uiParamPathInput.addUIFormInput((UIFormInput)pathInput);
        uiParamPathInput.setActionInfo(PARAM_PATH_INPUT, new String[]{PARAM_PATH_ACTION});
        this.addUIComponentInput((UIComponent)uiParamPathInput);
        driveNameInput.setRendered(true);
        uiParamPathInput.setRendered(false);
        UICheckBoxInput uiFormCheckBoxTop = new UICheckBoxInput("showTopBar", "showTopBar", Boolean.valueOf(true));
        uiFormCheckBoxTop.setChecked(Boolean.parseBoolean(this.getPreference().getValue("showTopBar", "true")));
        this.addUIFormInput((UIFormInput)uiFormCheckBoxTop);
        UICheckBoxInput uiFormCheckBoxAction = new UICheckBoxInput("showActionBar", "showActionBar", Boolean.valueOf(true));
        uiFormCheckBoxAction.setChecked(Boolean.parseBoolean(this.getPreference().getValue("showActionBar", "true")));
        this.addUIFormInput((UIFormInput)uiFormCheckBoxAction);
        UICheckBoxInput uiFormCheckBoxSide = new UICheckBoxInput("showSideBar", "showSideBar", Boolean.valueOf(true));
        uiFormCheckBoxSide.setChecked(Boolean.parseBoolean(this.getPreference().getValue("showSideBar", "true")));
        this.addUIFormInput((UIFormInput)uiFormCheckBoxSide);
        UICheckBoxInput uiFormCheckBoxFilter = new UICheckBoxInput("showFilterBar", "showFilterBar", Boolean.valueOf(true));
        uiFormCheckBoxFilter.setChecked(Boolean.parseBoolean(this.getPreference().getValue("showFilterBar", "true")));
        this.addUIFormInput((UIFormInput)uiFormCheckBoxFilter);
        if (usecase.equals("jailed")) {
            this.setFlagSelectRender(true);
        } else if (usecase.equals("personal")) {
            driveNameInput.setRendered(false);
            this.setFlagSelectRender(true);
        } else if (usecase.equals("parameterize")) {
            uiParamPathInput.setRendered(true);
            this.setFlagSelectRender(true);
        }
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public boolean isFlagSelectRender() {
        return this.flagSelectRender;
    }

    public void setFlagSelectRender(boolean flagSelectRender) {
        this.flagSelectRender = flagSelectRender;
    }

    private PortletPreferences getPreference() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pcontext.getRequest().getPreferences();
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String stValue = null;
        stValue = "/".equals(String.valueOf(value)) ? "/" : (String.valueOf(value).split(":/").length > 1 ? String.valueOf(value).split(":/")[1] : "/");
        ((UIFormStringInput)this.findComponentById(selectField)).setValue((Object)stValue);
        UIJcrExplorerEditContainer uiContainer = (UIJcrExplorerEditContainer)this.getParent();
        for (UIComponent uiChild : uiContainer.getChildren()) {
            if (!uiChild.getId().equals(POPUP_SELECT_PATH_INPUT)) continue;
            UIPopupWindow uiPopup = (UIPopupWindow)uiContainer.getChildById(uiChild.getId());
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
        }
    }

    public static class SelectNodePathActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            UIJcrExplorerEditContainer editContainer = (UIJcrExplorerEditContainer)uiForm.getParent();
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)uiForm.getChildById("DriveNameInput");
            UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
            String driveName = (String)stringInputDrive.getValue();
            if (driveName == null || driveName.length() == 0) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.personal-usecase", null, 1));
                return;
            }
            editContainer.initPopupDriveBrowser(UIJcrExplorerEditForm.POPUP_SELECT_PATH_INPUT, driveName);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class SelectDriveActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            UIJcrExplorerEditContainer editContainer = (UIJcrExplorerEditContainer)uiForm.getParent();
            UIPopupWindow popupWindow = editContainer.initPopup("PopUpSelectDrive");
            UIDriveSelector driveSelector = (UIDriveSelector)editContainer.createUIComponent(UIDriveSelector.class, null, null);
            driveSelector.updateGrid();
            popupWindow.setUIComponent((UIComponent)driveSelector);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class SaveActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            PortletPreferences pref = uiForm.getPreference();
            UIFormSelectBox typeSelectBox = (UIFormSelectBox)uiForm.getChildById("usecase");
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)uiForm.getChildById("DriveNameInput");
            UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
            UICheckBoxInput uiFormCheckBoxTop = (UICheckBoxInput)uiForm.getChildById("showTopBar");
            UICheckBoxInput uiFormCheckBoxAction = (UICheckBoxInput)uiForm.getChildById("showActionBar");
            UICheckBoxInput uiFormCheckBoxSide = (UICheckBoxInput)uiForm.getChildById("showSideBar");
            UICheckBoxInput uiFormCheckBoxFilter = (UICheckBoxInput)uiForm.getChildById("showFilterBar");
            String nodePath = (String)((UIFormStringInput)uiForm.findComponentById(UIJcrExplorerEditForm.PARAM_PATH_INPUT)).getValue();
            String driveName = (String)stringInputDrive.getValue();
            String useCase = (String)typeSelectBox.getValue();
            if (useCase.equals("jailed")) {
                if (driveName == null || driveName.length() == 0) {
                    UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.notNullDriveName", null, 1));
                    return;
                }
            } else if (useCase.equals("parameterize") && (nodePath == null || nodePath.length() == 0)) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.notNullPath", null, 1));
                return;
            }
            if (useCase.equals("selection")) {
                nodePath = "/";
            }
            uiForm.setFlagSelectRender(true);
            pref.setValue("usecase", useCase);
            pref.setValue("driveName", driveName);
            pref.setValue(UIJcrExplorerEditForm.PARAM_PATH_INPUT, nodePath);
            pref.setValue("showActionBar", String.valueOf(uiFormCheckBoxAction.getValue()));
            pref.setValue("showTopBar", String.valueOf(uiFormCheckBoxTop.getValue()));
            pref.setValue("showSideBar", String.valueOf(uiFormCheckBoxSide.getValue()));
            pref.setValue("showFilterBar", String.valueOf(uiFormCheckBoxFilter.getValue()));
            pref.store();
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.fields-saved", null));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class SelectTypeActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            UIJCRExplorerPortlet uiJExplorerPortlet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            UIFormSelectBox typeSelectBox = (UIFormSelectBox)uiForm.getChildById("usecase");
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)uiForm.getChildById("DriveNameInput");
            UIFormInputSetWithAction uiParamPathInput = (UIFormInputSetWithAction)uiForm.getChildById(UIJcrExplorerEditForm.PARAM_PATH_ACTION);
            driveNameInput.setRendered(true);
            uiParamPathInput.setRendered(false);
            if (((String)typeSelectBox.getValue()).equals("jailed")) {
                UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
                stringInputDrive.setRendered(true);
                stringInputDrive.setValue((Object)"");
                driveNameInput.setRendered(true);
            } else if (((String)typeSelectBox.getValue()).equals("selection")) {
                UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
                if (stringInputDrive.isRendered()) {
                    stringInputDrive.setRendered(false);
                }
            } else if (((String)typeSelectBox.getValue()).equals("personal")) {
                DriveData personalPrivateDrive = uiJExplorerPortlet.getUserDrive();
                UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
                stringInputDrive.setRendered(true);
                stringInputDrive.setValue((Object)personalPrivateDrive.getName());
                driveNameInput.setRendered(false);
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.personal-usecase", null));
            } else if (((String)typeSelectBox.getValue()).equals("parameterize")) {
                UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
                stringInputDrive.setRendered(true);
                stringInputDrive.setValue((Object)"");
                driveNameInput.setRendered(true);
                UIFormStringInput stringInputDrivePath = uiParamPathInput.getUIStringInput(UIJcrExplorerEditForm.PARAM_PATH_INPUT);
                stringInputDrivePath.setValue((Object)"");
                uiParamPathInput.setRendered(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class CancelActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            PortletPreferences pref = uiForm.getPreference();
            UIFormSelectBox typeSelectBox = (UIFormSelectBox)uiForm.getChildById("usecase");
            typeSelectBox.setValue(pref.getValue("usecase", ""));
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)uiForm.getChildById("DriveNameInput");
            UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
            stringInputDrive.setValue((Object)pref.getValue("driveName", ""));
            UICheckBoxInput checkBoxShowTopBar = (UICheckBoxInput)uiForm.getChildById("showTopBar");
            checkBoxShowTopBar.setChecked(Boolean.parseBoolean(pref.getValue("showTopBar", "true")));
            UICheckBoxInput checkBoxShowActionBar = (UICheckBoxInput)uiForm.getChildById("showActionBar");
            checkBoxShowActionBar.setChecked(Boolean.parseBoolean(pref.getValue("showActionBar", "true")));
            UICheckBoxInput checkBoxShowLeftBar = (UICheckBoxInput)uiForm.getChildById("showSideBar");
            checkBoxShowLeftBar.setChecked(Boolean.parseBoolean(pref.getValue("showSideBar", "true")));
            UICheckBoxInput checkBoxShowFilterBar = (UICheckBoxInput)uiForm.getChildById("showFilterBar");
            checkBoxShowFilterBar.setChecked(Boolean.parseBoolean(pref.getValue("showFilterBar", "true")));
            UIFormInputSetWithAction uiParamPathInput = (UIFormInputSetWithAction)uiForm.getChildById(UIJcrExplorerEditForm.PARAM_PATH_ACTION);
            UIFormStringInput stringInputPath = uiParamPathInput.getUIStringInput(UIJcrExplorerEditForm.PARAM_PATH_INPUT);
            stringInputPath.setValue((Object)pref.getValue(UIJcrExplorerEditForm.PARAM_PATH_INPUT, ""));
            if (pref.getValue("usecase", "").equals("jailed")) {
                driveNameInput.setRendered(true);
                uiParamPathInput.setRendered(false);
            } else if (pref.getValue("usecase", "").equals("parameterize")) {
                driveNameInput.setRendered(true);
                uiParamPathInput.setRendered(true);
            } else {
                driveNameInput.setRendered(false);
                uiParamPathInput.setRendered(false);
            }
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.fields-cancelled", null));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }
}

