/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.component.explorer.rightclick.manager.DeleteManageComponent;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={MoveNodeActionListener.class}, confirm="UIWorkingArea.msg.confirm-move")})
public class MoveNodeManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotTrashHomeNodeFilter()});
    private static final Log LOG = ExoLogger.getLogger((String)MoveNodeManageComponent.class.getName());

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private static void processMultipleSelection(String nodePath, String destPath, Event<? extends UIComponent> event) throws Exception {
        Node destNode;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(destPath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + destPath + "'");
        }
        wsName = matcher.group(1);
        destPath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        UIApplication uiApp = (UIApplication)((UIComponent)event.getSource()).getAncestorOfType(UIApplication.class);
        if (destPath.startsWith(nodePath)) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.bound-move-exception", null, 1));
            return;
        }
        try {
            destNode = uiExplorer.getNodeByPath(destPath, session);
            destPath = destNode.getPath();
            session = destNode.getSession();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        if (!PermissionUtil.canAddNode((Node)destNode)) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-move-node", null, 1));
            uiExplorer.updateAjax(event);
            return;
        }
        if (uiExplorer.nodeIsLocked(destNode)) {
            Object[] arg = new Object[]{destPath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
            return;
        }
        if (!destNode.isCheckedOut()) {
            uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null));
            return;
        }
        try {
            if (nodePath.indexOf(";") > -1) {
                MoveNodeManageComponent.moveMultiNode(nodePath.split(";"), destNode, event);
            } else {
                MoveNodeManageComponent.moveNode(nodePath, null, destNode, event);
            }
            session.save();
            uiExplorer.updateAjax(event);
        }
        catch (AccessDeniedException ace) {
            Object[] arg = new Object[]{destPath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.has-not-add-permission", arg, 1));
            return;
        }
        catch (LockException lock) {
            Object[] arg = new Object[]{nodePath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
            return;
        }
        catch (ConstraintViolationException constraint) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.move-constraint-exception", null, 1));
            return;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs while selecting the node", (Throwable)e);
            }
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
    }

    private static Node getNodeByPath(String srcPath, UIJCRExplorer uiExplorer) throws Exception {
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
        }
        wsName = matcher.group(1);
        srcPath = matcher.group(2);
        Session srcSession = uiExplorer.getSessionByWorkspace(wsName);
        return uiExplorer.getNodeByPath(srcPath, srcSession, false);
    }

    private static void moveNode(String srcPath, Node selectedNode, Node destNode, Event<?> event) throws Exception {
        UIComponent uiComponent = (UIComponent)event.getSource();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)uiComponent.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiComponent.getAncestorOfType(UIApplication.class);
        if (srcPath.indexOf(":/") > -1 || selectedNode != null) {
            String[] arrSrcPath = srcPath.split(":/");
            if (srcPath.contains(":/") && ("/" + arrSrcPath[1]).equals(destNode.getPath()) || selectedNode != null && selectedNode.equals(destNode)) {
                uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.can-not-move-to-itself", null, 1));
                return;
            }
        }
        if (uiExplorer.isEditingDocument()) {
            uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.is-editing", null, 1));
            return;
        }
        String messagePath = "";
        try {
            String destPath;
            if (selectedNode == null) {
                selectedNode = MoveNodeManageComponent.getNodeByPath(srcPath, uiExplorer);
            }
            Session srcSession = selectedNode.getSession();
            if (!selectedNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                return;
            }
            uiExplorer.addLockToken(selectedNode);
            messagePath = destPath = destNode.getPath();
            destPath = destPath.concat("/").concat(selectedNode.getName());
            Workspace srcWorkspace = srcSession.getWorkspace();
            Workspace destWorkspace = destNode.getSession().getWorkspace();
            if (srcPath.indexOf(":/") > -1) {
                srcPath = srcPath.substring(srcPath.indexOf(":/") + 1);
            }
            ThumbnailService thumbnailService = (ThumbnailService)WCMCoreUtils.getService(ThumbnailService.class);
            Node srcThumbnailNode = thumbnailService.getThumbnailNode(selectedNode);
            ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
            ActivityCommonService activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
            Node desNode = null;
            if (srcWorkspace.equals(destWorkspace)) {
                srcWorkspace.move(srcPath, destPath);
                MoveNodeManageComponent.removeMixinEXO_RESTORE_LOCATION(srcSession, destPath);
                desNode = (Node)srcSession.getItem(destPath);
                LockUtil.changeLockToken((String)srcPath, (Node)desNode);
                if (activityService.isAcceptedNode(desNode) || desNode.getPrimaryNodeType().getName().equals("nt:file")) {
                    listenerService.broadcast(ActivityCommonService.NODE_MOVED_ACTIVITY, (Object)desNode, (Object)desNode.getPath());
                }
                srcSession.save();
            } else {
                destWorkspace.clone(srcWorkspace.getName(), srcPath, destPath, false);
                desNode = (Node)destWorkspace.getSession().getItem(destPath);
                if (activityService.isAcceptedNode(desNode) || desNode.getPrimaryNodeType().getName().equals("nt:file")) {
                    listenerService.broadcast(ActivityCommonService.NODE_MOVED_ACTIVITY, (Object)desNode, (Object)destPath);
                }
                MoveNodeManageComponent.removeMixinEXO_RESTORE_LOCATION(destWorkspace.getSession(), destPath);
                destWorkspace.getSession().save();
            }
            thumbnailService.copyThumbnailNode(srcThumbnailNode, desNode);
        }
        catch (Exception e) {
            Object[] args = new Object[]{srcPath, messagePath};
            uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.move-problem", args, 1));
            return;
        }
    }

    private static void removeMixinEXO_RESTORE_LOCATION(Session session, String restorePath) throws Exception {
        Node sameNameNode = (Node)session.getItem(restorePath);
        Node parent = sameNameNode.getParent();
        String name = sameNameNode.getName();
        NodeIterator nodeIter = parent.getNodes(name);
        while (nodeIter.hasNext()) {
            Node node = nodeIter.nextNode();
            if (!node.isNodeType("exo:restoreLocation")) continue;
            node.removeMixin("exo:restoreLocation");
        }
    }

    private static void moveMultiNode(String[] srcPaths, Node destNode, Event<? extends UIComponent> event) throws Exception {
        Node node;
        HashMap<String, Node> mapNode = new HashMap<String, Node>();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
        for (int i = 0; i < srcPaths.length; ++i) {
            node = MoveNodeManageComponent.getNodeByPath(srcPaths[i], uiExplorer);
            mapNode.put(node.getPath(), node);
        }
        String path2 = null;
        for (String path2 : mapNode.keySet()) {
            node = (Node)mapNode.get(path2);
            node.refresh(true);
            MoveNodeManageComponent.moveNode(node.getPath(), node, destNode, event);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class MoveNodeActionListener
    extends UIWorkingAreaActionListener<MoveNodeManageComponent> {
        public void processEvent(Event<MoveNodeManageComponent> event) throws Exception {
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            String destPath = event.getRequestContext().getRequestParameter("destInfo");
            if (MoveNodeActionListener.isInTrash(nodePath) && MoveNodeActionListener.isInTrash(destPath)) {
                return;
            }
            if (MoveNodeActionListener.isInTrash(destPath)) {
                ((DeleteManageComponent)((UIWorkingArea)((MoveNodeManageComponent)((Object)event.getSource())).getParent()).getChild(DeleteManageComponent.class)).doDelete(nodePath, event);
            } else {
                MoveNodeManageComponent.processMultipleSelection(nodePath.trim(), destPath.trim(), (Event<? extends UIComponent>)event);
            }
        }

        private static boolean isInTrash(String path) {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences portletPref = pcontext.getRequest().getPreferences();
            String trashHomeNodePath = portletPref.getValue("trashHomeNodePath", "");
            String trashWorkspace = portletPref.getValue("trashWorkspace", "");
            return path.startsWith(trashHomeNodePath) || path.startsWith(trashWorkspace + ":" + trashHomeNodePath);
        }
    }
}

