/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.space.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Path(value="/space")
public class SpaceRestServiceImpl
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(SpaceRestServiceImpl.class);
    private final SpaceService spaceService;
    private final CacheControl cacheControl;
    private static final int MAX_LOADED_SPACES_BY_REQUEST = 20;
    ListAccess<Space> listAccess;

    public SpaceRestServiceImpl(SpaceService spaceService) {
        this.spaceService = spaceService;
        this.cacheControl = new CacheControl();
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
    }

    @GET
    @Path(value="/user/searchSpace/")
    public Response searchSpaces(@QueryParam(value="keyword") String keyword, @Context SecurityContext sc) {
        StringBuffer baseSpaceURL = null;
        List<Object> spaces = new ArrayList();
        try {
            ArrayList alphabeticallySort = new ArrayList();
            String userId = sc.getUserPrincipal().getName();
            if (userId == null) {
                return Response.status((int)500).cacheControl(this.cacheControl).build();
            }
            this.listAccess = keyword == null || keyword.equals("") ? this.spaceService.getMemberSpacesByFilter(userId, null) : this.spaceService.getMemberSpacesByFilter(userId, new SpaceFilter(keyword));
            List<Object> spacesSearched = Arrays.asList(this.listAccess.load(0, 20));
            ListAccess allSpacesSorted = this.spaceService.getVisitedSpaces(userId, null);
            spaces = Arrays.asList(allSpacesSorted.load(0, 20));
            ArrayList<Space> sortedSearchedSpaces = new ArrayList<Space>();
            for (Space space : spaces) {
                baseSpaceURL = new StringBuffer();
                baseSpaceURL.append(PortalContainer.getCurrentPortalContainerName() + "/g/:spaces:");
                String groupId = space.getGroupId();
                String permanentSpaceName = groupId.split("/")[2];
                if (!SpaceRestServiceImpl.filterSpace(space.getId(), spacesSearched)) continue;
                if (permanentSpaceName.equals(space.getPrettyName())) {
                    baseSpaceURL.append(permanentSpaceName);
                    baseSpaceURL.append("/");
                    baseSpaceURL.append(permanentSpaceName);
                } else {
                    baseSpaceURL.append(space.getPrettyName());
                    baseSpaceURL.append("/");
                    baseSpaceURL.append(space.getPrettyName());
                }
                space.setUrl(baseSpaceURL.toString());
                sortedSearchedSpaces.add(space);
            }
            return Response.ok(sortedSearchedSpaces, (String)"application/json").cacheControl(this.cacheControl).build();
        }
        catch (Exception ex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"An exception happens when searchSpaces", (Throwable)ex);
            }
            return Response.status((int)500).cacheControl(this.cacheControl).build();
        }
    }

    private static boolean filterSpace(String spaceId, List<Space> spacesSearched) {
        for (Space space : spacesSearched) {
            if (!space.getId().equalsIgnoreCase(spaceId)) continue;
            return true;
        }
        return false;
    }
}

