/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gatein.common.util.Base64;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.ParametersStateString;

public abstract class StateString
implements Serializable {
    public static final String JBPNS_PREFIX = "JBPNS_";
    protected static final int EMPTY = 0;
    protected static final int SERIALIZED = 1;
    protected static final int OPAQUE = 2;
    private static final String EOF = "__EOF__";

    public abstract String getStringValue();

    public abstract void writeTo(DataOutputStream var1) throws IOException;

    public static StateString create(DataInputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        byte b = in.readByte();
        switch (b) {
            case 0: {
                return new ParametersStateString();
            }
            case 1: {
                return new ParametersStateString(in);
            }
            case 2: {
                return new OpaqueStateString(in.readUTF());
            }
        }
        throw new IllegalArgumentException("Wrong format unrecognized header " + b);
    }

    public static StateString create(String opaqueValue) {
        if (opaqueValue == null) {
            throw new IllegalArgumentException();
        }
        if (opaqueValue.startsWith(JBPNS_PREFIX)) {
            return new ParametersStateString(opaqueValue);
        }
        return new OpaqueStateString(opaqueValue);
    }

    public static Map<String, String[]> decodeOpaqueValue(String opaqueValue) {
        if (!opaqueValue.startsWith(JBPNS_PREFIX)) {
            throw new IllegalArgumentException("Bad format: [" + opaqueValue + "] was not encoded by the JBoss portlet container and thus cannot be decoded.");
        }
        if ((opaqueValue = opaqueValue.substring(JBPNS_PREFIX.length())).length() > 0) {
            try {
                byte[] bytes = Base64.decode((String)opaqueValue, (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bais);
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                String current = ois.readUTF();
                while (!EOF.equals(current)) {
                    int length = ois.readInt();
                    String[] values = new String[length];
                    for (int i = 0; i < length; ++i) {
                        values[i] = ois.readUTF();
                    }
                    params.put(current, values);
                    current = ois.readUTF();
                }
                return params;
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        return Collections.emptyMap();
    }

    public static String encodeAsOpaqueValue(Map<String, String[]> parameters) {
        if (parameters != null && parameters.size() != 0) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                    String name = entry.getKey();
                    oos.writeUTF(name);
                    String[] values = entry.getValue();
                    int length = values.length;
                    oos.writeInt(length);
                    for (String value : values) {
                        oos.writeUTF(value);
                    }
                }
                oos.writeUTF(EOF);
                oos.close();
                byte[] bytes = baos.toByteArray();
                return JBPNS_PREFIX + Base64.encodeBytes((byte[])bytes, (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return JBPNS_PREFIX;
    }
}

