/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.binding.xml;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.portal.config.model.LocalizedString;
import org.exoplatform.portal.mop.management.binding.xml.Namespace;
import org.gatein.common.xml.stax.navigator.StaxNavUtils;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;

class Utils {
    private static final Pattern XMLLANG_PATTERN = Pattern.compile("^([a-zA-Z]{2})(?:-([a-zA-Z]{2}))?$");

    Utils() {
    }

    public static <N> void writeGateinObjectsNamespace(StaxWriter<N> writer) throws XMLStreamException {
        String gatein_object_ns = Namespace.CURRENT.getUri();
        String location = gatein_object_ns + " " + gatein_object_ns;
        writer.writeDefaultNamespace(gatein_object_ns);
        writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"), location);
    }

    public static <N> LocalizedString parseLocalizedString(StaxNavigator<N> navigator) throws StaxNavException {
        String attribute = navigator.getAttribute(new QName("http://www.w3.org/XML/1998/namespace", "lang", "xml"));
        if (attribute == null) {
            attribute = navigator.getAttribute("lang");
        }
        Locale lang = null;
        if (attribute != null) {
            Matcher matcher = XMLLANG_PATTERN.matcher(attribute);
            if (matcher.matches()) {
                String langISO = matcher.group(1);
                String countryISO = matcher.group(2);
                lang = countryISO == null ? new Locale(langISO.toLowerCase()) : new Locale(langISO.toLowerCase(), countryISO.toLowerCase());
            } else {
                throw new StaxNavException(navigator.getLocation(), "The attribute xml:lang='" + attribute + "' does not represent a valid language pattern (ie: en, en-us).");
            }
        }
        String value = StaxNavUtils.getRequiredContent(navigator, (boolean)false);
        return new LocalizedString(value, lang);
    }
}

