/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Statement;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.stages.EmbeddedContent;
import com.google.caja.plugin.stages.HtmlEmbeddedContentFinder;
import com.google.caja.plugin.templates.HtmlAttributeRewriter;
import com.google.caja.plugin.templates.IhtmlMessageType;
import com.google.caja.plugin.templates.SafeCssMaker;
import com.google.caja.plugin.templates.SafeHtmlMaker;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCompiler {
    private final List<Pair<Node, URI>> ihtmlRoots;
    private final List<CssTree.StyleSheet> safeStylesheets;
    private final HtmlSchema htmlSchema;
    private final PluginMeta meta;
    private final MessageContext mc;
    private final MessageQueue mq;
    private final HtmlAttributeRewriter aRewriter;
    private final Map<Node, ParseTreeNode> scriptsPerNode = Maps.newIdentityHashMap();
    private final Map<Attr, EmbeddedContent> embeddedContent = Maps.newIdentityHashMap();

    public TemplateCompiler(List<Pair<Node, URI>> ihtmlRoots, List<? extends CssTree.StyleSheet> safeStylesheets, CssSchema cssSchema, HtmlSchema htmlSchema, PluginMeta meta, MessageContext mc, MessageQueue mq) {
        this.ihtmlRoots = Lists.newArrayList(ihtmlRoots);
        this.safeStylesheets = Lists.newArrayList(safeStylesheets);
        this.htmlSchema = htmlSchema;
        this.meta = meta;
        this.mc = mc;
        this.mq = mq;
        this.aRewriter = new HtmlAttributeRewriter(meta, cssSchema, htmlSchema, this.embeddedContent, mq);
    }

    private void inspect() {
        if (!this.mq.hasMessageAtLevel(MessageLevel.FATAL_ERROR)) {
            for (Pair<Node, URI> ihtmlRoot : this.ihtmlRoots) {
                HtmlEmbeddedContentFinder finder = new HtmlEmbeddedContentFinder(this.htmlSchema, (URI)ihtmlRoot.b, this.mq, this.mc);
                for (EmbeddedContent c : finder.findEmbeddedContent((Node)ihtmlRoot.a)) {
                    Node src = c.getSource();
                    if (!(src instanceof Attr)) continue;
                    this.embeddedContent.put((Attr)src, c);
                }
                this.inspect((Node)ihtmlRoot.a, ElKey.forHtmlElement("div"));
            }
        }
    }

    private void inspect(Node n, ElKey containingHtmlElement) {
        switch (n.getNodeType()) {
            case 1: {
                this.inspectElement((Element)n, containingHtmlElement);
                break;
            }
            case 3: 
            case 4: {
                this.inspectText((Text)n, containingHtmlElement);
                break;
            }
            case 11: {
                this.inspectFragment((DocumentFragment)n, containingHtmlElement);
                break;
            }
        }
    }

    private void inspectElement(Element el, ElKey containingHtmlElement) {
        ElKey elKey = ElKey.forElement(el);
        for (Node node : Nodes.childrenOf(el)) {
            this.inspect(node, elKey);
        }
        if (!this.htmlSchema.isElementAllowed(elKey)) {
            return;
        }
        HTML.Element elInfo = this.htmlSchema.lookupElement(elKey);
        List<HTML.Attribute> list = elInfo.getAttributes();
        if (list != null) {
            for (HTML.Attribute a : list) {
                AttribKey attrKey = a.getKey();
                if (!this.htmlSchema.isAttributeAllowed(attrKey)) continue;
                Attr attr = null;
                String aUri = attrKey.ns.uri;
                String aName = attrKey.localName;
                Attr unsafe = el.getAttributeNodeNS(aUri, aName);
                if (unsafe != null && a.getValueCriterion().accept(unsafe.getValue())) {
                    attr = unsafe;
                } else if (a.getDefaultValue() != null && !a.getValueCriterion().accept(a.getDefaultValue()) || !a.isOptional()) {
                    attr = el.getOwnerDocument().createAttributeNS(aUri, aName);
                    String safeValue = a.getType() == HTML.Attribute.Type.URI ? "" + Nodes.getFilePositionFor(el).source().getUri() : a.getSafeValue();
                    if (safeValue == null) {
                        this.mq.addMessage((MessageTypeInt)IhtmlMessageType.MISSING_ATTRIB, Nodes.getFilePositionFor(el), elKey, attrKey);
                        continue;
                    }
                    attr.setNodeValue(safeValue);
                    el.setAttributeNodeNS(attr);
                }
                if (attr == null) continue;
                this.inspectHtmlAttribute(attr, a);
            }
        }
        this.scriptsPerNode.put(el, null);
    }

    private void inspectText(Text t, ElKey containingHtmlElement) {
        if (!this.htmlSchema.isElementAllowed(containingHtmlElement)) {
            return;
        }
        this.scriptsPerNode.put(t, null);
    }

    private void inspectFragment(DocumentFragment f, ElKey containingHtmlElement) {
        this.scriptsPerNode.put(f, null);
        for (Node node : Nodes.childrenOf(f)) {
            if (TemplateCompiler.isWhitespaceOnlyTextNode(node)) continue;
            this.inspect(node, containingHtmlElement);
        }
    }

    private static boolean isWhitespaceOnlyTextNode(Node child) {
        return child.getNodeType() == 3 && "".equals(child.getNodeValue().replaceAll("[\r\n]+[ \t]*", ""));
    }

    private void inspectHtmlAttribute(Attr attr, HTML.Attribute info) {
        HtmlAttributeRewriter.SanitizedAttr r = this.aRewriter.sanitizeStringValue(HtmlAttributeRewriter.fromAttr(attr, info));
        if (r.isSafe) {
            this.scriptsPerNode.put(attr, r.result);
        }
    }

    public Pair<Node, List<Block>> getSafeHtml(Document doc) {
        this.inspect();
        Pair<Statement, Element> css = new SafeCssMaker(this.safeStylesheets, doc).make();
        List<Node> roots = Lists.newArrayList();
        for (Pair<Node, URI> root : this.ihtmlRoots) {
            roots.add((Node)root.a);
        }
        SafeHtmlMaker htmlMaker = new SafeHtmlMaker(this.meta, this.mc, doc, this.scriptsPerNode, roots, this.aRewriter.getHandlers());
        return htmlMaker.make(css);
    }
}

