/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.forum.common.utils.AbstractListAccess;
import org.exoplatform.forum.common.utils.UserListAccess;
import org.exoplatform.forum.common.webui.BaseUIForm;
import org.exoplatform.forum.common.webui.UIPageIterator;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.organization.account.UIGroupSelector;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/organization/account/UIUserSelector.gtmpl", events={@EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={FindGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UIUserSelect
extends BaseUIForm
implements UIPopupComponent {
    public static final String ID_GROUP_SELECTOR = "UIPopupGroupSelector";
    public static final String FIELD_KEYWORD = "QuickSearch";
    public static final String FIELD_FILTER = "filter";
    public static final String FIELD_GROUP = "group";
    public static final String USER_NAME = UserHelper.FilterType.USER_NAME.getName();
    public static final String LAST_NAME = UserHelper.FilterType.LAST_NAME.getName();
    public static final String FIRST_NAME = UserHelper.FilterType.FIRST_NAME.getName();
    public static final String EMAIL = UserHelper.FilterType.EMAIL.getName();
    protected Map<String, User> userData_ = new HashMap<String, User>();
    private boolean isShowSearch_ = false;
    private boolean isShowSearchGroup = false;
    private boolean isShowSearchUser = true;
    private boolean isMultiSelect = true;
    private String selectedUsers;
    private String permisionType;
    private String selectedGroupId = null;
    private int numberUserDisplay = 10;
    private List<User> itemOfCurrentPage = new ArrayList<User>();
    public UIPageIterator<User> uiIterator_;

    public UIUserSelect() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_KEYWORD, FIELD_KEYWORD, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_FILTER, FIELD_FILTER, this.getFilters()));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_GROUP, FIELD_GROUP, null));
        this.isShowSearch_ = true;
        this.uiIterator_ = new UIPageIterator();
        this.uiIterator_.setId("UISelectUserPage");
        this.defaultUserList();
        ((UIPopupWindow)this.addChild(UIPopupWindow.class, null, ID_GROUP_SELECTOR)).setWindowSize(540, 0);
        this.setActions(new String[]{"Add", "Close"});
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (CommonUtils.isEmpty(this.getKeyword()) && !CommonUtils.isEmpty(this.selectedGroupId) && this.uiIterator_ != null) {
            ListAccess<User> listAccess = UserHelper.searchUser(new UserHelper.UserFilter("", null).setGroupId(this.selectedGroupId));
            this.uiIterator_.setListAccess((AbstractListAccess<User>)new UserListAccess(listAccess), this.numberUserDisplay);
        }
        this.initResult();
        super.processRender(context);
    }

    private void defaultUserList() throws Exception {
        ListAccess<User> listAccess = UserHelper.searchUser(new UserHelper.UserFilter("", null));
        this.uiIterator_.setListAccess((AbstractListAccess<User>)new UserListAccess(listAccess), this.numberUserDisplay);
    }

    private void initResult() throws Exception {
        UIPopupWindow uiPopup;
        this.itemOfCurrentPage = this.uiIterator_.getCurrentPageData();
        if (this.isMultiSelect()) {
            for (User user : this.itemOfCurrentPage) {
                UICheckBoxInput checkBox = this.getUICheckBoxInput(user.getUserName());
                if (checkBox == null) {
                    checkBox = new UICheckBoxInput(user.getUserName(), user.getUserName(), Boolean.valueOf(false));
                    this.addUIFormInput((UIFormInput)checkBox);
                }
                checkBox.setChecked(this.uiIterator_.isSelectedItem(user.getUserName()));
            }
        }
        if (this.isShowSearchGroup && (uiPopup = (UIPopupWindow)this.getChild(UIPopupWindow.class)).getUIComponent() == null) {
            UIGroupSelector uiGroup = (UIGroupSelector)this.createUIComponent(UIGroupSelector.class, null, null);
            uiPopup.setUIComponent((UIComponent)uiGroup);
            uiGroup.setId("GroupSelector");
            ((UITree)uiGroup.getChild(UITree.class)).setId("TreeGroupSelector");
            ((UIBreadcumbs)uiGroup.getChild(UIBreadcumbs.class)).setId("BreadcumbsGroupSelector");
        }
    }

    protected List<User> getData() {
        return this.itemOfCurrentPage;
    }

    public String getSelectedUsers() {
        return this.selectedUsers;
    }

    public void setSelectedUsers(String selectedUsers) {
        this.selectedUsers = selectedUsers;
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this.isMultiSelect = isMultiSelect;
    }

    public boolean isMultiSelect() {
        return this.isMultiSelect;
    }

    protected boolean getMulti() {
        return this.isMultiSelect;
    }

    public UIPageIterator<User> getUIPageIterator() {
        return this.uiIterator_;
    }

    public int getAvailablePage() throws Exception {
        return this.uiIterator_.getAvailablePage();
    }

    public int getCurrentPage() throws Exception {
        return this.uiIterator_.getCurrentPage();
    }

    public void setNumberUserDisplay(int numberUserDisplay) {
        this.numberUserDisplay = numberUserDisplay;
    }

    public String getSelectedGroupId() {
        return this.selectedGroupId;
    }

    public void setSpaceGroupId(String spaceGroupId) {
        this.selectedGroupId = spaceGroupId;
    }

    public String getPermisionType() {
        return this.permisionType;
    }

    public void setPermisionType(String permisionType) {
        this.permisionType = permisionType;
    }

    private List<SelectItemOption<String>> getFilters() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(this.getLabel(USER_NAME), (Object)USER_NAME));
        options.add(new SelectItemOption(this.getLabel(LAST_NAME), (Object)LAST_NAME));
        options.add(new SelectItemOption(this.getLabel(FIRST_NAME), (Object)FIRST_NAME));
        options.add(new SelectItemOption(this.getLabel(EMAIL), (Object)EMAIL));
        return options;
    }

    public void setShowSearch(boolean isShowSearch) {
        this.isShowSearch_ = isShowSearch;
    }

    public boolean isShowSearch() {
        return this.isShowSearch_;
    }

    public void setShowSearchGroup(boolean isShowSearchGroup) {
        this.isShowSearchGroup = isShowSearchGroup;
    }

    public boolean isShowSearchGroup() {
        return this.isShowSearchGroup;
    }

    public void setShowSearchUser(boolean isShowSearchUser) {
        this.isShowSearchUser = isShowSearchUser;
    }

    public boolean isShowSearchUser() {
        return this.isShowSearchUser;
    }

    public String getFilterGroup() {
        return (String)this.getUIStringInput(FIELD_GROUP).getValue();
    }

    public void setFilterGroup(String finterGroupId) {
        this.getUIStringInput(FIELD_GROUP).setValue((Object)finterGroupId);
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiIterator_.setCurrentPage(page);
    }

    public void setKeyword(String value) {
        this.getUIStringInput(FIELD_KEYWORD).setValue((Object)value);
    }

    public String getKeyword() {
        return (String)this.getUIStringInput(FIELD_KEYWORD).getValue();
    }

    private void setSelectedItem() throws Exception {
        for (User user : this.itemOfCurrentPage) {
            UICheckBoxInput input = this.getUICheckBoxInput(user.getUserName());
            if (input == null) continue;
            this.uiIterator_.setSelectedItem(user.getUserName(), input.isChecked());
        }
    }

    public static class ShowPageActionListener
    extends EventListener<UIUserSelect> {
        public void execute(Event<UIUserSelect> event) throws Exception {
            UIUserSelect uiSelectUserForm = (UIUserSelect)((Object)event.getSource());
            uiSelectUserForm.setSelectedItem();
            int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiSelectUserForm.updateCurrentPage(page);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSelectUserForm);
        }
    }

    public static class SearchGroupActionListener
    extends EventListener<UIUserSelect> {
        public void execute(Event<UIUserSelect> event) throws Exception {
            UIUserSelect uiForm = (UIUserSelect)((Object)event.getSource());
            ((UIPopupWindow)uiForm.getChild(UIPopupWindow.class)).setShow(true);
        }
    }

    public static class CloseActionListener
    extends EventListener<UIUserSelect> {
        public void execute(Event<UIUserSelect> event) throws Exception {
            UIUserSelect uiForm = (UIUserSelect)((Object)event.getSource());
            uiForm.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class SearchActionListener
    extends EventListener<UIUserSelect> {
        public void execute(Event<UIUserSelect> event) throws Exception {
            UIUserSelect uiForm = (UIUserSelect)((Object)event.getSource());
            String type = (String)uiForm.getUIFormSelectBox(UIUserSelect.FIELD_FILTER).getValue();
            UserHelper.FilterType filterType = UserHelper.FilterType.getType(type);
            if (filterType == null) {
                return;
            }
            String keyword = uiForm.getKeyword();
            String groupId = uiForm.getSelectedGroupId();
            UserHelper.UserFilter userFilter = new UserHelper.UserFilter(keyword, filterType);
            uiForm.uiIterator_.setListAccess((AbstractListAccess<User>)new UserListAccess(UserHelper.searchUser(userFilter.setGroupId(groupId))), uiForm.numberUserDisplay);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class FindGroupActionListener
    extends EventListener<UIUserSelect> {
        public void execute(Event<UIUserSelect> event) throws Exception {
            UIUserSelect uiSelectUserForm = (UIUserSelect)((Object)event.getSource());
            String groupId = uiSelectUserForm.getFilterGroup();
            if (!CommonUtils.isEmpty(groupId)) {
                if (UserHelper.getOrganizationService().getGroupHandler().findGroupById(groupId) != null) {
                    uiSelectUserForm.selectedGroupId = groupId;
                }
            } else {
                uiSelectUserForm.defaultUserList();
            }
            uiSelectUserForm.setKeyword("");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSelectUserForm);
        }
    }

    public static class SelectGroupActionListener
    extends EventListener<UIGroupSelector> {
        public void execute(Event<UIGroupSelector> event) throws Exception {
            UIGroupSelector uiSelectGroupForm = (UIGroupSelector)event.getSource();
            UIUserSelect uiSelectUserForm = (UIUserSelect)uiSelectGroupForm.getParent().getParent();
            uiSelectUserForm.selectedGroupId = event.getRequestContext().getRequestParameter("objectId");
            uiSelectUserForm.setFilterGroup(uiSelectUserForm.selectedGroupId);
            uiSelectUserForm.setKeyword("");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSelectUserForm);
        }
    }

    public static class AddUserActionListener
    extends EventListener<UIUserSelect> {
        public void execute(Event<UIUserSelect> event) throws Exception {
            UIUserSelect uiForm = (UIUserSelect)((Object)event.getSource());
            String userName = event.getRequestContext().getRequestParameter("objectId");
            uiForm.setSelectedUsers(userName);
            uiForm.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class AddActionListener
    extends EventListener<UIUserSelect> {
        public void execute(Event<UIUserSelect> event) throws Exception {
            UIUserSelect uiForm = (UIUserSelect)((Object)event.getSource());
            uiForm.setSelectedItem();
            Set<String> items = uiForm.uiIterator_.getSelectedItems();
            if (items.size() == 0) {
                uiForm.warning("UIUserSelect.msg.user-required");
                return;
            }
            String result = items.toString().replace("[", "").replace("]", "").replaceAll(" ", "");
            uiForm.setSelectedUsers(result);
            uiForm.getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

