/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MSExcelDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.MSExcelDocumentReader");
    private static final int MAX_CELL = 5000;

    public String[] getMimeTypes() {
        return new String[]{"application/excel", "application/xls", "application/vnd.ms-excel"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        StringBuilder builder = new StringBuilder("");
        try {
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            POIFSFileSystem poifs = new POIFSFileSystem(is);
            DocumentInputStream din = null;
            try {
                din = poifs.createDocumentInputStream("Workbook");
                HSSFRequest req = new HSSFRequest();
                req.addListenerForAllRecords((HSSFListener)new XLSHSSFListener(builder));
                HSSFEventFactory factory = new HSSFEventFactory();
                factory.processEvents(req, (InputStream)din);
            }
            finally {
                block22: {
                    if (din != null) {
                        try {
                            din.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isTraceEnabled()) break block22;
                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                        }
                    }
                }
            }
        }
        finally {
            block23: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block23;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
        return builder.toString();
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        POIPropertiesReader reader = new POIPropertiesReader();
        reader.readDCProperties(is);
        return reader.getProperties();
    }

    class XLSHSSFListener
    extends AbortableHSSFListener {
        private StringBuilder builder;
        public int cellnum = 0;
        private SSTRecord sstrec;

        XLSHSSFListener(StringBuilder builder) {
            this.builder = builder;
        }

        public short abortableProcessRecord(Record record) {
            if (this.cellnum < 5000) {
                switch (record.getSid()) {
                    case 515: {
                        ++this.cellnum;
                        break;
                    }
                    case 513: {
                        break;
                    }
                    case 6: {
                        ++this.cellnum;
                        break;
                    }
                    case 517: {
                        ++this.cellnum;
                        break;
                    }
                    case 252: {
                        this.sstrec = (SSTRecord)record;
                        break;
                    }
                    case 253: {
                        LabelSSTRecord lrec = (LabelSSTRecord)record;
                        UnicodeString lrecValue = this.sstrec.getString(lrec.getSSTIndex());
                        if (lrecValue.getCharCount() > 2) {
                            this.builder.append(lrecValue).append(" ");
                        }
                        ++this.cellnum;
                        break;
                    }
                    case 519: {
                        ++this.cellnum;
                        break;
                    }
                    case 133: {
                        BoundSheetRecord bsr = (BoundSheetRecord)record;
                        this.builder.append(bsr.getSheetname()).append(" ");
                    }
                }
                return 0;
            }
            return -1;
        }
    }
}

