/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.StreamHelper;
import org.apache.poi.openxml4j.opc.internal.ContentTypeManager;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.w3c.dom.Document;

public class ZipContentTypeManager
extends ContentTypeManager {
    private static POILogger logger = POILogFactory.getLogger(ZipContentTypeManager.class);

    public ZipContentTypeManager(InputStream in, OPCPackage pkg) throws InvalidFormatException {
        super(in, pkg);
    }

    public boolean saveImpl(Document content, OutputStream out) {
        ZipOutputStream zos = null;
        zos = out instanceof ZipOutputStream ? (ZipOutputStream)out : new ZipOutputStream(out);
        ZipEntry partEntry = new ZipEntry("[Content_Types].xml");
        try {
            zos.putNextEntry(partEntry);
            if (!StreamHelper.saveXmlInStream(content, zos)) {
                return false;
            }
            zos.closeEntry();
        }
        catch (IOException ioe) {
            logger.log(POILogger.ERROR, (Object)"Cannot write: [Content_Types].xml in Zip !", (Throwable)ioe);
            return false;
        }
        return true;
    }
}

