/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractService {
    private static final Log LOG = ExoLogger.getLogger(AbstractService.class);
    public static final String STG_SCOPE = "stg:scope";
    public static final String STG_CONTEXT = "stg:context";
    public static final String STG_SUBCONTEXT = "stg:subcontext";
    public static final String STG_SIMPLE_CONTEXT = "stg:simplecontext";
    public static final String EXO_IS_ACTIVE = "exo:isActive";
    public static final String EXO_INSTANTLY = "exo:instantly";
    public static final String EXO_DAILY = "exo:daily";
    public static final String EXO_LAST_READ_DATE = "exo:lastReadDate";
    public static final String EXO_WEEKLY = "exo:weekly";
    public static final String NTF_TO = "ntf:to";
    public static final String NTF_FROM = "ntf:from";
    public static final String NTF_TEXT = "ntf:text";
    public static final String NTF_READ = "ntf:read";
    public static final String NTF_ORDER = "ntf:order";
    public static final String NTF_SENDER = "ntf:sender";
    public static final String NTF_OWNER = "ntf:owner";
    public static final String NTF_CHANNEL = "ntf:channel";
    public static final String NTF_MESSAGE = "ntf:message";
    public static final String NTF_PARENT_ID = "ntf:parentId";
    public static final String NTF_PLUGIN_ID = "ntf:pluginId";
    public static final String NTF_NOTIF_USER = "ntf:notifUser";
    public static final String NTF_NOTIF_DATE = "ntf:notifDate";
    public static final String NTF_NOTIF_INFO = "ntf:notifInfo";
    public static final String NTF_SHOW_POPOVER = "ntf:showPopover";
    public static final String NTF_MESSAGE_INFO = "ntf:messageInfo";
    public static final String NTF_SEND_TO_DAILY = "ntf:sendToDaily";
    public static final String NTF_MESSAGE_HOME = "ntf:messageHome";
    public static final String NTF_SEND_TO_WEEKLY = "ntf:sendToWeekly";
    public static final String NTF_NOTIFICATION = "ntf:notification";
    public static final String NTF_PROVIDER_TYPE = "ntf:providerType";
    public static final String NTF_SEND_TO_MONTHLY = "ntf:sendToMonthly";
    public static final String NTF_LAST_MODIFIED_DATE = "ntf:lastModifiedDate";
    public static final String MIX_DEFAULT_SETTING = "mix:defaultSetting";
    public static final String MIX_SUB_MESSAGE_HOME = "mix:subMessageHome";
    public static final String MIX_NEW_NODE = "mix:newNode";
    public static final String NTF_OWNER_PARAMETER = "ntf:ownerParameter";
    public static final String NTF_MESSAGE_INFO_HOME = "ntf:messageInfoHome";
    public static final String EXO_DATE_CREATED = "exo:dateCreated";
    public static final String EXO_LAST_MODIFIED_DATE = "exo:lastModifiedDate";
    public static final String JCR_ROOT = "/jcr:root";
    public static final String ASCENDING = " ASC";
    public static final String DESCENDING = " DESC";
    public static final String WORKSPACE_PARAM = "workspace";
    public static final String DEFAULT_WORKSPACE_NAME = "portal-system";
    public static final String NOTIFICATION_HOME_NODE = "eXoNotification";
    public static final String MESSAGE_HOME_NODE = "messageHome";
    public static final String MESSAGE_INFO_HOME_NODE = "messageInfoHome";
    public static final String WEB_CHANNEL = "web";
    public static final String SETTING_NODE = "settings";
    public static final String SETTING_USER_NODE = "user";
    public static final String SETTING_USER_PATH = "settings/user";
    public static final String NOTIFICATION_PARENT_PATH = "/";
    public static final String VALUE_PATTERN = "{VALUE}";
    public static final String DATE_NODE_PATTERN = "yyyyMMdd";
    public static final String NTF_NAME_SPACE = "ntf:";
    public static final String DAY = "d";

    protected static Node getNotificationHomeNode(SessionProvider sProvider, String workspace) throws Exception {
        Node notificationHome;
        Session session = AbstractService.getSession(sProvider, workspace);
        Node rootNode = session.getRootNode();
        if (rootNode.hasNode(NOTIFICATION_HOME_NODE)) {
            notificationHome = rootNode.getNode(NOTIFICATION_HOME_NODE);
        } else {
            notificationHome = rootNode.addNode(NOTIFICATION_HOME_NODE, NTF_NOTIFICATION);
            session.save();
        }
        return notificationHome;
    }

    protected Node getMessageInfoHomeNode(SessionProvider sProvider, String workspace) throws Exception {
        Node ntfHomeNode = AbstractService.getNotificationHomeNode(sProvider, workspace);
        if (!ntfHomeNode.hasNode(MESSAGE_INFO_HOME_NODE)) {
            Node messageHome = ntfHomeNode.addNode(MESSAGE_INFO_HOME_NODE, NTF_MESSAGE_INFO_HOME);
            AbstractService.sessionSave(ntfHomeNode);
            return messageHome;
        }
        return ntfHomeNode.getNode(MESSAGE_INFO_HOME_NODE);
    }

    protected Node getOrCreateMessageParent(SessionProvider sProvider, String workspace, String pluginId) throws Exception {
        Node providerNode = this.getMessageNodeByPluginId(sProvider, workspace, pluginId);
        String dayName = String.valueOf(Calendar.getInstance().get(5));
        Node dayNode = this.getOrCreateMessageNode(providerNode, DAY + dayName);
        return dayNode;
    }

    protected Node getMessageNodeByPluginId(SessionProvider sProvider, String workspace, String pluginId) throws Exception {
        Node root = AbstractService.getNotificationHomeNode(sProvider, workspace);
        Node messageHome = this.getOrCreateMessageNode(root, MESSAGE_HOME_NODE);
        return this.getOrCreateMessageNode(messageHome, pluginId);
    }

    protected Node getOrCreateMessageNode(Node parent, String nodeName) throws Exception {
        if (!parent.hasNode(nodeName)) {
            Node messageHome = parent.addNode(nodeName, NTF_MESSAGE_HOME);
            messageHome.addMixin(MIX_SUB_MESSAGE_HOME);
            AbstractService.sessionSave(messageHome);
            return messageHome;
        }
        return parent.getNode(nodeName);
    }

    public static Session getSession(SessionProvider sProvider, String workspace) {
        if (workspace == null || workspace.length() == 0) {
            workspace = DEFAULT_WORKSPACE_NAME;
        }
        try {
            return sProvider.getSession(workspace, CommonsUtils.getRepository());
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Failed to get session for workspace " + workspace), (Throwable)e);
            return null;
        }
    }

    public static String getCurrentTenantName() {
        try {
            return CommonsUtils.getRepository().getConfiguration().getName();
        }
        catch (Exception e) {
            return "defaultTenantName";
        }
    }

    protected static void sessionSave(Node node) throws Exception {
        node.getSession().save();
    }

    protected static String getValue(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        return VALUE_PATTERN.replace("VALUE", value);
    }

    protected static String getValues(String values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        return values.replace("{", "").replace("}", "");
    }

    public static NodeIterator getNodeIteratorOrderDESC(Node parentNode) throws RepositoryException {
        SessionImpl session = (SessionImpl)parentNode.getSession();
        NodeData data = (NodeData)((NodeImpl)parentNode).getData();
        SessionDataManager dataManager = session.getTransientNodesManager();
        ArrayList<NodeData> storedNodes = new ArrayList<NodeData>(dataManager.getChildNodesData(data));
        Collections.sort(storedNodes, new NodeDataComparatorDESC());
        return new LazyNodeIterator(session, data, storedNodes);
    }

    private static abstract class LazyItemsIterator
    implements RangeIterator {
        protected Iterator<NodeData> iter;
        protected int size = -1;
        protected NodeImpl next;
        protected int pos = 0;
        private final SessionImpl session;
        private final NodeData parentData;

        LazyItemsIterator(SessionImpl session, NodeData parentData, List<NodeData> items) throws RepositoryException {
            this.iter = items.iterator();
            this.session = session;
            this.parentData = parentData;
            this.fetchNext();
        }

        protected void fetchNext() throws RepositoryException {
            while (this.iter.hasNext()) {
                NodeData item = this.iter.next();
                if (!this.canRead((ItemData)item)) continue;
                this.next = new NodeImpl(item, this.parentData, this.session);
                return;
            }
            this.next = null;
        }

        protected boolean canRead(ItemData item) {
            return this.session.getAccessManager().hasPermission(item.isNode() ? ((NodeData)item).getACL() : this.parentData.getACL(), new String[]{"read"}, this.session.getUserState().getIdentity());
        }

        public ItemImpl nextItem() {
            if (this.next != null) {
                try {
                    NodeImpl i = this.next;
                    this.fetchNext();
                    ++this.pos;
                    this.session.getActionHandler().postRead((ItemImpl)i);
                    return i;
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("An exception occured: " + e.getMessage()));
                    throw new NoSuchElementException(e.toString());
                }
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            return this.nextItem();
        }

        public void skip(long skipNum) {
            this.trySkip(skipNum, true);
        }

        protected long trySkip(long skipNum, boolean throwException) {
            this.pos = (int)((long)this.pos + skipNum);
            while (skipNum-- > 1L) {
                try {
                    this.iter.next();
                }
                catch (NoSuchElementException e) {
                    if (throwException) {
                        throw e;
                    }
                    return skipNum;
                }
            }
            try {
                this.fetchNext();
            }
            catch (RepositoryException e) {
                LOG.error((Object)("An exception occured: " + e.getMessage()));
                throw new NoSuchElementException(e.toString());
            }
            return 0L;
        }

        public long getSize() {
            if (this.size == -1) {
                int sz = this.pos + (this.next != null ? 1 : 0);
                if (this.iter.hasNext()) {
                    ArrayList<NodeData> itemsLeft = new ArrayList<NodeData>();
                    do {
                        NodeData item;
                        if (!this.canRead((ItemData)(item = this.iter.next()))) continue;
                        itemsLeft.add(item);
                        ++sz;
                    } while (this.iter.hasNext());
                    this.iter = itemsLeft.iterator();
                }
                this.size = sz;
            }
            return this.size;
        }

        public long getPosition() {
            return this.pos;
        }

        public void remove() {
            LOG.warn((Object)"Remove not supported");
        }
    }

    private static class LazyNodeIterator
    extends LazyItemsIterator
    implements NodeIterator {
        LazyNodeIterator(SessionImpl session, NodeData parentData, List<NodeData> nodes) throws RepositoryException {
            super(session, parentData, nodes);
        }

        public Node nextNode() {
            return (Node)this.nextItem();
        }
    }

    private static class NodeDataComparatorDESC
    implements Comparator<NodeData> {
        private NodeDataComparatorDESC() {
        }

        @Override
        public int compare(NodeData n1, NodeData n2) {
            return n2.getOrderNumber() - n1.getOrderNumber();
        }
    }
}

