/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.service.QueueMessage;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.notification.impl.service.SendEmailService;
import org.exoplatform.commons.notification.job.SendEmailNotificationJob;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.json.JSONObject;
import org.picocontainer.Startable;
import org.quartz.JobDataMap;

@ManagedBy(value=SendEmailService.class)
public class QueueMessageImpl
extends AbstractService
implements QueueMessage,
Startable {
    private static final Log LOG = ExoLogger.getExoLogger(QueueMessageImpl.class);
    private static final String MAX_TO_SEND_SYS_KEY = "conf.notification.service.QueueMessage.numberOfMailPerBatch";
    private static final String MAX_TO_SEND_KEY = "numberOfMailPerBatch";
    private static final String DELAY_TIME_SYS_KEY = "conf.notification.service.QueueMessage.period";
    private static final String DELAY_TIME_KEY = "period";
    private static final String CACHE_REPO_NAME = "repositoryName";
    private static final int BUFFER_SIZE = 32;
    private static int LIMIT = 20;
    private static long sinceTime = 0L;
    private int MAX_TO_SEND;
    private long DELAY_TIME;
    private SendEmailService sendEmailService;
    private MailService mailService;
    private NotificationConfiguration configuration;
    final transient ReentrantLock lock = new ReentrantLock();
    private Set<MessageInfo> messages = Collections.synchronizedSet(new HashSet());
    private ThreadLocal<Set<String>> idsRemovingLocal = new ThreadLocal();

    public QueueMessageImpl(InitParams params) {
        this.configuration = CommonsUtils.getService(NotificationConfiguration.class);
        this.mailService = CommonsUtils.getService(MailService.class);
        this.MAX_TO_SEND = NotificationUtils.getSystemValue(params, MAX_TO_SEND_SYS_KEY, MAX_TO_SEND_KEY, 20);
        this.DELAY_TIME = NotificationUtils.getSystemValue(params, DELAY_TIME_SYS_KEY, DELAY_TIME_KEY, 120) * 1000;
    }

    public void setManagementView(SendEmailService managementView) {
        this.sendEmailService = managementView;
    }

    public void makeJob(int limit, long interval) {
        if (interval > 0L) {
            LIMIT = limit;
            JobSchedulerService schedulerService = CommonsUtils.getService(JobSchedulerService.class);
            GregorianCalendar cal = new GregorianCalendar();
            try {
                PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, -1, interval);
                JobInfo info = new JobInfo("SendEmailNotificationJob", "Notification", SendEmailNotificationJob.class);
                info.setDescription("Send email notification job.");
                schedulerService.removeJob(info);
                JobDataMap jdatamap = new JobDataMap();
                jdatamap.put(CACHE_REPO_NAME, CommonsUtils.getRepository().getConfiguration().getName());
                schedulerService.addPeriodJob(info, periodInfo, jdatamap);
                LOG.debug((Object)("Job executes interval: " + interval));
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed at makeJob().");
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void resetDefaultConfigJob() {
        this.makeJob(this.MAX_TO_SEND, this.DELAY_TIME);
    }

    public void start() {
        this.resetDefaultConfigJob();
        this.sendEmailService.registerManager(this);
    }

    public void stop() {
    }

    public boolean put(MessageInfo message) {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        if (message == null || message.getTo() == null || message.getTo().length() == 0) {
            return false;
        }
        if (!NotificationUtils.isValidEmailAddresses(message.getTo())) {
            LOG.warn((Object)String.format("The email %s is not valid for sending notification", message.getTo()));
            return false;
        }
        if (stats) {
            LOG.info((Object)("Tenant Name:: " + CommonsUtils.getRepository().getConfiguration().getName()));
            LOG.info((Object)("Message::From: " + message.getFrom() + " To: " + message.getTo() + " body: " + message.getBody()));
        }
        this.saveMessageInfo(message);
        this.sendEmailService.addCurrentCapacity();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            this.load(sProvider);
            if (this.idsRemovingLocal.get() == null) {
                this.idsRemovingLocal.set(new HashSet());
            }
            if (this.messages.size() > 0) {
                LOG.info((Object)(this.messages.size() + " message(s) will be sent."));
            }
            for (MessageInfo messageInfo : this.messages) {
                if (messageInfo == null || this.idsRemovingLocal.get().contains(messageInfo.getId()) || !this.sendMessage(messageInfo.makeEmailNotification())) continue;
                LOG.debug((Object)("Message sent to user: " + messageInfo.getTo()));
                this.idsRemovingLocal.get().add(messageInfo.getId());
                if (!stats) continue;
                NotificationContextFactory.getInstance().getStatisticsCollector().pollQueue(messageInfo.getPluginId());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to send message.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            sProvider.close();
            this.removeMessageInfo();
        }
    }

    private void load(SessionProvider sProvider) {
        try {
            NodeIterator iterator = this.getMessageInfoNodes(sProvider);
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                long createdTime = Long.parseLong(node.getName());
                if (sinceTime == 0L || sinceTime < createdTime) {
                    MessageInfo messageInfo = this.getMessageInfo(node);
                    messageInfo.setId(node.getUUID());
                    this.messages.add(messageInfo);
                    sinceTime = createdTime;
                    continue;
                }
                sinceTime = 0L;
                this.messages.clear();
                break;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to load message.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMessageInfo(MessageInfo message) {
        ReentrantLock lock = this.lock;
        lock.lock();
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        try {
            message.setCreatedTime(System.currentTimeMillis());
            Node messageInfoHome = this.getMessageInfoHomeNode(sProvider, this.configuration.getWorkspace());
            Node messageInfoNode = messageInfoHome.addNode(String.valueOf(message.getCreatedTime()), "ntf:messageInfo");
            if (messageInfoNode.canAddMixin("mix:referenceable")) {
                messageInfoNode.addMixin("mix:referenceable");
            }
            this.saveData(messageInfoNode, QueueMessageImpl.compress(message.toJSON()));
            QueueMessageImpl.sessionSave(messageInfoHome);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to save message.");
            LOG.debug((Object)(e.getMessage() + message.toJSON()), (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessageInfo() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ReentrantLock lock = this.lock;
        ArrayList ids = new ArrayList(this.idsRemovingLocal.get());
        try {
            lock.lock();
            Session session = QueueMessageImpl.getSession(sProvider, this.configuration.getWorkspace());
            for (String messageId : ids) {
                session.getNodeByUUID(messageId).remove();
                this.sendEmailService.removeCurrentCapacity();
                LOG.debug((Object)("Removing messageId: " + messageId));
            }
            session.save();
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to remove message.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.messages.clear();
            this.idsRemovingLocal.get().removeAll(ids);
            lock.unlock();
            sProvider.close();
        }
    }

    private NodeIterator getMessageInfoNodes(SessionProvider sProvider) {
        try {
            Node messageInfoHome = this.getMessageInfoHomeNode(sProvider, this.configuration.getWorkspace());
            QueryManager qm = messageInfoHome.getSession().getWorkspace().getQueryManager();
            StringBuilder sqlQuery = new StringBuilder();
            sqlQuery.append("SELECT * FROM ").append("ntf:messageInfo").append(" WHERE jcr:path LIKE '").append(messageInfoHome.getPath()).append("/%' AND NOT jcr:path LIKE '").append(messageInfoHome.getPath()).append("/%/%'").append(" ORDER BY exo:name");
            QueryImpl query = (QueryImpl)qm.createQuery(sqlQuery.toString(), "sql");
            query.setOffset(0L);
            query.setLimit((long)LIMIT);
            QueryResult result = query.execute();
            return result.getNodes();
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get message from node.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private MessageInfo getMessageInfo(Node messageInfoNode) {
        try {
            String messageJson = this.getDataJson(messageInfoNode);
            JSONObject object = new JSONObject(messageJson);
            MessageInfo info = new MessageInfo();
            info.pluginId(object.optString("pluginId")).from(object.getString("from")).to(object.getString("to")).subject(object.getString("subject")).body(object.getString("body")).footer(object.optString("footer")).setCreatedTime(object.getLong("createdTime"));
            return info;
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to map message between node and model.");
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean sendMessage(Message message) {
        if (!this.sendEmailService.isOn()) {
            try {
                if (message.getFrom() == null) {
                    return false;
                }
                this.mailService.sendMessage(message);
                return true;
            }
            catch (Exception e) {
                LOG.error((Object)("Error while sending a message - Cause : " + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        this.sendEmailService.counter();
        return true;
    }

    private void saveData(Node node, InputStream is) throws Exception {
        Node fileNode = node.addNode("datajson", "nt:file");
        Node nodeContent = fileNode.addNode("jcr:content", "nt:resource");
        nodeContent.setProperty("jcr:mimeType", "application/x-gzip");
        nodeContent.setProperty("jcr:data", is);
        nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
    }

    private String getDataJson(Node node) throws Exception {
        Node fileNode = node.getNode("datajson");
        Node nodeContent = fileNode.getNode("jcr:content");
        InputStream stream = nodeContent.getProperty("jcr:data").getStream();
        return QueueMessageImpl.decompress(stream);
    }

    private static InputStream compress(String string) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gos = new GZIPOutputStream(os);
        gos.write(string.getBytes());
        gos.close();
        byte[] compressed = os.toByteArray();
        os.close();
        return new ByteArrayInputStream(compressed);
    }

    private static String decompress(InputStream is) throws IOException {
        int bytesRead;
        GZIPInputStream gis = new GZIPInputStream(is, 32);
        StringBuilder string = new StringBuilder();
        byte[] data = new byte[32];
        while ((bytesRead = gis.read(data)) != -1) {
            string.append(new String(data, 0, bytesRead));
        }
        gis.close();
        is.close();
        return string.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeAll() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        int t = 0;
        int j = 0;
        String pli = "";
        try {
            NodeIterator it;
            Session session = QueueMessageImpl.getSession(sProvider, this.configuration.getWorkspace());
            Node root = session.getRootNode();
            LOG.trace((Object)"Removing messages: ");
            if (root.hasNode("eXoNotification/messageInfoHome")) {
                it = root.getNode("eXoNotification/messageInfoHome").getNodes();
                this.removeNodes(session, it);
            }
            LOG.trace((Object)"Done to removed messages! ");
            LOG.trace((Object)"Removing notification info... ");
            it = root.getNode("eXoNotification/messageHome").getNodes();
            ArrayList<String> pluginPaths = new ArrayList<String>();
            while (it.hasNext()) {
                pluginPaths.add(it.nextNode().getPath());
            }
            session.logout();
            Iterator i$ = pluginPaths.iterator();
            while (i$.hasNext()) {
                String string;
                pli = string = (String)i$.next();
                LOG.trace((Object)("Remove notification info on plugin: " + pli));
                session = QueueMessageImpl.getSession(sProvider, this.configuration.getWorkspace());
                it = ((Node)session.getItem(string)).getNodes();
                while (it.hasNext()) {
                    NodeIterator hIter = it.nextNode().getNodes();
                    j = this.removeNodes(session, hIter);
                    t += j;
                }
                LOG.trace((Object)("Removed " + j + " nodes info on plugin: " + pli));
                session.logout();
            }
            String string = "Done to removed " + t + " nodes!";
            return string;
        }
        catch (Exception e) {
            LOG.trace((Object)("Removed " + j + " nodes info on plugin: " + pli));
            LOG.trace((Object)("Removed all " + t + " nodes."));
            LOG.debug((Object)("Failed to remove all data of feature notification." + e.getMessage()));
        }
        finally {
            sProvider.close();
        }
        return "Failed to remove all. Please, try again !";
    }

    private int removeNodes(Session session, NodeIterator it) throws Exception {
        int i = 0;
        int size = Integer.valueOf(System.getProperty("sizePersiter", "200"));
        LOG.trace((Object)"Starting to remove nodes...");
        while (it.hasNext()) {
            it.nextNode().remove();
            if (++i % size != 0) continue;
            session.save();
        }
        session.save();
        LOG.trace((Object)String.format("Done to removed %s nodes", i));
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeUsersSetting() {
        int t = 0;
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Session session = QueueMessageImpl.getSession(sProvider, this.configuration.getWorkspace());
            Node root = session.getRootNode();
            LOG.trace((Object)"Removing all user settings: ");
            if (root.hasNode("settings/user")) {
                NodeIterator it = root.getNode("settings/user").getNodes();
                t = this.removeNodes(session, it);
            }
            String string = "Done to removed " + t + " users!";
            return string;
        }
        return "Failed to remove all. Please, try again !";
    }
}

