/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.connector.BaseSearchServiceConnector;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public abstract class BaseContentSearchServiceConnector
extends BaseSearchServiceConnector {
    public static List<String> excluded_nodetypes = new ArrayList<String>();

    public BaseContentSearchServiceConnector(InitParams initParams) throws Exception {
        super(initParams);
    }

    @Override
    protected QueryCriteria createQueryCriteria(String query, long offset, long limit, String sort, String order) {
        QueryCriteria criteria = new QueryCriteria();
        criteria.setContentTypes(this.getSearchedDocTypes());
        criteria.setNodeTypes(this.getNodeTypes());
        criteria.setKeyword(query.toLowerCase());
        criteria.setSearchWebpage(false);
        criteria.setSearchDocument(true);
        criteria.setSearchWebContent(true);
        if (query.contains("~")) {
            criteria.setFuzzySearch(true);
        }
        criteria.setLiveMode(true);
        criteria.setOffset(offset);
        criteria.setLimit(limit);
        criteria.setSortBy(sort);
        criteria.setOrderBy(order);
        if (ConversationState.getCurrent().getIdentity().getUserId() != null) {
            criteria.setSearchPath("");
        }
        return criteria;
    }

    @Override
    protected AbstractPageList<ResultNode> searchNodes(QueryCriteria criteria) throws Exception {
        return this.siteSearch_.searchSiteContents(WCMCoreUtils.getUserSessionProvider(), criteria, (int)criteria.getLimit(), true);
    }

    @Override
    protected String getFileType(ResultNode node) throws Exception {
        return Utils.getNodeTypeIcon((Node)node, (String)"").replace(".", "").replace("/", "").replace("\\", "").replace(".", "");
    }

    protected abstract String[] getSearchedDocTypes();

    protected abstract String[] getNodeTypes();

    @Override
    protected String getTitleResult(ResultNode node) throws Exception {
        return node.getTitle();
    }

    @Override
    protected String getImageUrl(Node node) {
        return "/eXoSkin/skin/images/themes/default/Icons/TypeIcons/uiIconsType64x64.png";
    }

    @Override
    protected String getDetails(ResultNode retNode, SearchContext context) throws Exception {
        DriveData driveData = this.getDriveData(retNode);
        Calendar date = this.getDate(retNode);
        return this.getDriveTitle(driveData) + this.fileSize(retNode) + this.formatDate(date);
    }
}

