/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.chromattic.utils;

import java.util.Iterator;
import org.exoplatform.social.core.chromattic.entity.ActivityDayEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityListEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityMonthEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityYearEntity;
import org.exoplatform.social.core.chromattic.entity.IndexNumber;
import org.exoplatform.social.core.chromattic.entity.NamedEntity;

public class ActivityIterator
implements Iterator<ActivityEntity> {
    private final ActivityListEntity listEntity;
    private Iterator<ActivityYearEntity> yearIterator;
    private Iterator<ActivityMonthEntity> monthIterator;
    private Iterator<ActivityDayEntity> dayIterator;
    private Iterator<ActivityEntity> entityIterator;

    ActivityIterator(ActivityListEntity listEntity) {
        this.listEntity = listEntity;
        this.yearIterator = listEntity.getYears().values().iterator();
        if (this.yearIterator.hasNext()) {
            this.monthIterator = this.yearIterator.next().getMonths().values().iterator();
            if (this.monthIterator.hasNext()) {
                this.dayIterator = this.monthIterator.next().getDays().values().iterator();
                if (this.dayIterator.hasNext()) {
                    this.entityIterator = this.dayIterator.next().getActivities().iterator();
                }
            }
        }
    }

    @Override
    public boolean hasNext() {
        boolean nothing = true;
        if (this.entityIterator != null && this.entityIterator.hasNext()) {
            return true;
        }
        if (this.dayIterator != null && this.dayIterator.hasNext()) {
            this.entityIterator = this.dayIterator.next().getActivities().iterator();
            nothing = false;
            if (this.entityIterator.hasNext()) {
                return true;
            }
        } else if (this.monthIterator != null && this.monthIterator.hasNext()) {
            this.dayIterator = this.monthIterator.next().getDays().values().iterator();
            nothing = false;
            if (this.dayIterator.hasNext()) {
                this.entityIterator = this.dayIterator.next().getActivities().iterator();
                if (this.entityIterator.hasNext()) {
                    return true;
                }
            }
        } else if (this.yearIterator != null && this.yearIterator.hasNext()) {
            this.monthIterator = this.yearIterator.next().getMonths().values().iterator();
            nothing = false;
            if (this.monthIterator.hasNext()) {
                this.dayIterator = this.monthIterator.next().getDays().values().iterator();
                if (this.dayIterator.hasNext()) {
                    this.entityIterator = this.dayIterator.next().getActivities().iterator();
                    if (this.entityIterator.hasNext()) {
                        return true;
                    }
                }
            }
        }
        if (nothing) {
            return false;
        }
        return this.hasNext();
    }

    public int moveTo(ActivityEntity activity) {
        ActivityDayEntity day = activity.getDay();
        ActivityMonthEntity month = day.getMonth();
        ActivityYearEntity year = month.getYear();
        int nb = 0;
        nb += this.moveIterator(this.yearIterator, year.getName());
        nb += this.moveIterator(this.monthIterator, month.getName());
        nb += this.moveIterator(this.dayIterator, day.getName());
        return nb += this.moveIterator(this.entityIterator, activity.getName());
    }

    @Override
    public ActivityEntity next() {
        if (this.hasNext()) {
            return this.entityIterator.next();
        }
        throw new RuntimeException();
    }

    @Override
    public void remove() {
        throw new RuntimeException();
    }

    private int moveIterator(Iterator<? extends NamedEntity> it, String name) {
        int nb = 0;
        while (it.hasNext()) {
            NamedEntity got = it.next();
            if (got.getName().equals(name)) {
                return nb;
            }
            if (got instanceof IndexNumber) {
                nb += ((IndexNumber)((Object)got)).getNumber().intValue();
                continue;
            }
            ++nb;
        }
        return nb;
    }
}

