/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.Map;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class TemplateParamsProcessor
extends BaseActivityProcessorPlugin {
    private static final Log LOG = ExoLogger.getLogger(TemplateParamsProcessor.class);

    public TemplateParamsProcessor(InitParams params) {
        super(params);
    }

    @Override
    public void processActivity(ExoSocialActivity activity) {
        try {
            Map params = activity.getTemplateParams();
            activity.setTitle(this.processTemplate(activity.getTitle(), params));
            activity.setBody(this.processTemplate(activity.getBody(), params));
        }
        catch (Exception e) {
            LOG.error((Object)"TemplateParamsProcessor error : ", (Throwable)e);
        }
    }

    private String processTemplate(String template, Map<String, String> params) throws Exception {
        int open;
        if (template == null) {
            return template;
        }
        int start = 0;
        while ((open = template.indexOf("${", start)) != -1) {
            int close;
            start = close = template.indexOf("}");
            if (close == -1) {
                throw new Exception("Template is invalid. [Do not contain '}']");
            }
            String key = template.substring(open + 2, close);
            String value = params.get(key);
            String templateKey = "${" + key + "}";
            template = template.replace(templateKey, value);
        }
        return template;
    }
}

