/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.render.CajaResponseRewriter;
import org.apache.shindig.gadgets.render.OpenSocialI18NGadgetRewriter;
import org.apache.shindig.gadgets.render.RenderingGadgetRewriter;
import org.apache.shindig.gadgets.render.SanitizingGadgetRewriter;
import org.apache.shindig.gadgets.render.SanitizingResponseRewriter;
import org.apache.shindig.gadgets.rewrite.AbsolutePathReferenceRewriter;
import org.apache.shindig.gadgets.rewrite.AccelResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.CssResponseRewriter;
import org.apache.shindig.gadgets.rewrite.DefaultResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.PipelineDataGadgetRewriter;
import org.apache.shindig.gadgets.rewrite.ProxyingContentRewriter;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.StyleAdjacencyContentRewriter;
import org.apache.shindig.gadgets.rewrite.StyleTagExtractorContentRewriter;
import org.apache.shindig.gadgets.rewrite.StyleTagProxyEmbeddedUrlsRewriter;
import org.apache.shindig.gadgets.rewrite.TemplateRewriter;
import org.apache.shindig.gadgets.rewrite.image.BasicImageRewriter;
import org.apache.shindig.gadgets.servlet.CajaContentRewriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewriteModule
extends AbstractModule {
    protected void configure() {
        this.bind(ResponseRewriterRegistry.class).annotatedWith((Annotation)Names.named((String)"shindig.accelerate.response.rewriter.registry")).to(AccelResponseRewriterRegistry.class);
    }

    @Provides
    @Singleton
    @Named(value="shindig.rewriters.gadget")
    protected List<GadgetRewriter> provideGadgetRewriters(PipelineDataGadgetRewriter pipelineRewriter, TemplateRewriter templateRewriter, AbsolutePathReferenceRewriter absolutePathRewriter, StyleTagExtractorContentRewriter styleTagExtractorRewriter, StyleAdjacencyContentRewriter styleAdjacencyRewriter, ProxyingContentRewriter proxyingRewriter, CajaContentRewriter cajaRewriter, SanitizingGadgetRewriter sanitizedRewriter, RenderingGadgetRewriter renderingRewriter, OpenSocialI18NGadgetRewriter i18nRewriter) {
        return ImmutableList.of((Object)pipelineRewriter, (Object)templateRewriter, (Object)absolutePathRewriter, (Object)styleTagExtractorRewriter, (Object)styleAdjacencyRewriter, (Object)proxyingRewriter, (Object)cajaRewriter, (Object)sanitizedRewriter, (Object)renderingRewriter, (Object)i18nRewriter);
    }

    @Provides
    @Singleton
    @Named(value="shindig.rewriters.accelerate")
    protected List<GadgetRewriter> provideAccelRewriters(ProxyingContentRewriter proxyingContentRewriter, CajaContentRewriter cajaRewriter) {
        return ImmutableList.of((Object)proxyingContentRewriter, (Object)cajaRewriter);
    }

    @Provides
    @Singleton
    @Named(value="shindig.rewriters.response.pre-cache")
    protected ResponseRewriterRegistry providePreCacheResponseRewritersRegistry(GadgetHtmlParser parser, @Named(value="shindig.rewriters.response.pre-cache") List<ResponseRewriter> preCached) {
        return new DefaultResponseRewriterRegistry(preCached, parser);
    }

    @Provides
    @Singleton
    @Named(value="shindig.rewriters.response.pre-cache")
    protected List<ResponseRewriter> providePreCacheResponseRewriters(BasicImageRewriter imageRewriter) {
        return ImmutableList.of((Object)imageRewriter);
    }

    @Provides
    @Singleton
    protected List<ResponseRewriter> provideResponseRewriters(AbsolutePathReferenceRewriter absolutePathRewriter, StyleTagExtractorContentRewriter styleTagExtractorRewriter, StyleAdjacencyContentRewriter styleAdjacencyRewriter, ProxyingContentRewriter proxyingRewriter, CssResponseRewriter cssRewriter, SanitizingResponseRewriter sanitizedRewriter, CajaResponseRewriter cajaRewriter) {
        return ImmutableList.of((Object)absolutePathRewriter, (Object)styleTagExtractorRewriter, (Object)styleAdjacencyRewriter, (Object)proxyingRewriter, (Object)cssRewriter, (Object)sanitizedRewriter, (Object)cajaRewriter);
    }

    @Provides
    @Singleton
    @Named(value="shindig.accelerate.response.rewriters")
    protected List<ResponseRewriter> provideAccelResponseRewriters(AbsolutePathReferenceRewriter absolutePathReferenceRewriter, StyleTagProxyEmbeddedUrlsRewriter styleTagProxyEmbeddedUrlsRewriter, ProxyingContentRewriter proxyingContentRewriter) {
        return ImmutableList.of((Object)absolutePathReferenceRewriter, (Object)styleTagProxyEmbeddedUrlsRewriter, (Object)proxyingContentRewriter);
    }
}

