/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.control.action;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.webui.UIWikiPageEditForm;
import org.exoplatform.wiki.webui.UIWikiPageTitleControlArea;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiRichTextArea;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.action.core.AbstractEventActionComponent;
import org.exoplatform.wiki.webui.control.filter.EditPagesPermissionFilter;
import org.exoplatform.wiki.webui.control.filter.IsViewModeFilter;
import org.exoplatform.wiki.webui.control.listener.AddContainerActionListener;

@ComponentConfig(template="app:/templates/wiki/webui/control/action/AbstractActionComponent.gtmpl", events={@EventConfig(listeners={AddPageActionListener.class})})
public class AddPageActionComponent
extends AbstractEventActionComponent {
    public static final String ACTION = "AddPage";
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsViewModeFilter(), new EditPagesPermissionFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    @Override
    public String getActionName() {
        return ACTION;
    }

    @Override
    public boolean isAnchor() {
        return true;
    }

    public static class AddPageActionListener
    extends AddContainerActionListener<AddPageActionComponent> {
        @Override
        protected void processEvent(Event<AddPageActionComponent> event) throws Exception {
            WikiService wservice = (WikiService)PortalContainer.getComponent(WikiService.class);
            HttpSession session = Util.getPortalRequestContext().getRequest().getSession(false);
            String draftId = (String)session.getAttribute(Utils.getDraftIdSessionKey());
            if (draftId == null) {
                wservice.removeDraft(org.exoplatform.wiki.utils.Utils.getPageNameForAddingPage());
            }
            DraftPage draftPage = draftId == null ? null : wservice.getDraft(draftId);
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((AddPageActionComponent)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            wikiPortlet.changeMode(WikiMode.ADDPAGE);
            WikiPageParams pageParams = Utils.getCurrentWikiPageParams();
            String pageTitle = draftPage == null ? pageParams.getParameter("pageTitle") : draftPage.getTitle();
            UIWikiPageEditForm pageEditForm = (UIWikiPageEditForm)wikiPortlet.findFirstComponentOfType(UIWikiPageEditForm.class);
            UIFormStringInput titleInput = ((UIWikiPageTitleControlArea)pageEditForm.getChild(UIWikiPageTitleControlArea.class)).getUIStringInput();
            UIFormTextAreaInput markupInput = (UIFormTextAreaInput)pageEditForm.findComponentById("Markup");
            UIFormStringInput commentInput = (UIFormStringInput)pageEditForm.findComponentById("Comment");
            titleInput.setValue((Object)"");
            titleInput.setEditable(true);
            markupInput.setValue((Object)(draftPage == null ? "" : draftPage.getContent().getText()));
            commentInput.setRendered(false);
            if (pageTitle != null && pageTitle.length() > 0) {
                titleInput.setValue((Object)pageTitle);
                titleInput.setEditable(false);
            }
            pageEditForm.setInitDraftName(draftPage == null ? "" : draftPage.getName());
            UIWikiRichTextArea wikiRichTextArea = (UIWikiRichTextArea)pageEditForm.getChild(UIWikiRichTextArea.class);
            if (wikiRichTextArea.isRendered()) {
                Utils.feedDataForWYSIWYGEditor(pageEditForm, null);
            }
            session.setAttribute(Utils.getDraftIdSessionKey(), null);
            super.processEvent(event);
        }
    }
}

