/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.xml.object;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.xml.object.XMLField;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class XMLObject
implements IUnmarshallable,
IMarshallable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.XMLObject");
    public static String CURRENT_VERSION = "1.0";
    static Map cacheFields_ = new HashMap();
    private Map fields_ = new HashMap();
    private String type;
    public static final String JiBX_bindingList = "|org.exoplatform.container.xml.JiBX_bindingFactory|";

    public XMLObject() {
    }

    public XMLObject(Object obj) throws Exception {
        Class<?> clazz = obj.getClass();
        Map fields = XMLObject.getFields(clazz);
        this.setType(obj.getClass().getName());
        for (Field field : fields.values()) {
            Object value = field.get(obj);
            if (value == null || !value.getClass().isPrimitive() && Configuration.hasComponent(field.getType().getName())) continue;
            this.addField(new XMLField(field.getName(), field.getType(), value));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String s) {
        this.type = s;
    }

    public XMLField getField(String name) {
        return (XMLField)this.fields_.get(name);
    }

    public void addField(Object o) {
        XMLField field = (XMLField)o;
        this.fields_.put(field.getName(), field);
    }

    public void addField(XMLField field) {
        this.fields_.put(field.getName(), field);
    }

    public Iterator getFieldIterator() {
        return this.fields_.values().iterator();
    }

    public Collection getFields() {
        return this.fields_.values();
    }

    public void setFields(Collection fields) {
        for (XMLField field : fields) {
            this.fields_.put(field.getName(), field);
        }
    }

    public void setFields(Map fields) {
        this.fields_.putAll(fields);
    }

    public Object getFieldValue(String fieldName) throws Exception {
        XMLField field = (XMLField)this.fields_.get(fieldName);
        if (field != null) {
            return field.getObjectValue();
        }
        return null;
    }

    public void renameField(String oldName, String newName) {
        XMLField field = (XMLField)this.fields_.remove(oldName);
        field.setName(newName);
        this.fields_.put(newName, field);
    }

    public void removeField(String name) {
        this.fields_.remove(name);
    }

    public void addField(String name, Class fieldType, Object obj) throws Exception {
        this.addField(new XMLField(name, fieldType, obj));
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("type: ").append(this.type).append("\n");
        for (XMLField field : this.fields_.values()) {
            b.append(field.toString()).append("\n");
        }
        return b.toString();
    }

    public Object toObject() throws Exception {
        Class clazz = ClassLoading.forName((String)this.type, (Object)this);
        Map fields = XMLObject.getFields(clazz);
        Object instance = clazz.newInstance();
        for (XMLField xmlfield : this.fields_.values()) {
            try {
                Object value = xmlfield.getObjectValue();
                Field field = (Field)fields.get(xmlfield.getName());
                field.set(instance, value);
            }
            catch (Exception ex) {
                LOG.error((Object)("ERROR: Cannot set  field: " + xmlfield.getName() + " of " + this.type), (Throwable)ex);
                throw ex;
            }
        }
        return instance;
    }

    public String toXML() throws Exception {
        return this.toXML("UTF-8");
    }

    public String toXML(String encoding) throws Exception {
        return new String(this.toByteArray(encoding), encoding);
    }

    public byte[] toByteArray() throws Exception {
        return this.toByteArray("UTF-8");
    }

    public byte[] toByteArray(String encoding) throws Exception {
        IBindingFactory bfact = XMLObject.getBindingFactoryInPriviledgedMode(XMLObject.class);
        IMarshallingContext mctx = bfact.createMarshallingContext();
        mctx.setIndent(2);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        mctx.marshalDocument((Object)this, encoding, null, (OutputStream)os);
        return os.toByteArray();
    }

    public static XMLObject getXMLObject(InputStream is) throws Exception {
        IBindingFactory bfact = XMLObject.getBindingFactoryInPriviledgedMode(XMLObject.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        XMLObject xmlobject = (XMLObject)uctx.unmarshalDocument(is, "UTF-8");
        return xmlobject;
    }

    public static Object getObject(InputStream is) throws Exception {
        return XMLObject.getXMLObject(is).toObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getFields(Class clazz) {
        HashMap fields = (HashMap)cacheFields_.get(clazz);
        if (fields != null) {
            return fields;
        }
        Map map = cacheFields_;
        synchronized (map) {
            fields = new HashMap();
            XMLObject.findFields(fields, clazz);
            cacheFields_.put(clazz, fields);
        }
        return fields;
    }

    static void findFields(Map fields, Class clazz) {
        if (clazz.getName().startsWith("java.lang")) {
            return;
        }
        XMLObject.findFields(fields, clazz.getSuperclass());
        Field[] field = clazz.getDeclaredFields();
        for (int i = 0; i < field.length; ++i) {
            int modifier = field[i].getModifiers();
            if (Modifier.isStatic(modifier) || Modifier.isTransient(modifier)) continue;
            final Field fld = field[i];
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    fld.setAccessible(true);
                    return null;
                }
            });
            fields.put(field[i].getName(), field[i]);
        }
    }

    protected static IBindingFactory getBindingFactoryInPriviledgedMode(final Class clazz) throws JiBXException {
        try {
            return (IBindingFactory)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<IBindingFactory>(){

                @Override
                public IBindingFactory run() throws Exception {
                    return BindingDirectory.getFactory((Class)clazz);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof JiBXException) {
                throw (JiBXException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public static /* synthetic */ XMLObject JiBX_binding_newinstance_1_0(XMLObject arg1, UnmarshallingContext arg2) throws JiBXException {
        if (arg1 == null) {
            arg1 = new XMLObject();
        }
        return arg1;
    }

    public static /* synthetic */ XMLObject JiBX_binding_unmarshalAttr_1_0(XMLObject arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushTrackedObject((Object)arg1);
        XMLObject xMLObject = arg1;
        String string = arg2.attributeText(null, "type");
        arg1.type = string == null ? null : Deserializer.resolveString(string);
        arg2.popObject();
        return arg1;
    }

    public static /* synthetic */ XMLObject JiBX_binding_unmarshal_1_0(XMLObject arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        XMLObject xMLObject = arg1;
        while (arg2.isEnd() ^ true) {
            arg1.addField(arg2.unmarshalElement());
        }
        arg2.popObject();
        return arg1;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.xml.object.XMLObject").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.xml.object.XMLObject";
    }

    public static /* synthetic */ void JiBX_binding_marshalAttr_1_0(XMLObject arg1, MarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        MarshallingContext marshallingContext = arg2.attribute(0, "type", arg1.type);
        arg2.popObject();
    }

    public static /* synthetic */ void JiBX_binding_marshal_1_0(XMLObject arg1, MarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        MarshallingContext marshallingContext = arg2;
        Iterator var0 = arg1.getFieldIterator();
        while (var0.hasNext()) {
            ((IMarshallable)var0.next()).marshal((IMarshallingContext)arg2);
        }
        arg2.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.xml.object.XMLObject").marshal((Object)this, arg1);
    }
}

