/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;

public abstract class UIComponentFactory<T extends UIComponent> {
    public static String DEFAULT_FACTORY_ID = "";
    protected static Map<Class<?>, List<UIComponentFactory<?>>> componentFactory = new HashMap();

    public static <T extends UIComponent> UIComponentFactory<? extends T> getInstance(Class<T> type) {
        if (type == null) {
            throw new NullPointerException(type + " is null");
        }
        final LinkedList list = new LinkedList();
        for (Class<?> t : componentFactory.keySet()) {
            if (!type.isAssignableFrom(t)) continue;
            for (UIComponentFactory<?> factory : componentFactory.get(t)) {
                list.add(factory);
            }
        }
        return new UIComponentFactory<T>(){

            @Override
            public T createUIComponent(String factoryID, WebuiRequestContext context) {
                UIComponentFactory f;
                Object uiComponent = null;
                Iterator i$ = list.iterator();
                while (i$.hasNext() && (uiComponent = (Object)(f = (UIComponentFactory)i$.next()).createUIComponent(factoryID, context)) == null) {
                }
                return uiComponent;
            }
        };
    }

    protected T create(Class<? extends T> type, WebuiRequestContext context) {
        try {
            if (context == null) {
                return (T)((UIComponent)type.newInstance());
            }
            WebuiApplication app = (WebuiApplication)context.getApplication();
            return (T)app.createUIComponent(type, null, null, context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T createUIComponent(String factoryID) {
        return this.createUIComponent(factoryID, (WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
    }

    public abstract T createUIComponent(String var1, WebuiRequestContext var2);

    static {
        ServiceLoader<UIComponentFactory> loader = ServiceLoader.load(UIComponentFactory.class);
        for (UIComponentFactory factory : loader) {
            List<UIComponentFactory<?>> factories;
            Type genericSuper = factory.getClass().getGenericSuperclass();
            Class supportedType = UIComponent.class;
            if (genericSuper instanceof ParameterizedType) {
                supportedType = (Class)((ParameterizedType)genericSuper).getActualTypeArguments()[0];
            }
            if ((factories = componentFactory.get(supportedType)) == null) {
                factories = new LinkedList();
                componentFactory.put(supportedType, factories);
            }
            factories.add(factory);
        }
    }
}

