/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.exoplatform.services.jcr.impl.core.query.lucene.ComparableBoolean;
import org.exoplatform.services.jcr.impl.core.query.lucene.DateField;
import org.exoplatform.services.jcr.impl.core.query.lucene.DoubleField;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.LongField;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedFieldCache {
    public static final SharedFieldCache INSTANCE = new SharedFieldCache();
    private final Map<IndexReader, Map<Key, ValueIndex>> cache = new WeakHashMap<IndexReader, Map<Key, ValueIndex>>();

    private SharedFieldCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueIndex getValueIndex(IndexReader reader, String field, String prefix) throws IOException {
        ValueIndex ret;
        if (reader instanceof ReadOnlyIndexReader) {
            reader = ((ReadOnlyIndexReader)reader).getBase();
        }
        if ((ret = this.lookup((IndexReader)reader, field = field.intern(), prefix)) == null) {
            Comparable[] retArray = new Comparable[reader.maxDoc()];
            int setValues = 0;
            if (retArray.length > 0) {
                TermPositions termDocs;
                IndexFormatVersion version = IndexFormatVersion.getVersion(reader);
                boolean hasPayloads = version.isAtLeast(IndexFormatVersion.V3);
                byte[] payload = null;
                if (hasPayloads) {
                    termDocs = reader.termPositions();
                    payload = new byte[1];
                } else {
                    termDocs = reader.termDocs();
                }
                TermEnum termEnum = reader.terms(new Term(field, prefix));
                int prefixLength = prefix.length();
                try {
                    String text;
                    Term term;
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + field);
                    }
                    while ((term = termEnum.term()).field() == field && (text = term.text()).startsWith(prefix)) {
                        String value = text.substring(prefixLength);
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            int type = 0;
                            if (hasPayloads) {
                                TermPositions termPos = termDocs;
                                termPos.nextPosition();
                                if (termPos.isPayloadAvailable()) {
                                    payload = termPos.getPayload(payload, 0);
                                    type = payload[0];
                                }
                            }
                            ++setValues;
                            retArray[termDocs.doc()] = this.getValue(value, type);
                        }
                        if (termEnum.next()) continue;
                        break;
                    }
                    Object var19_18 = null;
                }
                catch (Throwable throwable) {
                    Object var19_19 = null;
                    termDocs.close();
                    termEnum.close();
                    throw throwable;
                }
                termDocs.close();
                termEnum.close();
                {
                }
            }
            ValueIndex value = new ValueIndex(retArray, setValues);
            this.store((IndexReader)reader, field, prefix, value);
            return value;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueIndex lookup(IndexReader reader, String field, String prefix) {
        Map<IndexReader, Map<Key, ValueIndex>> map = this.cache;
        synchronized (map) {
            Map<Key, ValueIndex> readerCache = this.cache.get(reader);
            if (readerCache == null) {
                return null;
            }
            return readerCache.get(new Key(field, prefix));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(IndexReader reader, String field, String prefix, ValueIndex value) {
        Map<IndexReader, Map<Key, ValueIndex>> map = this.cache;
        synchronized (map) {
            Map<Key, ValueIndex> readerCache = this.cache.get(reader);
            if (readerCache == null) {
                readerCache = new HashMap<Key, ValueIndex>();
                this.cache.put(reader, readerCache);
            }
            readerCache.put(new Key(field, prefix), value);
        }
    }

    private Comparable<?> getValue(String value, int type) {
        switch (type) {
            case 6: {
                return ComparableBoolean.valueOf(Boolean.valueOf(value));
            }
            case 5: {
                return new Long(DateField.stringToTime(value));
            }
            case 3: {
                return new Long(LongField.stringToLong(value));
            }
            case 4: {
                return new Double(DoubleField.stringToDouble(value));
            }
        }
        return value;
    }

    static class Key {
        private final String field;
        private final String prefix;

        Key(String field, String prefix) {
            this.field = field.intern();
            this.prefix = prefix.intern();
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return other.field == this.field && other.prefix == this.prefix;
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ this.prefix.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueIndex {
        private static final int SPARSE_FACTOR = 100;
        private final Comparable<?>[] values;
        public final Map<Integer, Comparable<?>> valuesMap;
        public final boolean sparse;

        public ValueIndex(Comparable<?>[] values, int setValues) {
            if (ValueIndex.isSparse(values, setValues)) {
                this.sparse = true;
                this.values = null;
                this.valuesMap = setValues == 0 ? null : ValueIndex.getValuesMap(values, setValues);
            } else {
                this.sparse = false;
                this.values = values;
                this.valuesMap = null;
            }
        }

        public Comparable<?> getValue(int i) {
            if (this.sparse) {
                return this.valuesMap == null ? null : this.valuesMap.get(i);
            }
            return this.values[i];
        }

        private static Map<Integer, Comparable<?>> getValuesMap(Comparable<?>[] values, int setValues) {
            HashMap map = new HashMap(setValues);
            for (int i = 0; i < values.length && setValues > 0; ++i) {
                if (values[i] == null) continue;
                map.put(i, values[i]);
                --setValues;
            }
            return map;
        }

        private static boolean isSparse(Comparable<?>[] values, int setValues) {
            return setValues * 100 < values.length;
        }
    }
}

