/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.webcontent;

import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;

public class WebContentSchemaHandler
extends BaseWebSchemaHandler {
    @Override
    protected String getHandlerNodeType() {
        return "exo:webContent";
    }

    @Override
    protected String getParentNodeType() {
        return "nt:unstructured";
    }

    @Override
    public boolean matchHandler(SessionProvider sessionProvider, Node node) throws Exception {
        String handlerNodeType = this.getHandlerNodeType();
        String parentNodeType = this.getParentNodeType();
        if (!node.isNodeType(handlerNodeType)) {
            return false;
        }
        return node.getParent().isNodeType(parentNodeType);
    }

    @Override
    public void onCreateNode(SessionProvider sessionProvider, Node webContent) throws Exception {
        Session session = webContent.getSession();
        this.createSchema(webContent);
        session.save();
    }

    public Node getCSSFolder(Node webContent) throws Exception {
        return webContent.getNode("css");
    }

    public Node getJSFolder(Node webContent) throws Exception {
        return webContent.getNode("js");
    }

    public Node getImagesFolders(Node webContent) throws Exception {
        return webContent.getNode("medias/images");
    }

    public Node getIllustrationImage(Node webContent) throws Exception {
        return webContent.getNode("medias/images/illustration");
    }

    public Node getVideoFolder(Node webContent) throws Exception {
        return webContent.getNode("medias/videos");
    }

    public Node getDocumentFolder(Node webContent) throws Exception {
        return webContent.getNode("documents");
    }

    public void createDefaultSchema(Node webContent) throws Exception {
        this.addMixin(webContent, "exo:owneable");
        this.createSchema(webContent);
        this.createDefautWebData(webContent);
    }

    protected void createSchema(Node webContent) throws Exception {
        if (!webContent.hasNode("js")) {
            Node js = webContent.addNode("js", "exo:jsFolder");
            this.addMixin(js, "exo:owneable");
        }
        if (!webContent.hasNode("css")) {
            Node css = webContent.addNode("css", "exo:cssFolder");
            this.addMixin(css, "exo:owneable");
        }
        if (!webContent.hasNode("medias")) {
            Node multimedia = webContent.addNode("medias", "exo:multimediaFolder");
            this.addMixin(multimedia, "exo:owneable");
            Node images = multimedia.addNode("images", "nt:folder");
            this.addMixin(images, "exo:pictureFolder");
            this.addMixin(images, "exo:owneable");
            Node video = multimedia.addNode("videos", "nt:folder");
            this.addMixin(video, "exo:videoFolder");
            this.addMixin(video, "exo:owneable");
            Node audio = multimedia.addNode("audio", "nt:folder");
            this.addMixin(audio, "exo:musicFolder");
            this.addMixin(audio, "exo:owneable");
        }
        if (!webContent.hasNode("documents")) {
            Node document = webContent.addNode("documents", "nt:unstructured");
            this.addMixin(document, "exo:documentFolder");
            this.addMixin(document, "exo:owneable");
        }
        webContent.setProperty("exo:title", webContent.getName());
    }

    public boolean isWebcontentChildNode(Node file) throws Exception {
        Node parent = file.getParent();
        if (parent.isNodeType("exo:webContent")) {
            return true;
        }
        if (parent.getPath().equals("/")) {
            return false;
        }
        Node grantParent = parent.getParent();
        if (grantParent.isNodeType("exo:webContent")) {
            return true;
        }
        if (grantParent.getPath().equals("/")) {
            return false;
        }
        Node ansestor = grantParent.getParent();
        return ansestor.isNodeType("exo:webContent");
    }
}

