/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.forum.common.jcr.JCRQueryUtils;
import org.exoplatform.forum.service.ForumNodeTypes;
import org.exoplatform.forum.service.Utils;

public class ForumEventQuery
implements ForumNodeTypes {
    public static final String VALUE_IN_ENTIRE = "entire";
    public static final String VALUE_IN_TITLE = "title";
    long userPermission = 0L;
    List<String> listOfUser = null;
    private String type;
    private String keyValue;
    private String valueIn;
    private String path;
    private String byUser;
    private String isLock;
    private String isClosed;
    private String topicCountMin = "0";
    private String postCountMin = "0";
    private String viewCountMin = "0";
    private String moderator;
    private String remain;
    private Calendar fromDateCreated;
    private Calendar toDateCreated;
    private Calendar fromDateCreatedLastPost;
    private Calendar toDateCreatedLastPost;
    private boolean isStartWith = false;
    private boolean isAnd = false;
    private boolean isEmpty = true;

    public void setListOfUser(List<String> listOfUser) {
        this.listOfUser = new ArrayList<String>();
        this.listOfUser.addAll(listOfUser);
    }

    public List<String> getListOfUser() {
        return this.listOfUser;
    }

    public long getUserPermission() {
        return this.userPermission;
    }

    public void setUserPermission(long userPermission) {
        this.userPermission = userPermission;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(String keyValue) {
        this.keyValue = keyValue;
    }

    public String getValueIn() {
        return this.valueIn;
    }

    public void setValueIn(String valueIn) {
        this.valueIn = valueIn;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getByUser() {
        return this.byUser;
    }

    public void setByUser(String byUser) {
        this.byUser = byUser;
    }

    public String getIsLock() {
        return this.isLock;
    }

    public void setIsLock(String isLock) {
        this.isLock = isLock;
    }

    public String getIsClose() {
        return this.isClosed;
    }

    public void setIsClose(String isClosed) {
        this.isClosed = isClosed;
    }

    public String getTopicCountMin() {
        return this.topicCountMin;
    }

    public void setTopicCountMin(String topicCountMin) {
        this.topicCountMin = topicCountMin;
    }

    public String getPostCountMin() {
        return this.postCountMin;
    }

    public void setPostCountMin(String postCountMin) {
        this.postCountMin = postCountMin;
    }

    public String getViewCountMin() {
        return this.viewCountMin;
    }

    public void setViewCountMin(String viewCountMin) {
        this.viewCountMin = viewCountMin;
    }

    public String getModerator() {
        return this.moderator;
    }

    public void setModerator(String moderator) {
        this.moderator = moderator;
    }

    public String getRemain() {
        return this.remain;
    }

    public void setRemain(String remain) {
        this.remain = remain;
    }

    public Calendar getFromDateCreated() {
        return this.fromDateCreated;
    }

    public void setFromDateCreated(Calendar fromDateCreated) {
        this.fromDateCreated = fromDateCreated;
    }

    public Calendar getToDateCreated() {
        return this.toDateCreated;
    }

    public void setToDateCreated(Calendar toDateCreated) {
        this.toDateCreated = toDateCreated;
    }

    public Calendar getFromDateCreatedLastPost() {
        return this.fromDateCreatedLastPost;
    }

    public void setFromDateCreatedLastPost(Calendar fromDateCreatedLastPost) {
        this.fromDateCreatedLastPost = fromDateCreatedLastPost;
    }

    public Calendar getToDateCreatedLastPost() {
        return this.toDateCreatedLastPost;
    }

    public void setToDateCreatedLastPost(Calendar toDateCreatedLastPost) {
        this.toDateCreatedLastPost = toDateCreatedLastPost;
    }

    public boolean isStartWith() {
        return this.isStartWith;
    }

    public void setStartWith(boolean isStartWith) {
        this.isStartWith = isStartWith;
    }

    public boolean getIsEmpty() {
        return this.isEmpty;
    }

    public String getPathQuery(List<String> listIds) {
        String temp;
        this.isAnd = false;
        this.isEmpty = true;
        String nodeType = Utils.CATEGORY.equals(this.type) ? "exo:forumCategory" : (Utils.FORUM.equals(this.type) ? "exo:forum" : (Utils.TOPIC.equals(this.type) ? "exo:topic" : "exo:post"));
        StringBuffer queryString = new StringBuffer();
        if (this.path != null && this.path.length() > 0) {
            queryString.append("/jcr:root").append(this.path).append("//element(*,").append(nodeType).append(")");
        } else {
            queryString.append("//element(*,").append(nodeType).append(")");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.keyValue != null && this.keyValue.length() > 0) {
            String xpath = "jcr:contains";
            if (this.isStartWith) {
                xpath = "jcr:like";
                this.keyValue = this.keyValue + "%";
            }
            if (VALUE_IN_TITLE.equals(this.valueIn)) {
                stringBuffer.append("(").append(xpath).append("(@").append("exo:name").append(", '").append(this.keyValue).append("'))");
            } else {
                stringBuffer.append("(").append(xpath).append("(., '").append(this.keyValue).append("'))");
            }
            this.isAnd = true;
        }
        if (this.byUser != null && this.byUser.length() > 0 && (temp = this.setArrays(this.byUser, "exo:owner")) != null && temp.length() > 0) {
            stringBuffer.append(temp);
        }
        if (this.isAnd) {
            this.isEmpty = false;
        }
        if (this.type.equals(Utils.FORUM) || this.type.equals(Utils.TOPIC)) {
            if (this.isClosed != null && this.isClosed.length() > 0) {
                if (this.userPermission == 1L) {
                    if (this.type.equals(Utils.FORUM)) {
                        if (this.isAnd) {
                            stringBuffer.append(" and ");
                        }
                        if (this.isClosed.equals("all")) {
                            stringBuffer.append("(@").append("exo:isClosed").append("='false' or (").append(Utils.buildXpathByUserInfo("exo:moderators", this.listOfUser)).append("))");
                        } else if (this.isClosed.equals("false")) {
                            stringBuffer.append("(@").append("exo:isClosed").append("='").append(this.isClosed).append("')");
                            this.isEmpty = false;
                        } else if (this.isClosed.equals("true")) {
                            stringBuffer.append("(@").append("exo:isClosed").append("='").append(this.isClosed).append("' and (").append(Utils.buildXpathByUserInfo("exo:moderators", this.listOfUser));
                            stringBuffer.append("))");
                            this.isEmpty = false;
                        }
                        this.isAnd = true;
                    } else if (!this.isClosed.equals("all")) {
                        if (this.isAnd) {
                            stringBuffer.append(" and ");
                        }
                        stringBuffer.append("(@").append("exo:isClosed").append("='").append(this.isClosed).append("')");
                        this.isAnd = true;
                        this.isEmpty = false;
                    }
                } else if (!this.isClosed.equals("all")) {
                    if (this.isAnd) {
                        stringBuffer.append(" and ");
                    }
                    stringBuffer.append("(@").append("exo:isClosed").append("='").append(this.isClosed).append("')");
                    this.isAnd = true;
                    this.isEmpty = false;
                }
            }
            if (this.isLock != null && this.isLock.length() > 0 && !this.isLock.equals("all")) {
                if (this.isAnd) {
                    stringBuffer.append(" and ");
                }
                stringBuffer.append("(@").append("exo:isLock").append("='").append(this.isLock).append("')");
                this.isAnd = true;
                this.isEmpty = false;
            }
        }
        if (this.remain != null && this.remain.length() > 0) {
            if (this.isAnd) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append("(").append(this.remain).append(")");
            this.isAnd = true;
        }
        if (this.moderator != null && this.moderator.length() > 0 && (Utils.FORUM.equals(this.type) || Utils.CATEGORY.equals(this.type)) && (temp = this.setArrays(this.moderator, "exo:moderators")) != null && temp.length() > 0) {
            stringBuffer.append(temp);
            this.isEmpty = false;
        }
        if (Utils.FORUM.equals(this.type) || Utils.TOPIC.equals(this.type)) {
            temp = this.setValueMin(this.topicCountMin, "exo:topicCount");
            if (temp != null && temp.length() > 0) {
                stringBuffer.append(temp);
            }
            if ((temp = this.setValueMin(this.postCountMin, "exo:postCount")) != null && temp.length() > 0) {
                stringBuffer.append(temp);
            }
            if (Utils.TOPIC.equals(this.type)) {
                temp = this.setValueMin(this.viewCountMin, "exo:viewCount");
                if (temp != null && temp.length() > 0) {
                    stringBuffer.append(temp);
                }
                if ((temp = this.setDateFromTo(this.fromDateCreatedLastPost, this.toDateCreatedLastPost, "exo:lastPostDate")) != null && temp.length() > 0) {
                    stringBuffer.append(temp);
                }
            }
        }
        if ((temp = this.setDateFromTo(this.fromDateCreated, this.toDateCreated, "exo:createdDate")) != null && temp.length() > 0) {
            stringBuffer.append(temp);
        }
        if (this.type.equals(Utils.TOPIC) && this.userPermission > 1L) {
            if (this.isAnd) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append("(@").append("exo:isApproved").append("='true' and @").append("exo:isActive").append("='true' and @").append("exo:isWaiting").append("='false' and @").append("exo:isActiveByForum").append("='true')");
            String str = Utils.buildXpathByUserInfo("exo:canView", this.listOfUser);
            if (!Utils.isEmpty(str)) {
                if (this.isAnd) {
                    stringBuffer.append(" and ");
                }
                stringBuffer.append("(").append(Utils.buildXpathHasProperty("exo:canView")).append(" or ").append(str).append(" or @").append("exo:owner").append("='").append(this.listOfUser.get(0)).append("'").append(")");
            }
        }
        if (this.type.equals(Utils.POST)) {
            if (this.isAnd) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append("(@").append("exo:userPrivate").append("='").append("exoUserPri").append("'");
            for (String currentUser : this.listOfUser) {
                stringBuffer.append(" or @").append("exo:userPrivate").append("='").append(currentUser).append("'");
            }
            stringBuffer.append(") and (@").append("exo:isFirstPost").append("='false')");
            if (this.userPermission > 1L) {
                stringBuffer.append(" and (@").append("exo:isApproved").append("='true' and @").append("exo:isActiveByTopic").append("='true' and @").append("exo:isHidden").append("='false')");
            }
        }
        if (listIds != null && listIds.size() > 0) {
            stringBuffer.append(" and (");
            int size = listIds.size();
            String searchBy = null;
            searchBy = this.type.equals(Utils.CATEGORY) || this.type.equals(Utils.FORUM) ? "fn:name()" : "@exo:path";
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    stringBuffer.append(" or ");
                }
                stringBuffer.append(searchBy).append("='").append(listIds.get(i)).append("'");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append("]");
        if (this.isAnd) {
            queryString.append(stringBuffer.toString());
        }
        return queryString.toString();
    }

    private String setArrays(String values, String property) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder builder = new StringBuilder();
        values = values.replaceAll(";", ",");
        if ((values = JCRQueryUtils.escapeSimpleQuoteCharacter((String)values)).indexOf(",") > 0) {
            String[] vls = values.split(",");
            int i = 0;
            for (String string : vls) {
                if ((string = string.trim()).length() <= 0) continue;
                if (i > 0) {
                    builder.append(" or ");
                }
                builder.append("(@").append(property).append("='").append(string).append("')");
                ++i;
            }
        } else if (values.trim().length() > 0) {
            builder.append("@").append(property).append("='").append(values).append("'");
        }
        if (builder.length() > 0) {
            if (this.isAnd) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append("(").append((CharSequence)builder).append(")");
            this.isAnd = true;
        }
        return stringBuffer.toString();
    }

    private String setValueMin(String min, String property) {
        StringBuffer queryString = new StringBuffer();
        if (Integer.parseInt(min) > 0) {
            if (this.isAnd) {
                queryString.append(" and ");
            }
            queryString.append("(@").append(property).append(">=").append(min).append(")");
            this.isAnd = true;
            this.isEmpty = false;
        }
        return queryString.toString();
    }

    private String setDateFromTo(Calendar fromDate, Calendar toDate, String property) {
        StringBuffer queryString = new StringBuffer();
        if (fromDate != null && toDate != null) {
            if (this.isAnd) {
                queryString.append(" and ");
            }
            queryString.append("((@").append(property).append(" >= xs:dateTime('").append(ISO8601.format((Calendar)fromDate)).append("')) and ");
            queryString.append("(@").append(property).append(" <= xs:dateTime('").append(ISO8601.format((Calendar)toDate)).append("'))) ");
            this.isAnd = true;
            this.isEmpty = false;
        } else if (fromDate != null) {
            if (this.isAnd) {
                queryString.append(" and ");
            }
            queryString.append("(@").append(property).append(" >= xs:dateTime('").append(ISO8601.format((Calendar)fromDate)).append("'))");
            this.isAnd = true;
            this.isEmpty = false;
        } else if (toDate != null) {
            if (this.isAnd) {
                queryString.append(" and ");
            }
            queryString.append("(@").append(property).append(" <= xs:dateTime('").append(ISO8601.format((Calendar)toDate)).append("'))");
            this.isAnd = true;
            this.isEmpty = false;
        }
        return queryString.toString();
    }
}

