/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.jcr.listener;

import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.impl.JCRDataStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class StatisticEventListener
implements EventListener {
    private String workspace_;
    private String repository_;
    private String path_;
    private Log LOG = ExoLogger.getLogger(StatisticEventListener.class);

    public StatisticEventListener(String ws, String repo) throws Exception {
        this.workspace_ = ws;
        this.repository_ = repo;
    }

    public StatisticEventListener() throws Exception {
        this.workspace_ = "";
        this.repository_ = "";
    }

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public void onEvent(EventIterator evIter) {
        try {
            JCRDataStorage dataStorage = (JCRDataStorage)CommonsUtils.getService(JCRDataStorage.class);
            long topicCount = 0L;
            long postCount = 0L;
            while (evIter.hasNext()) {
                Event ev = evIter.nextEvent();
                String path = ev.getPath();
                if (path.indexOf(Utils.TOPIC) <= 0) continue;
                if (ev.getType() == 1) {
                    String owner = dataStorage.getOwner(path);
                    if (Utils.isEmpty(owner)) continue;
                    if (path.indexOf(Utils.POST) > 0) {
                        ++postCount;
                        dataStorage.updateProfileAddPost(owner, path);
                        dataStorage.updatePostCount(path, owner);
                        continue;
                    }
                    if (path.indexOf(Utils.TOPIC) <= 0) continue;
                    ++topicCount;
                    dataStorage.updateProfileAddTopic(owner);
                    continue;
                }
                if (ev.getType() != 2) continue;
                if (path.indexOf(Utils.POST) > 0) {
                    --postCount;
                    continue;
                }
                if (path.indexOf(Utils.TOPIC) <= 0) continue;
                --topicCount;
            }
            if (topicCount != 0L || postCount != 0L) {
                dataStorage.updateStatisticCounts(topicCount, postCount);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"\nThe StatisEvent could not listen: ", (Throwable)e);
        }
    }
}

