/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.versioned;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.entries.versioned.VersionedTransientMortalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class VersionedTransientMortalCacheValue
extends TransientMortalCacheValue
implements Versioned {
    EntryVersion version;

    public VersionedTransientMortalCacheValue(Object value, EntryVersion version, long created, long lifespan, long maxIdle, long lastUsed) {
        super(value, created, lifespan, maxIdle, lastUsed);
        this.version = version;
    }

    public VersionedTransientMortalCacheValue(Object value, EntryVersion version, long created, long lifespan, long maxIdle) {
        super(value, created, lifespan, maxIdle);
        this.version = version;
    }

    public VersionedTransientMortalCacheValue(Object value, EntryVersion version, long created) {
        super(value, created);
        this.version = version;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new VersionedTransientMortalCacheEntry(key, this);
    }

    @Override
    public EntryVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(EntryVersion version) {
        this.version = version;
    }

    public static class Externalizer
    extends AbstractExternalizer<VersionedTransientMortalCacheValue> {
        @Override
        public void writeObject(ObjectOutput output, VersionedTransientMortalCacheValue value) throws IOException {
            output.writeObject(value.value);
            output.writeObject(value.version);
            UnsignedNumeric.writeUnsignedLong(output, value.created);
            output.writeLong(value.lifespan);
            UnsignedNumeric.writeUnsignedLong(output, value.lastUsed);
            output.writeLong(value.maxIdle);
        }

        @Override
        public VersionedTransientMortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            EntryVersion version = (EntryVersion)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new VersionedTransientMortalCacheValue(v, version, created, lifespan, maxIdle, lastUsed);
        }

        @Override
        public Integer getId() {
            return 83;
        }

        @Override
        public Set<Class<? extends VersionedTransientMortalCacheValue>> getTypeClasses() {
            return Util.asSet(VersionedTransientMortalCacheValue.class);
        }
    }
}

