/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.ByteArrayOutputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class ExposedByteArrayOutputStream
extends ByteArrayOutputStream {
    public static final int DEFAULT_DOUBLING_SIZE = 0x400000;
    private int maxDoublingSize = 0x400000;

    public ExposedByteArrayOutputStream() {
    }

    public ExposedByteArrayOutputStream(int size) {
        super(size);
    }

    public ExposedByteArrayOutputStream(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Null or empty byte arrays not allowed");
        }
        this.buf = bytes;
        this.count = bytes.length;
    }

    public ExposedByteArrayOutputStream(int size, int maxDoublingSize) {
        super(size);
        this.maxDoublingSize = maxDoublingSize;
    }

    public final byte[] getRawBuffer() {
        return this.buf;
    }

    public final void set(byte[] b) {
        this.buf = b;
        this.count = b.length;
    }

    @Override
    public final void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[this.getNewBufferSize(this.buf.length, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public final void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[this.getNewBufferSize(this.buf.length, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public final int getMaxDoublingSize() {
        return this.maxDoublingSize;
    }

    public final int getNewBufferSize(int curSize, int minNewSize) {
        if (curSize <= this.maxDoublingSize) {
            return Math.max(curSize << 1, minNewSize);
        }
        return Math.max(curSize + (curSize >> 2), minNewSize);
    }

    @Override
    public final int size() {
        return this.count;
    }

    public boolean equals(Object thatObject) {
        if (thatObject instanceof ExposedByteArrayOutputStream) {
            ExposedByteArrayOutputStream that = (ExposedByteArrayOutputStream)thatObject;
            if (this == that) {
                return true;
            }
            if (this.buf == that.buf) {
                return true;
            }
            if (this.count != that.count) {
                return false;
            }
            for (int i = 0; i < this.count; ++i) {
                if (this.buf[i] == that.buf[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

