/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.jboss.AbstractJBossMarshaller;
import org.infinispan.marshall.jboss.DefaultContextClassResolver;
import org.infinispan.marshall.jboss.ExternalizerTable;
import org.jboss.marshalling.ObjectTable;

public final class JBossMarshaller
extends AbstractJBossMarshaller
implements StreamingMarshaller {
    ExternalizerTable externalizerTable;
    GlobalConfiguration globalCfg;
    Configuration cfg;
    InvocationContextContainer icc;

    public void inject(ExternalizerTable externalizerTable, Configuration cfg, InvocationContextContainer icc, GlobalConfiguration globalCfg) {
        log.debug((Object)"Using JBoss Marshalling");
        this.externalizerTable = externalizerTable;
        this.globalCfg = globalCfg;
        this.cfg = cfg;
        this.icc = icc;
    }

    @Override
    public void start() {
        super.start();
        this.baseCfg.setObjectTable((ObjectTable)this.externalizerTable);
        Object classResolver = this.globalCfg.getClassResolver();
        if (classResolver == null) {
            ClassLoader cl = this.cfg == null ? this.globalCfg.getClassLoader() : this.cfg.getClassLoader();
            classResolver = new EmbeddedContextClassResolver(cl, this.icc);
        }
        this.baseCfg.setClassResolver(classResolver);
    }

    @Override
    public void stop() {
        super.stop();
        this.baseCfg.setClassResolver(null);
    }

    @Override
    public boolean isMarshallableCandidate(Object o) {
        return super.isMarshallableCandidate(o) || this.externalizerTable.isMarshallableCandidate(o);
    }

    public static final class EmbeddedContextClassResolver
    extends DefaultContextClassResolver {
        private final InvocationContextContainer icc;

        public EmbeddedContextClassResolver(ClassLoader defaultClassLoader, InvocationContextContainer icc) {
            super(defaultClassLoader);
            this.icc = icc;
        }

        @Override
        protected ClassLoader getClassLoader() {
            ClassLoader cl;
            InvocationContext ctx;
            if (this.icc != null && (ctx = this.icc.getInvocationContext(true)) != null && (cl = ctx.getClassLoader()) != null) {
                return cl;
            }
            return super.getClassLoader();
        }
    }
}

