/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.wikimodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.rendering.internal.parser.wikimodel.WikiModelParserUtils;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.listener.CompositeListener;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.wikimodel.IWemConstants;
import org.xwiki.rendering.wikimodel.WikiFormat;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.WikiStyle;

public class DefaultXWikiGeneratorListener
implements XWikiGeneratorListener {
    public static final String EXT_ID = "xwiki_id";
    private static final Map<WikiStyle, Format> STYLES_CONVERTER = new HashMap<WikiStyle, Format>();
    private Stack<Listener> listener = new Stack();
    private StreamParser parser;
    private ResourceReferenceParser linkReferenceParser;
    private ResourceReferenceParser imageReferenceParser;
    private IdGenerator idGenerator;
    private PrintRendererFactory plainRendererFactory;
    private int documentDepth = 0;
    private Stack<WikiFormat> currentFormatStack = new Stack();
    private WikiFormat lastEndFormat = null;
    private Syntax syntax;
    private MetaData documentMetadata;

    public DefaultXWikiGeneratorListener(StreamParser parser, Listener listener, ResourceReferenceParser linkReferenceParser, ResourceReferenceParser imageReferenceParser, PrintRendererFactory plainRendererFactory, IdGenerator idGenerator, Syntax syntax) {
        this.pushListener(listener);
        this.parser = parser;
        this.linkReferenceParser = linkReferenceParser;
        this.imageReferenceParser = imageReferenceParser;
        this.idGenerator = idGenerator != null ? idGenerator : new IdGenerator();
        this.plainRendererFactory = plainRendererFactory;
        this.syntax = syntax;
        this.documentMetadata = new MetaData();
        this.documentMetadata.addMetaData("syntax", (Object)this.syntax);
    }

    @Override
    public Listener getListener() {
        return this.listener.peek();
    }

    protected ResourceReferenceParser getLinkReferenceParser() {
        return this.linkReferenceParser;
    }

    protected ResourceReferenceParser getImageReferenceParser() {
        return this.imageReferenceParser;
    }

    private Listener pushListener(Listener listener) {
        return this.listener.push(listener);
    }

    private Listener popListener() {
        return this.listener.pop();
    }

    protected Map<String, String> convertParameters(WikiParameters params) {
        LinkedHashMap<String, String> xwikiParams;
        if (params.getSize() > 0) {
            xwikiParams = new LinkedHashMap<String, String>();
            for (WikiParameter wikiParameter : params.toList()) {
                xwikiParams.put(wikiParameter.getKey(), wikiParameter.getValue());
            }
        } else {
            xwikiParams = Listener.EMPTY_PARAMETERS;
        }
        return xwikiParams;
    }

    protected Pair<Map<String, String>, Map<String, String>> convertAndSeparateParameters(WikiParameters params) {
        LinkedHashMap<String, String> genericParameters;
        LinkedHashMap<String, String> resourceParameters;
        if (params.getSize() > 0) {
            resourceParameters = new LinkedHashMap<String, String>();
            genericParameters = new LinkedHashMap<String, String>();
            for (WikiParameter wikiParameter : params.toList()) {
                String key = wikiParameter.getKey();
                if (key.equals("anchor") || key.equals("queryString")) {
                    resourceParameters.put(key, wikiParameter.getValue());
                    continue;
                }
                genericParameters.put(key, wikiParameter.getValue());
            }
        } else {
            resourceParameters = Listener.EMPTY_PARAMETERS;
            genericParameters = Listener.EMPTY_PARAMETERS;
        }
        return new ImmutablePair(resourceParameters, genericParameters);
    }

    private Format convertFormat(WikiStyle style) {
        Format result = STYLES_CONVERTER.get(style);
        if (result == null) {
            result = Format.NONE;
        }
        return result;
    }

    private void flush() {
        this.flushInline();
    }

    private void flushInline() {
        this.flushFormat();
    }

    protected void flushFormat() {
        this.flushFormat(null, null);
    }

    private void flushFormat(List<WikiStyle> xorStyles, List<WikiParameter> xorParameters) {
        if (this.lastEndFormat != null) {
            this.flushFormat(this.lastEndFormat.getStyles(), this.lastEndFormat.getParams(), xorStyles, xorParameters);
        }
    }

    private void flushFormat(List<WikiStyle> formatStyles, List<WikiParameter> formatParameters, List<WikiStyle> xorStyles, List<WikiParameter> xorParameters) {
        HashSet<WikiStyle> stylesToClose = new HashSet<WikiStyle>();
        HashSet<WikiParameter> parametersToClose = new HashSet<WikiParameter>();
        if (xorStyles != null) {
            for (WikiStyle style : formatStyles) {
                if (xorStyles.contains(style)) continue;
                stylesToClose.add(style);
            }
        } else {
            stylesToClose.addAll(formatStyles);
        }
        if (xorParameters != null) {
            for (WikiParameter parameter : formatParameters) {
                if (xorParameters.contains(parameter)) continue;
                parametersToClose.add(parameter);
            }
        } else {
            parametersToClose.addAll(formatParameters);
        }
        while (!stylesToClose.isEmpty() || !parametersToClose.isEmpty()) {
            WikiFormat currentFormat = this.currentFormatStack.peek();
            List currentFormatStyles = currentFormat.getStyles();
            WikiStyle currentFormatStyle = currentFormatStyles.isEmpty() ? null : (WikiStyle)currentFormatStyles.get(0);
            List currentFormatParameters = currentFormat.getParams();
            stylesToClose.remove(currentFormatStyle);
            parametersToClose.removeAll(currentFormatParameters);
            Map<String, String> parameters = !currentFormatParameters.isEmpty() ? this.convertParameters(new WikiParameters((Collection)currentFormatParameters)) : Listener.EMPTY_PARAMETERS;
            if (currentFormatStyle != null) {
                this.getListener().endFormat(this.convertFormat(currentFormatStyle), parameters);
            } else {
                this.getListener().endFormat(Format.NONE, parameters);
            }
            this.currentFormatStack.pop();
        }
        for (WikiFormat format : this.currentFormatStack) {
            if (xorStyles != null) {
                xorStyles.removeAll(format.getStyles());
            }
            if (xorParameters == null) continue;
            xorParameters.removeAll(format.getParams());
        }
        this.lastEndFormat = null;
    }

    public void beginDefinitionDescription() {
        this.getListener().beginDefinitionDescription();
    }

    public void beginDefinitionList(WikiParameters params) {
        this.flushInline();
        this.getListener().beginDefinitionList(this.convertParameters(params));
    }

    public void beginDefinitionTerm() {
        this.getListener().beginDefinitionTerm();
    }

    public void beginDocument(WikiParameters params) {
        if (this.documentDepth > 0) {
            this.getListener().beginGroup(this.convertParameters(params));
        } else {
            this.getListener().beginDocument(this.documentMetadata);
        }
        ++this.documentDepth;
    }

    public void beginFormat(WikiFormat format) {
        List formatStyles = format.getStyles();
        List formatParameters = format.getParams();
        if (formatStyles.size() > 0 || formatParameters.size() > 0) {
            this.flushFormat(formatStyles, formatParameters);
            if (formatStyles.size() > 0 || formatParameters.size() > 0) {
                Map<String, String> parameters = formatParameters.size() > 0 ? this.convertParameters(new WikiParameters((Collection)formatParameters)) : Listener.EMPTY_PARAMETERS;
                if (formatStyles.size() > 0) {
                    boolean parametersConsumed = false;
                    for (WikiStyle style : formatStyles) {
                        if (!parametersConsumed) {
                            this.getListener().beginFormat(this.convertFormat(style), parameters);
                            parametersConsumed = true;
                            this.currentFormatStack.push(new WikiFormat(Collections.singleton(style), (Collection)formatParameters));
                            continue;
                        }
                        this.getListener().beginFormat(this.convertFormat(style), Listener.EMPTY_PARAMETERS);
                        this.currentFormatStack.push(new WikiFormat(style));
                    }
                } else {
                    this.getListener().beginFormat(Format.NONE, parameters);
                    this.currentFormatStack.push(new WikiFormat((Collection)formatParameters));
                }
            }
        }
    }

    public void beginSection(int docLevel, int headerLevel, WikiParameters params) {
        if (headerLevel > 0) {
            this.getListener().beginSection(Listener.EMPTY_PARAMETERS);
        }
    }

    public void beginSectionContent(int docLevel, int headerLevel, WikiParameters params) {
    }

    public void beginHeader(int level, WikiParameters params) {
        CompositeListener composite = new CompositeListener();
        composite.addListener((Listener)new QueueListener());
        composite.addListener((Listener)this.plainRendererFactory.createRenderer((WikiPrinter)new DefaultWikiPrinter()));
        this.pushListener((Listener)composite);
    }

    public void beginInfoBlock(String infoType, WikiParameters params) {
    }

    public void beginList(WikiParameters params, boolean ordered) {
        this.flushInline();
        if (ordered) {
            this.getListener().beginList(ListType.NUMBERED, this.convertParameters(params));
        } else {
            this.getListener().beginList(ListType.BULLETED, this.convertParameters(params));
        }
    }

    public void beginListItem() {
        this.getListener().beginListItem();
    }

    public void beginParagraph(WikiParameters params) {
        this.getListener().beginParagraph(this.convertParameters(params));
    }

    public void beginPropertyBlock(String propertyUri, boolean doc) {
    }

    public void beginPropertyInline(String str) {
    }

    public void beginQuotation(WikiParameters params) {
        this.getListener().beginQuotation(this.convertParameters(params));
    }

    public void beginQuotationLine() {
        this.getListener().beginQuotationLine();
    }

    public void beginTable(WikiParameters params) {
        this.getListener().beginTable(this.convertParameters(params));
    }

    public void beginTableCell(boolean tableHead, WikiParameters params) {
        if (tableHead) {
            this.getListener().beginTableHeadCell(this.convertParameters(params));
        } else {
            this.getListener().beginTableCell(this.convertParameters(params));
        }
    }

    public void beginTableRow(WikiParameters params) {
        this.getListener().beginTableRow(this.convertParameters(params));
    }

    public void endDefinitionDescription() {
        this.flushInline();
        this.getListener().endDefinitionDescription();
    }

    public void endDefinitionList(WikiParameters params) {
        this.getListener().endDefinitionList(this.convertParameters(params));
    }

    public void endDefinitionTerm() {
        this.flushInline();
        this.getListener().endDefinitionTerm();
    }

    public void endDocument(WikiParameters params) {
        this.flush();
        --this.documentDepth;
        if (this.documentDepth > 0) {
            this.getListener().endGroup(this.convertParameters(params));
        } else {
            this.getListener().endDocument(this.documentMetadata);
        }
    }

    public void endFormat(WikiFormat format) {
        if (format.getStyles().size() > 0 || format.getParams().size() > 0) {
            this.lastEndFormat = format;
        }
    }

    public void endHeader(int level, WikiParameters params) {
        this.flushInline();
        CompositeListener composite = (CompositeListener)this.getListener();
        QueueListener queue = (QueueListener)composite.getListener(0);
        PrintRenderer renderer = (PrintRenderer)composite.getListener(1);
        this.popListener();
        HeaderLevel headerLevel = HeaderLevel.parseInt((int)level);
        String id = this.idGenerator.generateUniqueId("H", renderer.getPrinter().toString());
        Map<String, String> parameters = this.convertParameters(params);
        this.getListener().beginHeader(headerLevel, id, parameters);
        queue.consumeEvents(this.getListener());
        this.getListener().endHeader(headerLevel, id, parameters);
    }

    public void endSection(int docLevel, int headerLevel, WikiParameters params) {
        if (headerLevel > 0) {
            this.getListener().endSection(Listener.EMPTY_PARAMETERS);
        }
    }

    public void endSectionContent(int docLevel, int headerLevel, WikiParameters params) {
    }

    public void endInfoBlock(String infoType, WikiParameters params) {
    }

    public void endList(WikiParameters params, boolean ordered) {
        if (ordered) {
            this.getListener().endList(ListType.NUMBERED, this.convertParameters(params));
        } else {
            this.getListener().endList(ListType.BULLETED, this.convertParameters(params));
        }
    }

    public void endListItem() {
        this.flushInline();
        this.getListener().endListItem();
    }

    public void endParagraph(WikiParameters params) {
        this.flushFormat();
        this.getListener().endParagraph(this.convertParameters(params));
    }

    public void endPropertyBlock(String propertyUri, boolean doc) {
    }

    public void endPropertyInline(String inlineProperty) {
    }

    public void endQuotation(WikiParameters params) {
        this.getListener().endQuotation(this.convertParameters(params));
    }

    public void endQuotationLine() {
        this.flushInline();
        this.getListener().endQuotationLine();
    }

    public void endTable(WikiParameters params) {
        this.getListener().endTable(this.convertParameters(params));
    }

    public void endTableCell(boolean tableHead, WikiParameters params) {
        this.flushInline();
        if (tableHead) {
            this.getListener().endTableHeadCell(this.convertParameters(params));
        } else {
            this.getListener().endTableCell(this.convertParameters(params));
        }
    }

    public void endTableRow(WikiParameters params) {
        this.getListener().endTableRow(this.convertParameters(params));
    }

    public void onEmptyLines(int count) {
        this.getListener().onEmptyLines(count);
    }

    public void onEscape(String str) {
    }

    public void onExtensionBlock(String extensionName, WikiParameters params) {
        if (EXT_ID.equals(extensionName)) {
            this.getListener().onId(params.getParameter("name").getValue());
        }
    }

    public void onExtensionInline(String extensionName, WikiParameters params) {
        if (EXT_ID.equals(extensionName)) {
            this.getListener().onId(params.getParameter("name").getValue());
        }
    }

    public void onHorizontalLine(WikiParameters params) {
        this.getListener().onHorizontalLine(this.convertParameters(params));
    }

    public void onLineBreak() {
        this.onNewLine();
    }

    public void onMacroBlock(String macroName, WikiParameters params, String content) {
        this.getListener().onMacro(macroName, this.convertParameters(params), content, false);
    }

    public void onMacroInline(String macroName, WikiParameters params, String content) {
        this.flushFormat();
        this.getListener().onMacro(macroName, this.convertParameters(params), content, true);
    }

    public void onNewLine() {
        this.flushFormat();
        this.getListener().onNewLine();
    }

    public void onReference(String reference) {
        this.onReference(reference, null, true, (Map<String, String>)Listener.EMPTY_PARAMETERS);
    }

    public void onReference(WikiReference reference) {
        this.onReference(reference.getLink(), reference.getLabel(), false, this.convertParameters(reference.getParameters()));
    }

    protected void onReference(String reference, String label, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.flushFormat();
        if (this.getLinkReferenceParser() != null) {
            this.onReference(this.getLinkReferenceParser().parse(reference), label, isFreeStandingURI, parameters);
        }
    }

    protected void onReference(ResourceReference reference, String label, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getListener().beginLink(reference, isFreeStandingURI, parameters);
        if (label != null) {
            try {
                WikiModelParserUtils parserUtils = new WikiModelParserUtils();
                parserUtils.parseInline(this.parser, label, this.getListener());
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        this.getListener().endLink(reference, isFreeStandingURI, parameters);
    }

    public void onImage(String reference) {
        this.onImage(reference, true, (Map<String, String>)Listener.EMPTY_PARAMETERS);
    }

    public void onImage(WikiReference reference) {
        this.onImage(reference.getLink(), false, this.convertParameters(reference.getParameters()));
    }

    protected void onImage(String reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.flushFormat();
        if (this.getImageReferenceParser() != null) {
            this.onImage(this.getImageReferenceParser().parse(reference), isFreeStandingURI, parameters);
        }
    }

    protected void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getListener().onImage(reference, isFreeStandingURI, parameters);
    }

    public void onSpace(String spaces) {
        this.flushFormat();
        for (int i = 0; i < spaces.length(); ++i) {
            this.getListener().onSpace();
        }
    }

    public void onSpecialSymbol(String symbol) {
        this.flushFormat();
        for (int i = 0; i < symbol.length(); ++i) {
            this.getListener().onSpecialSymbol(symbol.charAt(i));
        }
    }

    public void onTableCaption(String str) {
    }

    public void onVerbatimBlock(String protectedString, WikiParameters params) {
        this.getListener().onVerbatim(protectedString, false, this.convertParameters(params));
    }

    public void onVerbatimInline(String protectedString, WikiParameters params) {
        this.flushFormat();
        this.getListener().onVerbatim(protectedString, true, this.convertParameters(params));
    }

    public void onWord(String str) {
        this.flushFormat();
        this.getListener().onWord(str);
    }

    static {
        STYLES_CONVERTER.put(IWemConstants.CODE, Format.MONOSPACE);
        STYLES_CONVERTER.put(IWemConstants.EM, Format.ITALIC);
        STYLES_CONVERTER.put(IWemConstants.DEL, Format.STRIKEDOUT);
        STYLES_CONVERTER.put(IWemConstants.INS, Format.UNDERLINED);
        STYLES_CONVERTER.put(IWemConstants.MONO, Format.MONOSPACE);
        STYLES_CONVERTER.put(IWemConstants.STRIKE, Format.STRIKEDOUT);
        STYLES_CONVERTER.put(IWemConstants.STRONG, Format.BOLD);
        STYLES_CONVERTER.put(IWemConstants.SUB, Format.SUBSCRIPT);
        STYLES_CONVERTER.put(IWemConstants.SUP, Format.SUPERSCRIPT);
        STYLES_CONVERTER.put(IWemConstants.TT, Format.MONOSPACE);
        STYLES_CONVERTER.put(IWemConstants.BIG, Format.NONE);
        STYLES_CONVERTER.put(IWemConstants.CITE, Format.NONE);
        STYLES_CONVERTER.put(IWemConstants.REF, Format.NONE);
        STYLES_CONVERTER.put(IWemConstants.SMALL, Format.NONE);
    }
}

