/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.util.TimeZone;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class ForumUserListener
extends UserEventListener {
    private static Log log = ExoLogger.getLogger(ForumUserListener.class);
    private UserProfile profileTemplate;

    public ForumUserListener(InitParams params) throws Exception {
        if (params == null) {
            return;
        }
        PropertiesParam propsParams = params.getPropertiesParam("user.profile.setting");
        ExoProperties props = propsParams.getProperties();
        this.profileTemplate = new UserProfile();
        String timeZoneNumber = props.getProperty("timeZone") != null ? props.getProperty("timeZone") : "GMT";
        double timeZone = 0.0;
        timeZone = (double)(-TimeZone.getTimeZone(timeZoneNumber).getRawOffset()) * 1.0 / 3600000.0;
        this.profileTemplate.setTimeZone(timeZone);
        String shortDateFormat = props.getProperty("shortDateFormat") != null ? props.getProperty("shortDateFormat") : "MM/dd/yyyy";
        this.profileTemplate.setShortDateFormat(shortDateFormat);
        String longDateFormat = props.getProperty("longDateFormat") != null ? props.getProperty("longDateFormat") : "DDD, MMM dd, yyyy";
        this.profileTemplate.setLongDateFormat(longDateFormat);
        String timeFormat = props.getProperty("timeFormat") != null ? props.getProperty("timeFormat") : "hh:mm a";
        this.profileTemplate.setTimeFormat(timeFormat);
        String strMaxTopic = props.getProperty("maxTopic");
        int maxTopic = 10;
        try {
            maxTopic = Integer.parseInt(strMaxTopic);
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)"maxTopic is not in format", (Throwable)nfe);
        }
        this.profileTemplate.setMaxTopicInPage(maxTopic);
        String strMaxPost = props.getProperty("maxPost");
        int maxPost = 10;
        try {
            maxPost = Integer.parseInt(strMaxPost);
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)"maxPost is not in format", (Throwable)nfe);
        }
        this.profileTemplate.setMaxPostInPage(maxPost);
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (isNew) {
            try {
                this.getForumService().addMember(user, this.profileTemplate);
            }
            catch (Exception e) {
                log.warn((Object)"Error while adding new forum member: ", (Throwable)e);
            }
        } else {
            try {
                this.getForumService().updateUserProfile(user);
            }
            catch (Exception e) {
                log.warn((Object)"Error while updating forum profile: ", (Throwable)e);
            }
        }
        ForumServiceUtils.clearCache();
    }

    private ForumService getForumService() {
        return (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    }

    public void postDelete(User user) throws Exception {
        try {
            this.getForumService().removeMember(user);
        }
        catch (Exception e) {
            log.warn((Object)"failed to remove member : ", (Throwable)e);
        }
        ForumServiceUtils.clearCache();
    }

    public void postSetEnabled(User user) {
        ForumService fservice = (ForumService)CommonsUtils.getService(ForumService.class);
        fservice.processEnabledUser(user.getUserName(), user.getEmail(), user.isEnabled());
        if (!user.isEnabled()) {
            try {
                fservice.userLogout(user.getUserName());
            }
            catch (Exception e) {
                log.warn((Object)String.format("Removes online for user %s is unsuccessful.", user.getUserName()));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        ForumServiceUtils.clearCache();
    }
}

