/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.portal.application.JiBX_bindingMungeAdapter;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalRedirect;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.config.model.RedirectCondition;
import org.exoplatform.portal.config.model.RedirectMappings;
import org.exoplatform.portal.config.serialize.JibxArraySerialize;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.RedirectConditionData;
import org.exoplatform.portal.pom.data.RedirectData;
import org.exoplatform.portal.pom.data.RedirectMappingsData;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class PortalConfig
extends ModelObject
implements IUnmarshallable,
IMarshallable {
    public static final String USER_TYPE = SiteType.USER.getName();
    public static final String GROUP_TYPE = SiteType.GROUP.getName();
    public static final String PORTAL_TYPE = SiteType.PORTAL.getName();
    public static final Container DEFAULT_LAYOUT = PortalConfig.initDefaultLayout();
    private String name;
    private String type;
    private String locale;
    private String label;
    private String description;
    private String[] accessPermissions;
    private String editPermission;
    private Properties properties;
    private String skin;
    private Container portalLayout;
    private transient boolean modifiable;
    private ArrayList<PortalRedirect> portalRedirects;
    public static final String JiBX_bindingList = "|org.exoplatform.portal.application.JiBX_bindingFactory|";

    public PortalConfig() {
        this(PORTAL_TYPE);
    }

    public PortalConfig(String type) {
        this(type, null);
    }

    public PortalConfig(String type, String ownerId) {
        this(type, ownerId, null);
    }

    public PortalConfig(String type, String ownerId, String storageId) {
        super(storageId);
        this.type = type;
        this.name = ownerId;
        this.portalLayout = new Container();
    }

    public PortalConfig(PortalData data) {
        super(data.getStorageId());
        this.name = data.getName();
        this.type = data.getType();
        this.locale = data.getLocale();
        this.label = data.getLabel();
        this.description = data.getDescription();
        this.accessPermissions = data.getAccessPermissions().toArray(new String[data.getAccessPermissions().size()]);
        this.editPermission = data.getEditPermission();
        this.properties = new Properties(data.getProperties());
        this.skin = data.getSkin();
        this.portalLayout = new Container(data.getPortalLayout());
        this.portalRedirects = this.buildPortalRedirects(data.getRedirects());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String s) {
        this.locale = s;
    }

    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    public void setAccessPermissions(String[] s) {
        this.accessPermissions = s;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String getSkin() {
        if (this.skin == null || this.skin.length() < 1) {
            return "Default";
        }
        return this.skin;
    }

    public void setSkin(String s) {
        this.skin = s;
    }

    public Container getPortalLayout() {
        return this.portalLayout;
    }

    public void setPortalLayout(Container container) {
        this.portalLayout = container;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean b) {
        this.modifiable = b;
    }

    public void setPortalRedirects(ArrayList<PortalRedirect> portalRedirects) {
        this.portalRedirects = portalRedirects;
    }

    public ArrayList<PortalRedirect> getPortalRedirects() {
        if (this.portalRedirects == null) {
            this.portalRedirects = new ArrayList();
        }
        return this.portalRedirects;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.properties == null || !this.properties.containsKey(name)) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    public String getProperty(String name, String defaultValue) {
        if ("cacheControl".equals(name)) {
            return "no-cache";
        }
        if ("sharedLayout".equals(name)) {
            return "allUsers";
        }
        if ("viewport".equals(name)) {
            return null;
        }
        String value = this.getProperty(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void setProperty(String name, String value) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        this.properties.setProperty(name, value);
    }

    public void removeProperty(String name) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        this.properties.remove(name);
    }

    public String getSessionAlive() {
        return this.getProperty("sessionAlive", "onDemand");
    }

    public void setSessionAlive(String type) {
        this.setProperty("sessionAlive", type);
    }

    public Boolean isShowInfobar() {
        String value = this.getProperty("showPortletInfo", "1");
        if (Integer.parseInt(value) == 1) {
            return true;
        }
        return false;
    }

    public void setShowInfobar(Boolean value) {
        if (value.booleanValue()) {
            this.setProperty("showPortletInfo", "1");
        } else {
            this.setProperty("showPortletInfo", "0");
        }
    }

    public String getViewport() {
        return this.getProperty("viewport");
    }

    public void setViewport(String viewport) {
        this.setProperty("viewport", viewport);
    }

    public String getSharedLayout() {
        return this.getProperty("sharedLayout", "allUsers");
    }

    public void setSharedLayout(String type) {
        if (type.equals("adminsOnly")) {
            this.setProperty("sharedLayout", "adminsOnly");
        } else {
            this.setProperty("sharedLayout", "allUsers");
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "PortalConfig[name=" + this.name + ",type=" + this.type + "]";
    }

    private static Container initDefaultLayout() {
        Container container = new Container();
        ArrayList<ModelObject> children = new ArrayList<ModelObject>();
        children.add(new PageBody());
        container.setChildren(children);
        return container;
    }

    @Override
    public PortalData build() {
        List<String> accessPermissions = Utils.safeImmutableList(this.accessPermissions);
        Map<String, String> properties = Utils.safeImmutableMap(this.properties);
        return new PortalData(this.storageId, this.name, this.type, this.locale, this.label, this.description, accessPermissions, this.editPermission, properties, this.skin, this.portalLayout.build(), this.buildRedirectData());
    }

    private ArrayList<RedirectData> buildRedirectData() {
        if (this.portalRedirects != null) {
            ArrayList<RedirectData> redirects = new ArrayList<RedirectData>();
            for (PortalRedirect portalRedirect : this.portalRedirects) {
                redirects.add(portalRedirect.build());
            }
            return redirects;
        }
        return null;
    }

    private ArrayList<PortalRedirect> buildPortalRedirects(List<RedirectData> redirectsData) {
        if (redirectsData != null) {
            ArrayList<PortalRedirect> portalRedirects = new ArrayList<PortalRedirect>();
            for (RedirectData redirectData : redirectsData) {
                PortalRedirect portalRedirect = new PortalRedirect();
                portalRedirect.setName(redirectData.getRedirectName());
                portalRedirect.setRedirectSite(redirectData.getRedirectSiteName());
                portalRedirect.setEnabled(redirectData.isEnabled());
                portalRedirect.setConditions(this.buildRedirectConditions(redirectData.getConditions()));
                portalRedirect.setMappings(this.buildRedirectMappings(redirectData.getMappings()));
                portalRedirects.add(portalRedirect);
            }
            return portalRedirects;
        }
        return null;
    }

    private ArrayList<RedirectCondition> buildRedirectConditions(List<RedirectConditionData> conditionsData) {
        ArrayList<RedirectCondition> redirectConditions = new ArrayList<RedirectCondition>();
        for (RedirectConditionData conditionData : conditionsData) {
            RedirectCondition redirectCondition = conditionData.build();
            redirectConditions.add(redirectCondition);
        }
        return redirectConditions;
    }

    private RedirectMappings buildRedirectMappings(RedirectMappingsData mappingsData) {
        if (mappingsData != null) {
            return mappingsData.build();
        }
        return null;
    }

    public static /* synthetic */ PortalConfig JiBX_binding_newinstance_2_0(PortalConfig arg1, UnmarshallingContext arg2) throws JiBXException {
        if (arg1 == null) {
            arg1 = new PortalConfig();
        }
        return arg1;
    }

    public static /* synthetic */ PortalConfig JiBX_binding_unmarshal_2_0(PortalConfig arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushTrackedObject((Object)arg1);
        PortalConfig portalConfig = arg1;
        boolean[] var0 = new boolean[10];
        while (true) {
            if (arg2.isAt(null, "portal-name")) {
                if (var0[0]) {
                    arg2.throwNameException("Duplicate element ", null, "portal-name");
                }
                var0[0] = true;
                arg1.name = arg2.parseElementText(null, "portal-name");
                continue;
            }
            if (arg2.isAt(null, "label")) {
                if (var0[1]) {
                    arg2.throwNameException("Duplicate element ", null, "label");
                }
                var0[1] = true;
                arg1.label = arg2.parseElementText(null, "label");
                continue;
            }
            if (arg2.isAt(null, "description")) {
                if (var0[2]) {
                    arg2.throwNameException("Duplicate element ", null, "description");
                }
                var0[2] = true;
                arg1.description = arg2.parseElementText(null, "description");
                continue;
            }
            if (arg2.isAt(null, "locale")) {
                if (var0[3]) {
                    arg2.throwNameException("Duplicate element ", null, "locale");
                }
                var0[3] = true;
                arg1.locale = arg2.parseElementText(null, "locale");
                continue;
            }
            if (arg2.isAt(null, "access-permissions")) {
                if (var0[4]) {
                    arg2.throwNameException("Duplicate element ", null, "access-permissions");
                }
                var0[4] = true;
                String string = arg2.parseElementText(null, "access-permissions");
                arg1.accessPermissions = string == null ? null : JibxArraySerialize.deserializePermissions(string);
                continue;
            }
            if (arg2.isAt(null, "edit-permission")) {
                if (var0[5]) {
                    arg2.throwNameException("Duplicate element ", null, "edit-permission");
                }
                var0[5] = true;
                arg1.editPermission = arg2.parseElementText(null, "edit-permission");
                continue;
            }
            if (arg2.isAt(null, "skin")) {
                if (var0[6]) {
                    arg2.throwNameException("Duplicate element ", null, "skin");
                }
                var0[6] = true;
                arg1.skin = arg2.parseElementText(null, "skin");
                continue;
            }
            if (arg2.getUnmarshaller("org.exoplatform.portal.config.model.Properties").isPresent((IUnmarshallingContext)arg2)) {
                if (var0[7]) {
                    arg2.throwNameException("Duplicate element ", null, "properties");
                }
                var0[7] = true;
                arg1.properties = !arg2.getUnmarshaller("org.exoplatform.portal.config.model.Properties").isPresent((IUnmarshallingContext)arg2) ? null : (Properties)arg2.getUnmarshaller("org.exoplatform.portal.config.model.Properties").unmarshal((Object)arg1.properties, (IUnmarshallingContext)arg2);
                continue;
            }
            if (arg2.isAt(null, "portal-layout")) {
                if (var0[8]) {
                    arg2.throwNameException("Duplicate element ", null, "portal-layout");
                }
                var0[8] = true;
                if (arg2.isAt(null, "portal-layout")) {
                    arg2.parseToStartTag(null, "portal-layout");
                    arg1.portalLayout = Container.JiBX_binding_unmarshalAttr_2_0(Container.JiBX_binding_newinstance_2_0(arg1.portalLayout, arg2), arg2);
                    arg2.parsePastStartTag(null, "portal-layout");
                    arg1.portalLayout = Container.JiBX_binding_unmarshal_2_0(arg1.portalLayout, arg2);
                    arg2.parsePastCurrentEndTag(null, "portal-layout");
                    continue;
                }
                portalConfig = null;
                continue;
            }
            if (!arg2.isAt(null, "portal-redirects")) break;
            if (var0[9]) {
                arg2.throwNameException("Duplicate element ", null, "portal-redirects");
            }
            var0[9] = true;
            if (arg2.isAt(null, "portal-redirects")) {
                arg2.parsePastStartTag(null, "portal-redirects");
                arg1.setPortalRedirects(JiBX_bindingMungeAdapter.JiBX_binding_unmarshal_1_3(JiBX_bindingMungeAdapter.JiBX_binding_newinstance_1_0(arg1.getPortalRedirects(), arg2), arg2));
                arg2.parsePastCurrentEndTag(null, "portal-redirects");
                continue;
            }
            arg1.setPortalRedirects(null);
        }
        if (!var0[0]) {
            arg2.throwNameException("Missing required element ", null, "portal-name");
        }
        if (!var0[3]) {
            arg2.throwNameException("Missing required element ", null, "locale");
        }
        arg2.popObject();
        return arg1;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.portal.config.model.PortalConfig").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.portal.config.model.PortalConfig";
    }

    public static /* synthetic */ void JiBX_binding_marshal_2_0(PortalConfig arg1, MarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        MarshallingContext marshallingContext = arg2.element(0, "portal-name", arg1.name);
        if (arg1.label != null) {
            String string = arg1.label;
            if (!Utility.isEqual((Object)string, (Object)"")) {
                marshallingContext = marshallingContext.element(0, "label", string);
            }
        }
        if (arg1.description != null) {
            String string = arg1.description;
            if (!Utility.isEqual((Object)string, (Object)"")) {
                marshallingContext = marshallingContext.element(0, "description", string);
            }
        }
        MarshallingContext marshallingContext2 = marshallingContext.element(0, "locale", arg1.locale);
        if (arg1.accessPermissions != null) {
            String string = JibxArraySerialize.serializePermissions(arg1.accessPermissions);
            if (!Utility.isEqual((Object)string, (Object)"Everyone")) {
                marshallingContext2 = marshallingContext2.element(0, "access-permissions", string);
            }
        }
        if (arg1.editPermission != null) {
            marshallingContext2 = marshallingContext2.element(0, "edit-permission", arg1.editPermission);
        }
        if (arg1.skin != null) {
            marshallingContext2 = marshallingContext2.element(0, "skin", arg1.skin);
        }
        if (arg1.properties != null) {
            arg2.getMarshaller("org.exoplatform.portal.config.model.Properties").marshal((Object)arg1.properties, (IMarshallingContext)arg2);
        }
        if (arg1.portalLayout != null) {
            Container container = arg1.portalLayout;
            arg2.startTagAttributes(0, "portal-layout");
            Container.JiBX_binding_marshalAttr_2_0(container, arg2);
            arg2.closeStartContent();
            Container.JiBX_binding_marshal_2_0(container, arg2);
            arg2.endTag(0, "portal-layout");
        }
        if (arg1.getPortalRedirects() != null) {
            ArrayList<PortalRedirect> arrayList = arg1.getPortalRedirects();
            arg2.startTag(0, "portal-redirects");
            JiBX_bindingMungeAdapter.JiBX_binding_marshal_1_3(arrayList, arg2);
            arg2.endTag(0, "portal-redirects");
        }
        arg2.popObject();
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.portal.config.model.PortalConfig").marshal((Object)this, arg1);
    }

    public static class PortalConfigSet {
        private ArrayList<PortalConfig> portalConfigs;

        public ArrayList<PortalConfig> getPortalConfigs() {
            return this.portalConfigs;
        }

        public void setPortalConfigs(ArrayList<PortalConfig> list) {
            this.portalConfigs = list;
        }
    }
}

