/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.binding.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.JibxArraySerialize;
import org.exoplatform.portal.mop.management.binding.xml.DelimitedValueType;
import org.exoplatform.portal.mop.management.binding.xml.Element;
import org.exoplatform.portal.mop.management.binding.xml.Utils;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.portal.pom.spi.gadget.Gadget;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.portal.pom.spi.wsrp.WSRP;
import org.gatein.common.xml.stax.navigator.Exceptions;
import org.gatein.common.xml.stax.navigator.StaxNavUtils;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.gatein.common.xml.stax.writer.StaxWriterUtils;
import org.gatein.common.xml.stax.writer.WritableValueType;
import org.gatein.common.xml.stax.writer.WritableValueTypes;
import org.gatein.management.api.binding.Marshaller;
import org.staxnav.StaxNavigator;
import org.staxnav.ValueType;

public abstract class AbstractMarshaller<T>
implements Marshaller<T> {
    protected void marshalModelObject(StaxWriter<Element> writer, ModelObject modelObject) throws XMLStreamException {
        if (modelObject instanceof Application) {
            Application application = (Application)modelObject;
            ApplicationType type = application.getType();
            if (ApplicationType.PORTLET == type) {
                this.marshalPortletApplication(writer, this.safeCast(application, Portlet.class));
            } else if (ApplicationType.GADGET == type) {
                this.marshalGadgetApplication(writer, this.safeCast(application, Gadget.class));
            } else if (ApplicationType.WSRP_PORTLET == type) {
                this.marshalWsrpApplication(writer, this.safeCast(application, WSRP.class));
            }
        } else {
            if (modelObject instanceof Page) {
                throw new XMLStreamException("Unexpected PageData object. Storage id: " + modelObject.getStorageId());
            }
            if (modelObject instanceof Container) {
                this.marshalContainer(writer, (Container)modelObject);
            } else if (modelObject instanceof PageBody) {
                writer.writeStartElement((Object)Element.PAGE_BODY).writeEndElement();
            } else {
                throw new XMLStreamException("Unknown ComponentData type " + modelObject);
            }
        }
    }

    protected void marshalContainer(StaxWriter<Element> writer, Container container) throws XMLStreamException {
        writer.writeStartElement((Object)Element.CONTAINER);
        AbstractMarshaller.writeOptionalAttribute(writer, Attribute.ID, container.getId());
        AbstractMarshaller.writeOptionalAttribute(writer, Attribute.TEMPLATE, container.getTemplate());
        AbstractMarshaller.writeOptionalAttribute(writer, Attribute.WIDTH, container.getWidth());
        AbstractMarshaller.writeOptionalAttribute(writer, Attribute.HEIGHT, container.getHeight());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.NAME), (String)container.getName());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.TITLE), (String)container.getTitle());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.ICON), (String)container.getIcon());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.DESCRIPTION), (String)container.getDescription());
        this.marshalAccessPermissions(writer, container.getAccessPermissions());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.FACTORY_ID), (String)container.getFactoryId());
        this.marshalPermissions(writer, Element.MOVE_APPLICATIONS_PERMISSIONS, container.getMoveAppsPermissions());
        this.marshalPermissions(writer, Element.MOVE_CONTAINERS_PERMISSIONS, container.getMoveContainersPermissions());
        ArrayList<ModelObject> children = container.getChildren();
        for (ModelObject child : children) {
            this.marshalModelObject(writer, child);
        }
        writer.writeEndElement();
    }

    protected Container unmarshalContainer(StaxNavigator<Element> navigator) throws XMLStreamException {
        Container container = new Container();
        container.setId(navigator.getAttribute(Attribute.ID.getLocalName()));
        container.setTemplate(navigator.getAttribute(Attribute.TEMPLATE.getLocalName()));
        container.setWidth(navigator.getAttribute(Attribute.WIDTH.getLocalName()));
        container.setHeight(navigator.getAttribute(Attribute.HEIGHT.getLocalName()));
        Element current = (Element)((Object)navigator.child());
        block15: while (current != null) {
            switch (current) {
                case NAME: {
                    container.setName(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case TITLE: {
                    container.setTitle(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case ICON: {
                    container.setIcon(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case DESCRIPTION: {
                    container.setDescription(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case ACCESS_PERMISSIONS: {
                    container.setAccessPermissions(this.unmarshalAccessPermissions(navigator, false));
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case MOVE_APPLICATIONS_PERMISSIONS: {
                    container.setMoveAppsPermissions(this.unmarshalPermissions(navigator, false));
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case MOVE_CONTAINERS_PERMISSIONS: {
                    container.setMoveContainersPermissions(this.unmarshalPermissions(navigator, false));
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case FACTORY_ID: {
                    container.setFactoryId(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case CONTAINER: {
                    if (container.getChildren() == null) {
                        container.setChildren(new ArrayList<ModelObject>());
                    }
                    container.getChildren().add(this.unmarshalContainer((StaxNavigator<Element>)navigator.fork()));
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case PORTLET_APPLICATION: {
                    if (container.getChildren() == null) {
                        container.setChildren(new ArrayList<ModelObject>());
                    }
                    container.getChildren().add(this.unmarshalPortletApplication((StaxNavigator<Element>)navigator.fork()));
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case GADGET_APPLICATION: {
                    if (container.getChildren() == null) {
                        container.setChildren(new ArrayList<ModelObject>());
                    }
                    container.getChildren().add(this.unmarshalGadgetApplication((StaxNavigator<Element>)navigator.fork()));
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case PAGE_BODY: {
                    if (container.getChildren() == null) {
                        container.setChildren(new ArrayList<ModelObject>());
                    }
                    container.getChildren().add(new PageBody());
                    current = (Element)((Object)navigator.sibling());
                    continue block15;
                }
                case UNKNOWN: {
                    throw Exceptions.unknownElement(navigator);
                }
            }
            throw Exceptions.unexpectedElement(navigator);
        }
        return container;
    }

    protected void marshalPortletApplication(StaxWriter<Element> writer, Application<Portlet> portletApplication) throws XMLStreamException {
        Portlet portlet;
        String contentId;
        writer.writeStartElement((Object)Element.PORTLET_APPLICATION).writeStartElement((Object)Element.PORTLET);
        ApplicationState<Portlet> state = portletApplication.getState();
        if (state instanceof TransientApplicationState) {
            TransientApplicationState transientApplicationState = (TransientApplicationState)state;
            contentId = transientApplicationState.getContentId();
            portlet = (Portlet)transientApplicationState.getContentState();
        } else {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            if (container instanceof PortalContainer) {
                DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
                try {
                    portlet = dataStorage.load(state, ApplicationType.PORTLET);
                }
                catch (Exception e) {
                    throw new XMLStreamException("Could not obtain portlet state.");
                }
                try {
                    contentId = dataStorage.getId(state);
                }
                catch (Exception e) {
                    throw new XMLStreamException("Could not obtain contentId.", e);
                }
            }
            throw new XMLStreamException("Cannot marshal application state " + state + " outside the context of the portal.");
        }
        if (contentId == null) {
            throw new XMLStreamException("Portlet application ID was null.");
        }
        writer.writeElement((Object)Element.APPLICATION_REF, contentId.substring(0, contentId.indexOf("/")));
        writer.writeElement((Object)Element.PORTLET_REF, contentId.substring(contentId.indexOf("/") + 1, contentId.length()));
        if (portlet != null) {
            boolean prefsWritten = false;
            for (Preference preference : portlet) {
                if (!prefsWritten) {
                    writer.writeStartElement((Object)Element.PREFERENCES);
                    prefsWritten = true;
                }
                writer.writeStartElement((Object)Element.PREFERENCE);
                writer.writeElement((Object)Element.NAME, preference.getName());
                for (String value : preference.getValues()) {
                    StaxWriterUtils.writeOptionalContent(writer, (Object)((Object)Element.PREFERENCE_VALUE), (String)value);
                }
                writer.writeElement((Object)Element.PREFERENCE_READONLY, WritableValueTypes.BOOLEAN, (Object)preference.isReadOnly());
                writer.writeEndElement();
            }
            if (prefsWritten) {
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        this.marshalApplication(writer, portletApplication);
        writer.writeEndElement();
    }

    protected Application<?> unmarshalPortletApplication(StaxNavigator<Element> navigator) throws XMLStreamException {
        Application<Serializable> application;
        switch ((Element)((Object)navigator.child())) {
            case PORTLET: {
                ApplicationState<Portlet> state = this.unmarshalPortletApplicationState((StaxNavigator<Element>)navigator.fork());
                Application<Portlet> portlet = new Application<Portlet>(ApplicationType.PORTLET);
                portlet.setState(state);
                application = portlet;
                break;
            }
            case WSRP: {
                ApplicationState<WSRP> wsrpState = this.unmarshalWsrpApplicationState((StaxNavigator<Element>)navigator.fork());
                Application<WSRP> wsrp = new Application<WSRP>(ApplicationType.WSRP_PORTLET);
                wsrp.setState(wsrpState);
                application = wsrp;
                break;
            }
            case UNKNOWN: {
                throw Exceptions.unexpectedElement(navigator);
            }
            default: {
                throw Exceptions.unexpectedElement(navigator);
            }
        }
        return this.unmarshalApplication(navigator, application);
    }

    private ApplicationState<Portlet> unmarshalPortletApplicationState(StaxNavigator<Element> navigator) throws XMLStreamException {
        StaxNavUtils.requiresChild(navigator, (Object)((Object)Element.APPLICATION_REF));
        String applicationRef = StaxNavUtils.getRequiredContent(navigator, (boolean)true);
        StaxNavUtils.requiresSibling(navigator, (Object)((Object)Element.PORTLET_REF));
        String portletRef = StaxNavUtils.getRequiredContent(navigator, (boolean)true);
        PortletBuilder portletBuilder = null;
        if (navigator.sibling() == Element.PREFERENCES && navigator.child() == Element.PREFERENCE) {
            portletBuilder = new PortletBuilder();
            for (StaxNavigator fork : navigator.fork((Object)Element.PREFERENCE)) {
                StaxNavUtils.requiresChild((StaxNavigator)fork, (Object)((Object)Element.NAME));
                String prefName = StaxNavUtils.getRequiredContent((StaxNavigator)fork, (boolean)false);
                List<Object> values = null;
                while (fork.sibling() == Element.PREFERENCE_VALUE) {
                    if (values == null) {
                        values = new ArrayList<Object>();
                    }
                    values.add(StaxNavUtils.getContent((StaxNavigator)fork, (boolean)false));
                }
                if (values == null) {
                    values = Collections.singletonList(null);
                }
                Boolean readOnly = null;
                if (fork.getName() == Element.PREFERENCE_READONLY) {
                    readOnly = (Boolean)StaxNavUtils.parseRequiredContent((StaxNavigator)fork, (ValueType)ValueType.BOOLEAN);
                }
                if (fork.next() != null) {
                    throw Exceptions.unexpectedElement((StaxNavigator)fork);
                }
                if (readOnly == null) {
                    portletBuilder.add(prefName, values);
                    continue;
                }
                portletBuilder.add(prefName, values, (boolean)readOnly);
            }
        }
        TransientApplicationState<Portlet> state = new TransientApplicationState<Portlet>(applicationRef + "/" + portletRef);
        if (portletBuilder != null) {
            state.setContentState(portletBuilder.build());
        }
        return state;
    }

    protected void marshalGadgetApplication(StaxWriter<Element> writer, Application<Gadget> gadgetApplication) throws XMLStreamException {
        Gadget gadget;
        String contentId;
        writer.writeStartElement((Object)Element.GADGET_APPLICATION).writeStartElement((Object)Element.GADGET);
        ApplicationState<Gadget> state = gadgetApplication.getState();
        if (state instanceof TransientApplicationState) {
            TransientApplicationState transientApplicationState = (TransientApplicationState)state;
            contentId = transientApplicationState.getContentId();
            gadget = (Gadget)transientApplicationState.getContentState();
        } else {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            if (container instanceof PortalContainer) {
                ModelDataStorage dataStorage = (ModelDataStorage)container.getComponentInstanceOfType(ModelDataStorage.class);
                try {
                    gadget = dataStorage.load(state, ApplicationType.GADGET);
                }
                catch (Exception e) {
                    throw new XMLStreamException("Could not obtain gadget state from custom context.");
                }
                try {
                    contentId = dataStorage.getId(state);
                }
                catch (Exception e) {
                    throw new XMLStreamException("Could not obtain contentId from custom context.", e);
                }
            }
            throw new XMLStreamException("Cannot marshal application state " + state + " outside the context of the portal.");
        }
        if (contentId == null) {
            throw new XMLStreamException("Gadget content ID was null.");
        }
        writer.writeElement((Object)Element.GADGET_REF, contentId);
        if (gadget != null) {
            // empty if block
        }
        writer.writeEndElement();
        this.marshalApplication(writer, gadgetApplication);
        writer.writeEndElement();
    }

    protected Application<Gadget> unmarshalGadgetApplication(StaxNavigator<Element> navigator) throws XMLStreamException {
        StaxNavUtils.requiresChild(navigator, (Object)((Object)Element.GADGET));
        ApplicationState<Gadget> state = this.unmarshalGadgetApplicationState((StaxNavigator<Element>)navigator.fork());
        Application<Gadget> gadget = new Application<Gadget>(ApplicationType.GADGET);
        gadget.setState(state);
        return this.unmarshalApplication(navigator, gadget);
    }

    private ApplicationState<Gadget> unmarshalGadgetApplicationState(StaxNavigator<Element> navigator) throws XMLStreamException {
        StaxNavUtils.requiresChild(navigator, (Object)((Object)Element.GADGET_REF));
        String gadgetRef = StaxNavUtils.getRequiredContent(navigator, (boolean)true);
        Object gadget = null;
        if (navigator.next() != null) {
            throw Exceptions.unexpectedElement(navigator);
        }
        return new TransientApplicationState<Object>(gadgetRef, gadget);
    }

    protected void marshalWsrpApplication(StaxWriter<Element> writer, Application<WSRP> wsrpApplication) throws XMLStreamException {
        String contentId;
        writer.writeStartElement((Object)Element.PORTLET_APPLICATION);
        ApplicationState<WSRP> state = wsrpApplication.getState();
        if (state instanceof TransientApplicationState) {
            TransientApplicationState tas = (TransientApplicationState)state;
            contentId = tas.getContentId();
        } else {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            if (container instanceof PortalContainer) {
                DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
                try {
                    contentId = dataStorage.getId(state);
                }
                catch (Exception e) {
                    throw new XMLStreamException("Could not obtain contentId.", e);
                }
            } else {
                throw new XMLStreamException("Cannot marshal application state " + state + " outside the context of the portal.");
            }
        }
        writer.writeElement((Object)Element.WSRP, contentId);
        this.marshalApplication(writer, wsrpApplication);
        writer.writeEndElement();
    }

    private ApplicationState<WSRP> unmarshalWsrpApplicationState(StaxNavigator<Element> navigator) throws XMLStreamException {
        String portletId = StaxNavUtils.getRequiredContent(navigator, (boolean)true);
        if (navigator.next() != null) {
            throw Exceptions.unexpectedElement(navigator);
        }
        return new TransientApplicationState<Object>(portletId, null);
    }

    protected void marshalApplication(StaxWriter<Element> writer, Application<?> application) throws XMLStreamException {
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.THEME), (String)application.getTheme());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.TITLE), (String)application.getTitle());
        this.marshalAccessPermissions(writer, application.getAccessPermissions());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.SHOW_INFO_BAR), (String)String.valueOf(application.getShowInfoBar()));
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.SHOW_APPLICATION_STATE), (String)String.valueOf(application.getShowApplicationState()));
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.SHOW_APPLICATION_MODE), (String)String.valueOf(application.getShowApplicationMode()));
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.DESCRIPTION), (String)application.getDescription());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.ICON), (String)application.getIcon());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.WIDTH), (String)application.getWidth());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.HEIGHT), (String)application.getHeight());
    }

    protected <S> Application<S> unmarshalApplication(StaxNavigator<Element> navigator, Application<S> application) throws XMLStreamException {
        boolean showInfoBarParsed = false;
        Element current = (Element)((Object)navigator.sibling());
        block13: while (current != null) {
            switch (current) {
                case THEME: {
                    application.setTheme(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block13;
                }
                case TITLE: {
                    application.setTitle(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block13;
                }
                case ACCESS_PERMISSIONS: {
                    application.setAccessPermissions(this.unmarshalAccessPermissions(navigator, true));
                    current = (Element)((Object)navigator.sibling());
                    continue block13;
                }
                case SHOW_INFO_BAR: {
                    application.setShowInfoBar((Boolean)StaxNavUtils.parseRequiredContent(navigator, (ValueType)ValueType.BOOLEAN));
                    showInfoBarParsed = true;
                    current = (Element)((Object)navigator.sibling());
                    continue block13;
                }
                case SHOW_APPLICATION_STATE: {
                    application.setShowApplicationState((Boolean)navigator.parseContent(ValueType.BOOLEAN));
                    current = (Element)((Object)navigator.sibling());
                    continue block13;
                }
                case SHOW_APPLICATION_MODE: {
                    application.setShowApplicationMode((Boolean)navigator.parseContent(ValueType.BOOLEAN));
                    current = (Element)((Object)navigator.sibling());
                    continue block13;
                }
                case DESCRIPTION: {
                    application.setDescription(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block13;
                }
                case ICON: {
                    application.setIcon(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block13;
                }
                case WIDTH: {
                    application.setWidth(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block13;
                }
                case HEIGHT: {
                    application.setHeight(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block13;
                }
                case UNKNOWN: {
                    throw Exceptions.unknownElement(navigator);
                }
            }
            throw Exceptions.unexpectedElement(navigator);
        }
        if (application.getAccessPermissions() == null) {
            throw Exceptions.expectedElement(navigator, (Object)((Object)Element.ACCESS_PERMISSIONS));
        }
        if (!showInfoBarParsed) {
            throw Exceptions.expectedElement(navigator, (Object)((Object)Element.SHOW_INFO_BAR));
        }
        return application;
    }

    protected void marshalAccessPermissions(StaxWriter<Element> writer, String[] accessPermissions) throws XMLStreamException {
        accessPermissions = accessPermissions == null || accessPermissions.length == 0 ? null : accessPermissions;
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.ACCESS_PERMISSIONS), (WritableValueType)DelimitedValueType.SEMI_COLON, (Object)accessPermissions);
    }

    protected void marshalPermissions(StaxWriter<Element> writer, Element element, String[] accessPermissions) throws XMLStreamException {
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)element), (String)JibxArraySerialize.serializePermissions(accessPermissions));
    }

    protected String[] unmarshalAccessPermissions(StaxNavigator<Element> navigator, boolean required) throws XMLStreamException {
        if (required) {
            return Utils.tidyUp((String[])StaxNavUtils.parseRequiredContent(navigator, (ValueType)DelimitedValueType.SEMI_COLON));
        }
        return Utils.tidyUp((String[])StaxNavUtils.parseContent(navigator, (ValueType)DelimitedValueType.SEMI_COLON, null));
    }

    protected String[] unmarshalPermissions(StaxNavigator<Element> navigator, boolean required) throws XMLStreamException {
        String content = (String)StaxNavUtils.parseContent(navigator, (ValueType)DelimitedValueType.TRIMMED_STRING, null);
        if (required && content == null) {
            throw Exceptions.contentRequired(navigator);
        }
        return JibxArraySerialize.deserializePermissions(content);
    }

    protected void marshalEditPermission(StaxWriter<Element> writer, String editPermission) throws XMLStreamException {
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.EDIT_PERMISSION), (String)editPermission);
    }

    protected String unmarshalEditPermission(StaxNavigator<Element> navigator) throws XMLStreamException {
        return StaxNavUtils.getContent(navigator, (boolean)true);
    }

    protected void writeGateinObjectsNamespace(StaxWriter<Element> writer) throws XMLStreamException {
        Utils.writeGateinObjectsNamespace(writer);
    }

    private <S> Application<S> safeCast(Application<?> application, Class<S> stateClass) {
        return application;
    }

    private static void writeOptionalAttribute(StaxWriter<?> writer, Attribute attribute, String value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        writer.writeAttribute(attribute.getLocalName(), value);
    }

    private static enum Attribute {
        ID("id"),
        TEMPLATE("template"),
        WIDTH("width"),
        HEIGHT("height");

        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }
    }
}

