/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config.tasks;

import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMTask;
import org.exoplatform.portal.pom.data.DashboardData;
import org.exoplatform.portal.pom.data.Mapper;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.ui.UIContainer;

public abstract class DashboardTask {

    public static class Save
    implements POMTask<Void> {
        protected final DashboardData dashboard;

        public Save(DashboardData dashboard) {
            if (dashboard == null) {
                throw new NullPointerException("No null dashboard accepted");
            }
            if (dashboard.getStorageId() == null) {
                throw new IllegalArgumentException("No dashboard with null storage id accepted");
            }
            this.dashboard = dashboard;
        }

        @Override
        public Void run(POMSession session) {
            String id = this.dashboard.getStorageId();
            if (id == null) {
                throw new IllegalArgumentException();
            }
            UIContainer container = (UIContainer)session.findObjectById(ObjectType.CONTAINER, id);
            if (container == null) {
                throw new IllegalArgumentException();
            }
            Mapper mapper = new Mapper(session);
            mapper.saveDashboard(this.dashboard, container);
            return null;
        }

        public String toString() {
            return "DashboardTask.Save[id=" + this.dashboard.getStorageId() + "]";
        }
    }

    public static class Load
    implements POMTask<DashboardData> {
        protected final String storageId;

        public Load(String storageId) {
            this.storageId = storageId;
        }

        @Override
        public DashboardData run(POMSession session) {
            UIContainer container = (UIContainer)session.findObjectById(ObjectType.CONTAINER, this.storageId);
            if (container != null) {
                return new Mapper(session).loadDashboard(container);
            }
            return null;
        }

        public String toString() {
            return "DashboardTask.Load[id=" + this.storageId + "]";
        }
    }
}

