/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.cache.MembershipCacheKey;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableGroupHandlerImpl
implements GroupHandler {
    private final ExoCache<String, Object> groupCache;
    private final ExoCache membershipCache;
    private final GroupHandler groupHandler;

    public CacheableGroupHandlerImpl(OrganizationCacheHandler organizationCacheHandler, GroupHandler handler) {
        this.groupCache = organizationCacheHandler.getGroupCache();
        this.membershipCache = organizationCacheHandler.getMembershipCache();
        this.groupHandler = handler;
    }

    @Override
    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        this.groupHandler.addChild(parent, child, broadcast);
    }

    @Override
    public void addGroupEventListener(GroupEventListener listener) {
        this.groupHandler.addGroupEventListener(listener);
    }

    @Override
    public void removeGroupEventListener(GroupEventListener listener) {
        this.groupHandler.removeGroupEventListener(listener);
    }

    @Override
    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.groupHandler.createGroup(group, broadcast);
    }

    @Override
    public Group createGroupInstance() {
        return this.groupHandler.createGroupInstance();
    }

    @Override
    public Group findGroupById(String groupId) throws Exception {
        Group group = (Group)this.groupCache.get((Serializable)((Object)groupId));
        if (group != null) {
            return group;
        }
        group = this.groupHandler.findGroupById(groupId);
        if (group != null) {
            this.groupCache.put((Serializable)((Object)groupId), (Object)group);
        }
        return group;
    }

    @Override
    public Collection<Group> findGroupByMembership(String userName, String membershipType) throws Exception {
        Collection<Group> groups = this.groupHandler.findGroupByMembership(userName, membershipType);
        for (Group group : groups) {
            this.groupCache.put((Serializable)((Object)group.getId()), groups);
        }
        return groups;
    }

    @Override
    public Collection<Group> resolveGroupByMembership(String userName, String membershipType) throws Exception {
        Collection<Group> groups = this.groupHandler.resolveGroupByMembership(userName, membershipType);
        for (Group group : groups) {
            this.groupCache.put((Serializable)((Object)group.getId()), groups);
        }
        return groups;
    }

    @Override
    public Collection<Group> findGroups(Group parent) throws Exception {
        Collection<Group> groups = this.groupHandler.findGroups(parent);
        for (Group group : groups) {
            this.groupCache.put((Serializable)((Object)group.getId()), groups);
        }
        return groups;
    }

    @Override
    public Collection<Group> findGroupsOfUser(String user) throws Exception {
        Collection<Group> groups = this.groupHandler.findGroupsOfUser(user);
        for (Group group : groups) {
            this.groupCache.put((Serializable)((Object)group.getId()), groups);
        }
        return groups;
    }

    @Override
    public Collection<Group> getAllGroups() throws Exception {
        Collection<Group> groups = this.groupHandler.getAllGroups();
        for (Group group : groups) {
            this.groupCache.put((Serializable)((Object)group.getId()), groups);
        }
        return groups;
    }

    @Override
    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        Group gr = this.groupHandler.removeGroup(group, broadcast);
        if (gr != null) {
            this.groupCache.remove((Serializable)((Object)gr.getId()));
            List memberships = this.membershipCache.getCachedObjects();
            for (Membership membership : memberships) {
                if (!membership.getGroupId().equals(gr.getId())) continue;
                this.membershipCache.remove((Serializable)((Object)membership.getId()));
                this.membershipCache.remove((Serializable)new MembershipCacheKey(membership));
            }
        }
        return gr;
    }

    @Override
    public void saveGroup(Group group, boolean broadcast) throws Exception {
        this.groupHandler.saveGroup(group, broadcast);
        this.groupCache.put((Serializable)((Object)group.getId()), (Object)group);
    }
}

