/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.social;

import java.io.IOException;
import java.net.URL;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.utils.HttpResponseContext;
import org.gatein.security.oauth.utils.OAuthUtils;
import org.json.JSONException;

abstract class FacebookRequest<T> {
    private static Logger log = LoggerFactory.getLogger(FacebookRequest.class);

    FacebookRequest() {
    }

    protected abstract URL createURL(String var1) throws IOException;

    protected abstract T parseResponse(String var1) throws JSONException;

    public T executeRequest(String accessToken) {
        try {
            URL url = this.createURL(accessToken);
            HttpResponseContext httpResponse = OAuthUtils.readUrlContent(url.openConnection());
            if (httpResponse.getResponseCode() == 200) {
                return this.parseResponse(httpResponse.getResponse());
            }
            if (httpResponse.getResponseCode() == 400) {
                String errorMessage = "Error when obtaining content from Facebook. Error details: " + httpResponse.getResponse();
                log.warn((Object)errorMessage);
                throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, errorMessage);
            }
            String errorMessage = "Unspecified IO error. Http response code: " + httpResponse.getResponseCode() + ", details: " + httpResponse.getResponse();
            log.warn((Object)errorMessage);
            throw new OAuthException(OAuthExceptionCode.IO_ERROR, errorMessage);
        }
        catch (JSONException e) {
            throw new OAuthException(OAuthExceptionCode.IO_ERROR, (Throwable)e);
        }
        catch (IOException e) {
            throw new OAuthException(OAuthExceptionCode.IO_ERROR, (Throwable)e);
        }
    }
}

