/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;

public class WCMConfigurationService {
    public static final String SITE_PATH_EXP = "\\{sitePath\\}";
    public static final String SITE_NAME_EXP = "\\{siteName\\}";
    public static final String PARAMETERIZED_PAGE_URI = "parameterizedPageURI";
    public static final String PRINT_PAGE_URI = "printPageURI";
    public static final String PRINT_VIEWER_PAGE = "printViewerPage";
    public static final String EDITOR_PAGE_URI = "editorPageURI";
    public static final String EDIT_PAGE_URI = "editPageURI";
    public static final String SITE_EXPLORER_URI = "siteExplorerURI";
    public static final String CREATE_WIKI_PAGE_URI = "createWikiPageURI";
    public static final String CLV_PORTLET = "CLVPortlet";
    public static final String SCV_PORTLET = "SCVPortlet";
    public static final String FORM_VIEW_TEMPLATE_PATH = "formViewTemplatePath";
    public static final String PAGINATOR_TEMPLAET_PATH = "paginatorTemplatePath";
    private static final Log LOG = ExoLogger.getLogger((String)WCMConfigurationService.class.getName());
    private NodeLocation livePortalsLocation = null;
    private ExoProperties runtimeContextParams;
    private DriveData siteDriveConfig;
    private String sharedPortal = null;

    public WCMConfigurationService(InitParams initParams, RepositoryService repoService) throws Exception {
        Iterator iterator = initParams.getPropertiesParamIterator();
        while (iterator.hasNext()) {
            PropertiesParam param = (PropertiesParam)iterator.next();
            if ("share.portal.config".endsWith(param.getName())) {
                String portalName;
                this.sharedPortal = portalName = param.getProperty("portalName");
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)("Name of shared portal to share resources for all portals in repository is: " + portalName));
                continue;
            }
            if (!"RuntimeContextParams".equalsIgnoreCase(param.getName())) continue;
            this.runtimeContextParams = param.getProperties();
        }
        Iterator locations = initParams.getObjectParamIterator();
        while (locations.hasNext()) {
            ObjectParameter objectParameter = (ObjectParameter)locations.next();
            if ("live.portals.location.config".equals(objectParameter.getName())) {
                NodeLocation objectParam;
                this.livePortalsLocation = objectParam = (NodeLocation)objectParameter.getObject();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Location that resources for all live portal is stored in repository is in workspace: " + objectParam.getWorkspace() + " and with path: " + objectParam.getPath()));
                }
            }
            if (!"site.drive.config".equals(objectParameter.getName())) continue;
            this.siteDriveConfig = (DriveData)objectParameter.getObject();
        }
    }

    public DriveData getSiteDriveConfig() {
        return this.siteDriveConfig;
    }

    public NodeLocation getLivePortalsLocation() {
        return this.livePortalsLocation;
    }

    public String getRuntimeContextParam(String paramName) {
        if (this.runtimeContextParams != null) {
            return (String)this.runtimeContextParams.get((Object)paramName);
        }
        return null;
    }

    public Collection<String> getRuntimeContextParams() {
        if (this.runtimeContextParams != null) {
            return this.runtimeContextParams.values();
        }
        return null;
    }

    public String getSharedPortalName() {
        return this.sharedPortal;
    }

    public Collection<NodeLocation> getAllLivePortalsLocation() {
        return Arrays.asList(this.livePortalsLocation);
    }
}

