/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.web.redirect;

import java.util.Map;
import org.exoplatform.portal.config.model.RedirectMappings;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.GenericScope;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class Mapper {
    protected static Logger log = LoggerFactory.getLogger(Mapper.class);
    NavigationService navService;

    public Mapper(NavigationService navService) {
        this.navService = navService;
    }

    public String getRedirectPath(String originSite, String redirectSite, String originalRequestPath, RedirectMappings redirectMappings) {
        return this.getRequestPath(originSite, redirectSite, originalRequestPath, redirectMappings);
    }

    protected String getRequestPath(String originSite, String redirectSite, String requestPath, RedirectMappings redirectMappings) {
        String redirectRequestPath;
        if (redirectMappings == null) {
            return null;
        }
        Map mappings = redirectMappings.getMap();
        if (mappings != null) {
            redirectRequestPath = (String)mappings.get(requestPath);
            if (redirectRequestPath == null) {
                redirectRequestPath = requestPath.startsWith("/") ? (String)mappings.get(requestPath.substring(1)) : (String)mappings.get("/" + requestPath);
            }
            if (redirectRequestPath != null) {
                if (redirectRequestPath.startsWith("/")) {
                    return redirectRequestPath;
                }
                return "/" + redirectRequestPath;
            }
        }
        if (redirectMappings.isUseNodeNameMatching() && (redirectRequestPath = this.getNodeIfExists(redirectSite, requestPath, redirectMappings.getUnresolvedNode() == RedirectMappings.UnknownNodeMapping.COMMON_ANCESTOR_NAME_MATCH)) != null) {
            if (redirectRequestPath.startsWith("/")) {
                return redirectRequestPath;
            }
            return "/" + redirectRequestPath;
        }
        if (redirectMappings.getUnresolvedNode() == RedirectMappings.UnknownNodeMapping.NO_REDIRECT) {
            return null;
        }
        if (redirectMappings.getUnresolvedNode() == RedirectMappings.UnknownNodeMapping.REDIRECT) {
            if (requestPath.startsWith("/")) {
                return requestPath;
            }
            return "/" + requestPath;
        }
        if (redirectMappings.getUnresolvedNode() == RedirectMappings.UnknownNodeMapping.ROOT) {
            return "/";
        }
        log.warn((Object)("Unknown redirect configuration option for an unknown node [" + redirectMappings.getUnresolvedNode() + "]. Will not perform redirect."));
        return null;
    }

    protected String getNodeIfExists(String redirectSite, String requestPath, Boolean useCommonAncestor) {
        log.info((Object)("GetNodeExits called [" + redirectSite + "] : [" + requestPath + "]"));
        NavigationContext navContext = null;
        if (redirectSite == null || this.navService == null) {
            log.warn((Object)("Redirect site name [" + redirectSite + "] or the navigation service object [" + this.navService + "] is null. Cannot perform redirect."));
            return null;
        }
        navContext = this.navService.loadNavigation(SiteKey.portal((String)redirectSite));
        if (navContext == null) {
            log.warn((Object)("Cannot preform redirect since can't retrieve navigation for site : " + redirectSite));
            return null;
        }
        if (requestPath == null || requestPath.isEmpty() || requestPath.equals("/")) {
            return "/";
        }
        String[] path = new String[]{};
        path = requestPath.startsWith("/") ? requestPath.substring(1).split("/") : requestPath.split("/");
        NodeContext nodeContext = this.navService.loadNode(NodeModel.SELF_MODEL, navContext, GenericScope.branchShape((String[])path, (Scope)Scope.ALL), null);
        boolean found = true;
        String lastCommonAncestor = "/";
        for (String nodeName : path) {
            if ((nodeContext = nodeContext.get(nodeName)) == null) {
                found = false;
                break;
            }
            lastCommonAncestor = lastCommonAncestor.equals("/") ? lastCommonAncestor + nodeContext.getName() : lastCommonAncestor + "/" + nodeContext.getName();
        }
        if (found) {
            if (requestPath.startsWith("/")) {
                return requestPath;
            }
            return "/" + requestPath;
        }
        if (useCommonAncestor.booleanValue()) {
            return lastCommonAncestor;
        }
        return null;
    }
}

