/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.AtomicBooleanDeserializer;
import com.fasterxml.jackson.databind.deser.std.ByteBufferDeserializer;
import com.fasterxml.jackson.databind.deser.std.CharsetDeserializer;
import com.fasterxml.jackson.databind.deser.std.ClassDeserializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.deser.std.InetAddressDeserializer;
import com.fasterxml.jackson.databind.deser.std.InetSocketAddressDeserializer;
import com.fasterxml.jackson.databind.deser.std.StackTraceElementDeserializer;
import com.fasterxml.jackson.databind.deser.std.UUIDDeserializer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (!_classNames.contains(string)) {
            return null;
        }
        if (clazz == URI.class) {
            return URIDeserializer.instance;
        }
        if (clazz == URL.class) {
            return URLDeserializer.instance;
        }
        if (clazz == File.class) {
            return FileDeserializer.instance;
        }
        if (clazz == UUID.class) {
            return UUIDDeserializer.instance;
        }
        if (clazz == Currency.class) {
            return CurrencyDeserializer.instance;
        }
        if (clazz == Pattern.class) {
            return PatternDeserializer.instance;
        }
        if (clazz == Locale.class) {
            return LocaleDeserializer.instance;
        }
        if (clazz == InetAddress.class) {
            return InetAddressDeserializer.instance;
        }
        if (clazz == InetSocketAddress.class) {
            return InetSocketAddressDeserializer.instance;
        }
        if (clazz == Charset.class) {
            return new CharsetDeserializer();
        }
        if (clazz == Class.class) {
            return ClassDeserializer.instance;
        }
        if (clazz == StackTraceElement.class) {
            return StackTraceElementDeserializer.instance;
        }
        if (clazz == AtomicBoolean.class) {
            return AtomicBooleanDeserializer.instance;
        }
        if (clazz == ByteBuffer.class) {
            return new ByteBufferDeserializer();
        }
        throw new IllegalArgumentException("Internal error: can't find deserializer for " + string);
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{UUID.class, URL.class, URI.class, File.class, Currency.class, Pattern.class, Locale.class, InetAddress.class, InetSocketAddress.class, Charset.class, AtomicBoolean.class, Class.class, StackTraceElement.class, ByteBuffer.class}) {
            _classNames.add(clazz.getName());
        }
    }

    public static class FileDeserializer
    extends FromStringDeserializer<File> {
        public static final FileDeserializer instance = new FileDeserializer();

        public FileDeserializer() {
            super(File.class);
        }

        @Override
        protected File _deserialize(String string, DeserializationContext deserializationContext) {
            return new File(string);
        }
    }

    protected static class LocaleDeserializer
    extends FromStringDeserializer<Locale> {
        public static final LocaleDeserializer instance = new LocaleDeserializer();

        public LocaleDeserializer() {
            super(Locale.class);
        }

        @Override
        protected Locale _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            int n = string.indexOf(95);
            if (n < 0) {
                return new Locale(string);
            }
            String string2 = string.substring(0, n);
            if ((n = (string = string.substring(n + 1)).indexOf(95)) < 0) {
                return new Locale(string2, string);
            }
            String string3 = string.substring(0, n);
            return new Locale(string2, string3, string.substring(n + 1));
        }
    }

    public static class PatternDeserializer
    extends FromStringDeserializer<Pattern> {
        public static final PatternDeserializer instance = new PatternDeserializer();

        public PatternDeserializer() {
            super(Pattern.class);
        }

        @Override
        protected Pattern _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return Pattern.compile(string);
        }
    }

    public static class CurrencyDeserializer
    extends FromStringDeserializer<Currency> {
        public static final CurrencyDeserializer instance = new CurrencyDeserializer();

        public CurrencyDeserializer() {
            super(Currency.class);
        }

        @Override
        protected Currency _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return Currency.getInstance(string);
        }
    }

    public static class URIDeserializer
    extends FromStringDeserializer<URI> {
        public static final URIDeserializer instance = new URIDeserializer();

        public URIDeserializer() {
            super(URI.class);
        }

        @Override
        protected URI _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return URI.create(string);
        }
    }

    public static class URLDeserializer
    extends FromStringDeserializer<URL> {
        public static final URLDeserializer instance = new URLDeserializer();

        public URLDeserializer() {
            super(URL.class);
        }

        @Override
        protected URL _deserialize(String string, DeserializationContext deserializationContext) throws IOException {
            return new URL(string);
        }
    }
}

